/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.monitoring.mbeans;

import org.apache.helix.monitoring.StatCollector;
import org.apache.helix.monitoring.mbeans.MessageQueueMonitorMBean;
import org.apache.log4j.Logger;

public class MessageQueueMonitor
implements MessageQueueMonitorMBean {
    private static final Logger LOG = Logger.getLogger(MessageQueueMonitor.class);
    private final StatCollector _messageQueueSizeStat;
    private final String _clusterName;
    private final String _instanceName;

    public MessageQueueMonitor(String clusterName, String instanceName) {
        this._clusterName = clusterName;
        this._instanceName = instanceName;
        this._messageQueueSizeStat = new StatCollector();
    }

    public void addMessageQueueSize(long size) {
        this._messageQueueSizeStat.addData(size);
    }

    public void reset() {
        this._messageQueueSizeStat.reset();
    }

    @Override
    public double getMaxMessageQueueSize() {
        return this._messageQueueSizeStat.getMax();
    }

    @Override
    public double getMeanMessageQueueSize() {
        return this._messageQueueSizeStat.getMean();
    }

    @Override
    public String getSensorName() {
        return "MessageQueueStatus_" + this._clusterName + "_" + this._instanceName;
    }
}

