/*
 * Decompiled with CFR 0.152.
 */
package org.kie.provider.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.enterprise.context.SessionScoped;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import org.jboss.errai.security.shared.api.Group;
import org.jboss.errai.security.shared.api.Role;
import org.jboss.errai.security.shared.api.identity.User;
import org.kie.internal.identity.IdentityProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SessionScoped
public class SafeIdentityProvider
implements IdentityProvider,
Serializable {
    private static final Logger logger = LoggerFactory.getLogger(SafeIdentityProvider.class);
    private static final long serialVersionUID = 7709094889603436905L;
    @Inject
    private Instance<User> identityInstance;
    @Inject
    private Instance<HttpServletRequest> request;

    public String getName() {
        if (this.identityInstance.isUnsatisfied()) {
            return this.getIdentityFromRequest();
        }
        try {
            return ((User)this.identityInstance.get()).getIdentifier();
        }
        catch (Exception e) {
            logger.debug("Error on getting identity from User bean: " + e.getMessage(), (Throwable)e);
            return this.getIdentityFromRequest();
        }
    }

    private String getIdentityFromRequest() {
        if (!this.request.isUnsatisfied() && ((HttpServletRequest)this.request.get()).getUserPrincipal() != null) {
            return ((HttpServletRequest)this.request.get()).getUserPrincipal().getName();
        }
        return "unknown";
    }

    public List<String> getRoles() {
        ArrayList<String> roles = new ArrayList<String>();
        if (this.identityInstance.isUnsatisfied()) {
            return roles;
        }
        User identity = (User)this.identityInstance.get();
        Set ufRoles = identity.getRoles();
        for (Role role : ufRoles) {
            roles.add(role.getName());
        }
        Set ufGroups = identity.getGroups();
        for (Group group : ufGroups) {
            roles.add(group.getName());
        }
        return roles;
    }

    public boolean hasRole(String role) {
        if (this.request.isUnsatisfied()) {
            return ((HttpServletRequest)this.request.get()).isUserInRole(role);
        }
        return this.getRoles().contains(role);
    }
}

