/*
 * Decompiled with CFR 0.152.
 */
package org.kie.karaf.itest.blueprint;

import java.io.InputStream;
import javax.inject.Inject;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.karaf.itest.AbstractKarafIntegrationTest;
import org.ops4j.pax.exam.Configuration;
import org.ops4j.pax.exam.CoreOptions;
import org.ops4j.pax.exam.Option;
import org.ops4j.pax.exam.junit.PaxExam;
import org.ops4j.pax.exam.karaf.options.KarafDistributionOption;
import org.ops4j.pax.exam.karaf.options.LogLevelOption;
import org.ops4j.pax.exam.options.UrlReference;
import org.ops4j.pax.exam.spi.reactors.ExamReactorStrategy;
import org.ops4j.pax.exam.spi.reactors.PerClass;
import org.ops4j.pax.tinybundles.core.TinyBundles;

@RunWith(value=PaxExam.class)
@ExamReactorStrategy(value={PerClass.class})
public class KieBlueprintProcessDependencyKarafIntegrationTest
extends AbstractKarafIntegrationTest {
    private static final String BLUEPRINT_XML_LOCATION = "/org/kie/karaf/itest/blueprint/kie-beans-blueprint-process-dep.xml";
    private static final String DRL_LOCATION = "/blueprint_process_dep/sampleRule.drl";
    private static final String BPMN_LOCATION = "/blueprint_process_dep/sampleProcess.bpmn2";
    private static final String PROCESS_ID = "orderApproval";
    @Inject
    private KieSession kieSession;

    @Test
    public void testKieBase() throws Exception {
        Assert.assertNotNull((Object)this.kieSession);
        Assert.assertTrue((String)"KieBase contains no packages?", (this.kieSession.getKieBase().getKiePackages().size() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testStartProcess() throws Exception {
        Assert.assertNotNull((Object)this.kieSession);
        ProcessInstance processInstance = this.kieSession.startProcess(PROCESS_ID);
        Assert.assertEquals((String)"Unexpected process instance state.", (long)2L, (long)processInstance.getState());
    }

    @Configuration
    public static Option[] configure() {
        return new Option[]{KieBlueprintProcessDependencyKarafIntegrationTest.getKarafDistributionOption(), KarafDistributionOption.keepRuntimeFolder(), KarafDistributionOption.configureConsole().ignoreLocalConsole(), KarafDistributionOption.logLevel((LogLevelOption.LogLevel)LogLevelOption.LogLevel.WARN), KieBlueprintProcessDependencyKarafIntegrationTest.loadKieFeatures("jbpm", "kie-aries-blueprint"), CoreOptions.wrappedBundle((UrlReference)CoreOptions.mavenBundle().groupId("junit").artifactId("junit").versionAsInProject()), (Option)CoreOptions.streamBundle((InputStream)TinyBundles.bundle().add("OSGI-INF/blueprint/kie-beans-blueprint-process-dep.xml", KieBlueprintProcessDependencyKarafIntegrationTest.class.getResource(BLUEPRINT_XML_LOCATION)).add("blueprint_process_dep/sampleRule.drl", KieBlueprintProcessDependencyKarafIntegrationTest.class.getResource(DRL_LOCATION)).add("blueprint_process_dep/sampleProcess.bpmn2", KieBlueprintProcessDependencyKarafIntegrationTest.class.getResource(BPMN_LOCATION)).set("Import-Package", "org.kie.aries.blueprint,org.kie.aries.blueprint.factorybeans,org.kie.aries.blueprint.helpers,org.kie.api,org.kie.api.runtime,org.junit,*").set("Bundle-SymbolicName", "Test-Blueprint-Bundle").build()).start()};
    }
}

