/*
 * Decompiled with CFR 0.152.
 */
package org.kie.karaf.itest;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.api.KieBase;
import org.kie.api.KieServices;
import org.kie.api.builder.Results;
import org.kie.api.io.KieResources;
import org.kie.api.runtime.KieContainer;
import org.kie.dmn.api.core.DMNRuntime;
import org.kie.internal.utils.KieHelper;
import org.kie.karaf.itest.AbstractKarafIntegrationTest;
import org.ops4j.pax.exam.Configuration;
import org.ops4j.pax.exam.Option;
import org.ops4j.pax.exam.junit.PaxExam;
import org.ops4j.pax.exam.karaf.options.KarafDistributionOption;
import org.ops4j.pax.exam.karaf.options.LogLevelOption;
import org.ops4j.pax.exam.spi.reactors.ExamReactorStrategy;
import org.ops4j.pax.exam.spi.reactors.PerClass;

@RunWith(value=PaxExam.class)
@ExamReactorStrategy(value={PerClass.class})
public class KieDMNKarafIntegrationTest
extends AbstractKarafIntegrationTest {
    private static final String SIMPLE_DMN_FILE = "/kie-dmn/FunctionDefinition.dmn";
    private final KieServices ks = KieServices.Factory.get();
    private final KieResources kieResources = this.ks.getResources();
    private ClassLoader origTCCL;

    @Before
    public void setTCCL() {
        this.origTCCL = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(Object.class.getClassLoader());
    }

    @After
    public void restoreTCCL() {
        Thread.currentThread().setContextClassLoader(this.origTCCL);
    }

    @Test
    public void testDMNbasic() throws Exception {
        DMNRuntime runtime = this.createKieDMNRuntime(SIMPLE_DMN_FILE);
        Assert.assertTrue((runtime.getModels().size() > 0 ? 1 : 0) != 0);
    }

    @Configuration
    public static Option[] configure() {
        return new Option[]{KieDMNKarafIntegrationTest.getKarafDistributionOption(), KarafDistributionOption.keepRuntimeFolder(), KarafDistributionOption.configureConsole().ignoreLocalConsole(), KarafDistributionOption.logLevel((LogLevelOption.LogLevel)LogLevelOption.LogLevel.WARN), KieDMNKarafIntegrationTest.loadKieFeatures("kie-dmn")};
    }

    private DMNRuntime createKieDMNRuntime(String ... resourcePaths) {
        KieHelper kieHelper = new KieHelper();
        ClassLoader bundleClassloader = this.getClass().getClassLoader();
        kieHelper.setClassLoader(bundleClassloader);
        for (String resourcePath : resourcePaths) {
            kieHelper.addResource(this.kieResources.newUrlResource(this.getClass().getResource(resourcePath)));
        }
        Results results = kieHelper.verify();
        Assert.assertTrue((String)results.toString(), (boolean)results.getMessages().isEmpty());
        KieContainer kieContainer = kieHelper.getKieContainer();
        DMNRuntime runtime = (DMNRuntime)kieContainer.newKieSession().getKieRuntime(DMNRuntime.class);
        return runtime;
    }

    private void assertContainsPackage(KieBase kieBase, String packageName) {
        if (kieBase.getKiePackage(packageName) == null) {
            Assert.fail((String)("KieBase with packages [" + kieBase.getKiePackages() + "] does not contain expected package [" + packageName + "]!"));
        }
    }
}

