/*
 * Decompiled with CFR 0.152.
 */
package org.kie.karaf.itest.camel.kiecamel;

import javax.inject.Inject;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.component.bean.PojoProxyHelper;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.karaf.itest.AbstractKarafIntegrationTest;
import org.kie.karaf.itest.camel.kiecamel.model.Cheese;
import org.kie.karaf.itest.camel.kiecamel.proxy.CheeseAssessmentService;
import org.kie.karaf.itest.camel.kiecamel.tools.CheeseFactory;
import org.ops4j.pax.exam.Configuration;
import org.ops4j.pax.exam.CoreOptions;
import org.ops4j.pax.exam.Option;
import org.ops4j.pax.exam.junit.PaxExam;
import org.ops4j.pax.exam.karaf.options.KarafDistributionOption;
import org.ops4j.pax.exam.karaf.options.LogLevelOption;
import org.ops4j.pax.exam.options.UrlReference;
import org.ops4j.pax.exam.spi.reactors.ExamReactorStrategy;
import org.ops4j.pax.exam.spi.reactors.PerClass;

@RunWith(value=PaxExam.class)
@ExamReactorStrategy(value={PerClass.class})
public class KieCamelBlueprintDTIntegrationTest
extends AbstractKarafIntegrationTest {
    @Inject
    private CamelContext camelContext;

    @Configuration
    public static Option[] configure() {
        return new Option[]{KieCamelBlueprintDTIntegrationTest.getKarafDistributionOption(), KarafDistributionOption.configureConsole().ignoreLocalConsole(), KarafDistributionOption.logLevel((LogLevelOption.LogLevel)LogLevelOption.LogLevel.WARN), KieCamelBlueprintDTIntegrationTest.loadKieFeatures("drools-module", "drools-decisiontable", "kie-ci", "kie-aries-blueprint", "kie-camel"), CoreOptions.wrappedBundle((UrlReference)CoreOptions.mavenBundle().groupId("junit").artifactId("junit").versionAsInProject())};
    }

    @BeforeClass
    public static void generalSetup() {
        System.setProperty("org.kie.server.mode", "production");
    }

    @AfterClass
    public static void generalCleanup() {
        System.clearProperty("org.kie.server.mode");
    }

    @Test(timeout=60000L)
    public void testNonFavouriteCheese() throws Exception {
        CheeseAssessmentService service = this.getCheeseAssessmentProxy();
        Cheese assessedCheese = service.assessCheese(CheeseFactory.createStilton());
        Assert.assertFalse((boolean)assessedCheese.isFavourite());
    }

    @Test(timeout=60000L)
    public void testFavouriteCheese() throws Exception {
        CheeseAssessmentService service = this.getCheeseAssessmentProxy();
        Cheese assessedCheese = service.assessCheese(CheeseFactory.createCheddar());
        Assert.assertTrue((boolean)assessedCheese.isFavourite());
    }

    private CheeseAssessmentService getCheeseAssessmentProxy() throws Exception {
        return (CheeseAssessmentService)PojoProxyHelper.createProxy((Endpoint)this.camelContext.getEndpoint("direct://startCheeseAssessment"), (Class[])new Class[]{CheeseAssessmentService.class});
    }
}

