/*
 * Decompiled with CFR 0.152.
 */
package org.kie.karaf.itest;

import javax.inject.Inject;
import org.apache.karaf.features.FeaturesService;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.api.runtime.manager.RuntimeManagerFactory;
import org.kie.karaf.itest.AbstractKarafIntegrationTest;
import org.ops4j.pax.exam.Configuration;
import org.ops4j.pax.exam.Option;
import org.ops4j.pax.exam.junit.PaxExam;
import org.ops4j.pax.exam.karaf.options.KarafDistributionOption;
import org.ops4j.pax.exam.karaf.options.LogLevelOption;
import org.ops4j.pax.exam.spi.reactors.ExamReactorStrategy;
import org.ops4j.pax.exam.spi.reactors.PerMethod;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.wiring.BundleWiring;

@RunWith(value=PaxExam.class)
@ExamReactorStrategy(value={PerMethod.class})
public class RuntimeManagerFeatureKarafIntegrationTest
extends AbstractKarafIntegrationTest {
    @Inject
    protected FeaturesService featuresService;

    @Test
    public void testJbpmRuntimeManager() throws Exception {
        FrameworkUtil.getBundle(this.getClass()).adapt(BundleWiring.class);
        ClassLoader classLoader = this.getClass().getClassLoader();
        RuntimeManagerFactory runtimeManagerFactory = RuntimeManagerFactory.Factory.get((ClassLoader)classLoader);
        Assert.assertNull((String)"KIE-API created non-null RuntimeManagerFactory when jBPM was not installed.", (Object)runtimeManagerFactory);
        this.featuresService.installFeature("jbpm");
        RuntimeManagerFactory.Factory.reset();
        classLoader = ((BundleWiring)FrameworkUtil.getBundle(this.getClass()).adapt(BundleWiring.class)).getClassLoader();
        String className = System.getProperty("org.jbpm.runtime.manager.class", "org.jbpm.runtime.manager.impl.RuntimeManagerFactoryImpl");
        Class<?> clazz = classLoader.loadClass(className);
        Assert.assertNotNull((String)"KIE-API created null RuntimeManagerFactory after jBPM was installed.", clazz.newInstance());
    }

    @Configuration
    public static Option[] configure() {
        return new Option[]{RuntimeManagerFeatureKarafIntegrationTest.getKarafDistributionOption(), KarafDistributionOption.configureConsole().ignoreLocalConsole(), KarafDistributionOption.logLevel((LogLevelOption.LogLevel)LogLevelOption.LogLevel.WARN), RuntimeManagerFeatureKarafIntegrationTest.loadKieFeatures("drools-module")};
    }
}

