/*
 * Decompiled with CFR 0.152.
 */
package org.kie.karaf.itest.planner;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.karaf.itest.AbstractKarafIntegrationTest;
import org.kie.karaf.itest.planner.domain.CloudBalance;
import org.kie.karaf.itest.planner.domain.CloudComputer;
import org.kie.karaf.itest.planner.domain.CloudProcess;
import org.kie.karaf.itest.planner.domain.score.CloudBalancingIncrementalScoreCalculator;
import org.ops4j.pax.exam.Configuration;
import org.ops4j.pax.exam.Option;
import org.ops4j.pax.exam.junit.PaxExam;
import org.ops4j.pax.exam.karaf.options.KarafDistributionOption;
import org.ops4j.pax.exam.karaf.options.LogLevelOption;
import org.ops4j.pax.exam.spi.reactors.ExamReactorStrategy;
import org.ops4j.pax.exam.spi.reactors.PerClass;
import org.optaplanner.core.api.score.buildin.hardsoft.HardSoftScore;
import org.optaplanner.core.api.solver.Solver;
import org.optaplanner.core.api.solver.SolverFactory;
import org.optaplanner.core.config.constructionheuristic.ConstructionHeuristicPhaseConfig;
import org.optaplanner.core.config.constructionheuristic.ConstructionHeuristicType;
import org.optaplanner.core.config.localsearch.LocalSearchPhaseConfig;
import org.optaplanner.core.config.phase.PhaseConfig;
import org.optaplanner.core.config.score.director.ScoreDirectorFactoryConfig;
import org.optaplanner.core.config.solver.SolverConfig;
import org.optaplanner.core.config.solver.termination.TerminationConfig;

@RunWith(value=PaxExam.class)
@ExamReactorStrategy(value={PerClass.class})
public class PlannerCloudBalanceIntegrationTest
extends AbstractKarafIntegrationTest {
    private static final String CLOUD_BALANCE_INCREMENTAL_CONFIG_FILE = "cloudBalanceIncrementalConfig.xml";
    private static final String CLOUD_BALANCE_DROOLS_CONFIG_FILE = "cloudBalanceDroolsConfig.xml";

    @Test
    public void plannerCloudBalanceTest() {
        this.solveSolution(this.cloudBalanceGeneratorForFuse(5, 10, 0));
    }

    @Test
    @Ignore(value="RHPAM-1554")
    public void plannerSolverFactoryTest() {
        this.solveUsingSolverFactory(CLOUD_BALANCE_INCREMENTAL_CONFIG_FILE);
    }

    @Test
    @Ignore(value="RHPAM-1554")
    public void plannerSolverFactoryDroolsTest() {
        this.solveUsingSolverFactory(CLOUD_BALANCE_DROOLS_CONFIG_FILE);
    }

    private CloudBalance cloudBalanceGeneratorForFuse(int computerNum, int processNum, int seed) {
        Random random = new Random(seed);
        int costRange = 10000;
        int costBaseline = 1000;
        int cpuPowerRange = 100;
        int cpuPowerBaseLine = 10;
        int memoryRange = 100;
        int memoryBaseLine = 10;
        int networkRange = 100;
        int networkBaseLine = 10;
        CloudBalance cloudBalance = new CloudBalance();
        String string = "-2147483648hard";
        string = string + "/";
        string = string + "-2147483648soft";
        cloudBalance.setScore(HardSoftScore.parseScore((String)string));
        ArrayList<CloudComputer> computerList = new ArrayList<CloudComputer>();
        for (int i = 0; i < computerNum; ++i) {
            CloudComputer computer = new CloudComputer();
            computer.setCost(random.nextInt(costRange) + costBaseline);
            computer.setCpuPower(random.nextInt(cpuPowerRange) + cpuPowerBaseLine);
            computer.setMemory(random.nextInt(memoryRange) + memoryBaseLine);
            computer.setNetworkBandwidth(random.nextInt(networkRange) + networkBaseLine);
            computerList.add(computer);
        }
        int processCpuPowerRange = 50;
        int processCpuPowerBaseLine = 1;
        int processMemoryRange = 50;
        int processMemoryBaseLine = 1;
        int processNetworkRange = 50;
        int processNetworkBaseLine = 1;
        ArrayList<CloudProcess> processList = new ArrayList<CloudProcess>();
        for (int i = 0; i < processNum; ++i) {
            CloudProcess process = new CloudProcess();
            process.setRequiredCpuPower(random.nextInt(processCpuPowerRange) + processCpuPowerBaseLine);
            process.setRequiredMemory(random.nextInt(processMemoryRange) + processMemoryBaseLine);
            process.setRequiredNetworkBandwidth(random.nextInt(processNetworkRange) + processNetworkBaseLine);
            processList.add(process);
        }
        cloudBalance.setComputerList(computerList);
        cloudBalance.setProcessList(processList);
        return cloudBalance;
    }

    private void solveSolution(CloudBalance cloudBalance) {
        LocalSearchPhaseConfig localSearchPhaseConfig = new LocalSearchPhaseConfig();
        localSearchPhaseConfig.setTerminationConfig(new TerminationConfig().withStepCountLimit(Integer.valueOf(20)));
        SolverConfig config = new SolverConfig().withEntityClassList(Arrays.asList(CloudProcess.class)).withSolutionClass(CloudBalance.class).withScoreDirectorFactory(new ScoreDirectorFactoryConfig().withIncrementalScoreCalculatorClass(CloudBalancingIncrementalScoreCalculator.class)).withPhases(new PhaseConfig[]{new ConstructionHeuristicPhaseConfig().withConstructionHeuristicType(ConstructionHeuristicType.FIRST_FIT_DECREASING), localSearchPhaseConfig});
        Assert.assertEquals((long)cloudBalance.getScore().getHardScore(), (long)Integer.MIN_VALUE);
        Assert.assertEquals((long)cloudBalance.getScore().getSoftScore(), (long)Integer.MIN_VALUE);
        SolverFactory solverFactory = SolverFactory.create((SolverConfig)config);
        Solver solver = solverFactory.buildSolver();
        solver.solve((Object)cloudBalance);
        CloudBalance solution = (CloudBalance)solver.getBestSolution();
        Assert.assertNotEquals((long)solution.getScore().getHardScore(), (long)Integer.MIN_VALUE);
        Assert.assertNotEquals((long)solution.getScore().getSoftScore(), (long)Integer.MIN_VALUE);
    }

    private void solveUsingSolverFactory(String configFile) {
        SolverFactory solverFactory = SolverFactory.createFromXmlResource((String)configFile, (ClassLoader)PlannerCloudBalanceIntegrationTest.class.getClassLoader());
        CloudBalance cloudBalance = this.cloudBalanceGeneratorForFuse(10, 20, 0);
        Assert.assertEquals((long)cloudBalance.getScore().getHardScore(), (long)Integer.MIN_VALUE);
        Assert.assertEquals((long)cloudBalance.getScore().getSoftScore(), (long)Integer.MIN_VALUE);
        Solver solver = solverFactory.buildSolver();
        solver.solve((Object)cloudBalance);
        CloudBalance solution = (CloudBalance)solver.getBestSolution();
        Assert.assertNotEquals((long)solution.getScore().getHardScore(), (long)Integer.MIN_VALUE);
        Assert.assertNotEquals((long)solution.getScore().getSoftScore(), (long)Integer.MIN_VALUE);
    }

    @Configuration
    public static Option[] configure() {
        return new Option[]{PlannerCloudBalanceIntegrationTest.getKarafDistributionOption(), KarafDistributionOption.configureConsole().ignoreLocalConsole(), KarafDistributionOption.logLevel((LogLevelOption.LogLevel)LogLevelOption.LogLevel.WARN), PlannerCloudBalanceIntegrationTest.loadKieFeatures("optaplanner-engine")};
    }
}

