/*
 * Decompiled with CFR 0.152.
 */
package org.kie.karaf.itest.util;

import com.github.tomakehurst.wiremock.WireMockServer;
import com.github.tomakehurst.wiremock.client.MappingBuilder;
import com.github.tomakehurst.wiremock.client.UrlMatchingStrategy;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.core.WireMockConfiguration;
import java.lang.reflect.Field;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.model.InitializationError;
import org.ops4j.pax.exam.junit.PaxExam;

public class PaxExamWithWireRestClientMock
extends PaxExam {
    private WireMockServer wireMockServer;
    private Class<?> clazz;
    private Integer port;
    private String host;

    public PaxExamWithWireRestClientMock(Class<?> klass) throws InitializationError {
        super(klass);
        this.clazz = klass;
        this.port = (Integer)this.getFieldValue("PORT");
        this.host = (String)this.getFieldValue("HOST");
    }

    public void run(RunNotifier notifier) {
        this.wireMockServer = new WireMockServer((Options)WireMockConfiguration.wireMockConfig().bindAddress(this.host).port(this.port.intValue()));
        this.wireMockServer.start();
        this.setupMockServer();
        System.out.println("WireMock server started and bound to localhost:" + this.port);
        super.run(notifier);
        this.wireMockServer.stop();
    }

    protected Object getFieldValue(String name) {
        try {
            Field f = this.clazz.getField(name);
            f.setAccessible(true);
            return f.get(null);
        }
        catch (Exception e) {
            return null;
        }
    }

    public void setupMockServer() {
        WireMock.configureFor((String)"localhost", (int)this.port);
        WireMock.stubFor((MappingBuilder)WireMock.post((UrlMatchingStrategy)WireMock.urlEqualTo((String)"/jbpm-console/rest/execute")).withHeader("Accept", WireMock.equalTo((String)"application/xml")).willReturn(WireMock.aResponse().withStatus(200).withHeader("Content-Type", "application/xml").withBody("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n<command-response>\n  <deployment-id>org.jbpm:Evaluation:1.0</deployment-id>\n  <ver>6.3.0.1</ver>\n  <process-instance index=\"0\">\n    <process-id>evaluation</process-id>\n    <id>40</id>\n    <state>1</state>\n    <parentProcessInstanceId>0</parentProcessInstanceId>\n    <command-name>StartProcessCommand</command-name>\n  </process-instance>\n</command-response>")));
    }
}

