/*
 * Decompiled with CFR 0.152.
 */
package org.kie.karaf.itest;

import java.io.InputStream;
import javax.inject.Inject;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.api.KieBase;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.StatelessKieSession;
import org.kie.karaf.itest.AbstractKieSpringKarafIntegrationTest;
import org.ops4j.pax.exam.Configuration;
import org.ops4j.pax.exam.CoreOptions;
import org.ops4j.pax.exam.Option;
import org.ops4j.pax.exam.junit.PaxExam;
import org.ops4j.pax.exam.karaf.options.KarafDistributionOption;
import org.ops4j.pax.exam.karaf.options.LogLevelOption;
import org.ops4j.pax.exam.options.UrlReference;
import org.ops4j.pax.exam.spi.reactors.ExamReactorStrategy;
import org.ops4j.pax.exam.spi.reactors.PerClass;
import org.ops4j.pax.exam.util.Filter;
import org.ops4j.pax.tinybundles.core.TinyBundles;
import org.osgi.service.blueprint.container.BlueprintContainer;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;

@Ignore
@RunWith(value=PaxExam.class)
@ExamReactorStrategy(value={PerClass.class})
public class SimpleKieSpringKarafIntegrationTest
extends AbstractKieSpringKarafIntegrationTest {
    private static final String SPRING_XML_LOCATION = "/org/kie/karaf/itest/kie-beans.xml";
    private static final String SPRING_APPLICATION_CONTEXT_ID = "." + ApplicationContext.class.getName();
    @Inject
    @Filter(value="(osgi.blueprint.container.symbolicname=Test-Kie-Spring-Bundle)")
    private BlueprintContainer container;

    @Before
    public void init() {
        this.applicationContext = (ConfigurableApplicationContext)this.container.getComponentInstance(SPRING_APPLICATION_CONTEXT_ID);
        Assert.assertNotNull((String)"Should have created a valid spring context", (Object)this.applicationContext);
    }

    @Test
    public void testKieBase() throws Exception {
        this.refresh();
        KieBase kbase = (KieBase)this.applicationContext.getBean("drl_kiesample");
        Assert.assertNotNull((Object)kbase);
    }

    @Test
    public void testKieSession() throws Exception {
        this.refresh();
        StatelessKieSession ksession = (StatelessKieSession)this.applicationContext.getBean("ksession9");
        Assert.assertNotNull((Object)ksession);
    }

    @Test
    public void testKieSessionDefaultType() throws Exception {
        this.refresh();
        Object obj = this.applicationContext.getBean("ksession99");
        Assert.assertNotNull((Object)obj);
        Assert.assertTrue((boolean)(obj instanceof KieSession));
    }

    @Configuration
    public static Option[] configure() {
        return new Option[]{SimpleKieSpringKarafIntegrationTest.getKarafDistributionOption(), KarafDistributionOption.configureConsole().ignoreLocalConsole(), KarafDistributionOption.logLevel((LogLevelOption.LogLevel)LogLevelOption.LogLevel.WARN), SimpleKieSpringKarafIntegrationTest.loadKieFeatures("kie-spring"), KarafDistributionOption.features((UrlReference)SimpleKieSpringKarafIntegrationTest.getFeaturesUrl("org.apache.karaf.features", "spring", SimpleKieSpringKarafIntegrationTest.getKarafVersion()), (String[])new String[]{"aries-blueprint-spring"}), (Option)CoreOptions.streamBundle((InputStream)TinyBundles.bundle().set("Bundle-ManifestVersion", "2").add("META-INF/spring/kie-beans.xml", SimpleKieSpringKarafIntegrationTest.class.getResource(SPRING_XML_LOCATION)).set("Import-Package", "org.kie.osgi.spring,org.kie.api,org.kie.api.runtime,*").set("Bundle-SymbolicName", "Test-Kie-Spring-Bundle").build()).start()};
    }
}

