/*
 * Decompiled with CFR 0.152.
 */
package org.kie.karaf.itest;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.api.KieBase;
import org.kie.api.KieServices;
import org.kie.api.builder.Results;
import org.kie.api.conf.KieBaseOption;
import org.kie.api.io.KieResources;
import org.kie.internal.utils.KieHelper;
import org.kie.karaf.itest.AbstractKarafIntegrationTest;
import org.ops4j.pax.exam.Configuration;
import org.ops4j.pax.exam.Option;
import org.ops4j.pax.exam.junit.PaxExam;
import org.ops4j.pax.exam.karaf.options.KarafDistributionOption;
import org.ops4j.pax.exam.karaf.options.LogLevelOption;
import org.ops4j.pax.exam.spi.reactors.ExamReactorStrategy;
import org.ops4j.pax.exam.spi.reactors.PerClass;

@Ignore
@RunWith(value=PaxExam.class)
@ExamReactorStrategy(value={PerClass.class})
public class WorkbenchModelsKarafIntegrationTest
extends AbstractKarafIntegrationTest {
    private static final String SIMPLE_GDST_LOCATION = "/wb-models/simple-guided-dtable.gdst";
    private static final String ADVANCED_GDST_LOCATION = "/wb-models/bz-1312164-guided-dtable-with-fqcn.gdst";
    private final KieServices ks = KieServices.Factory.get();
    private final KieResources kieResources = this.ks.getResources();
    private ClassLoader origTCCL;

    @Before
    public void setTCCL() {
        this.origTCCL = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(Object.class.getClassLoader());
    }

    @After
    public void restoreTCCL() {
        Thread.currentThread().setContextClassLoader(this.origTCCL);
    }

    @Test
    public void buildKieBaseFromSimpleGuidedDTable() throws Exception {
        KieBase kieBase = this.createKieBase(SIMPLE_GDST_LOCATION);
        this.assertContainsPackage(kieBase, "guided_dtable");
    }

    @Test
    public void buildKieBaseFromAdvancedDTableUsingFQCN() {
        KieBase kieBase = this.createKieBase(ADVANCED_GDST_LOCATION);
        this.assertContainsPackage(kieBase, "guided_dtable_fqcn");
    }

    @Configuration
    public static Option[] configure() {
        return new Option[]{WorkbenchModelsKarafIntegrationTest.getKarafDistributionOption(), KarafDistributionOption.configureConsole().ignoreLocalConsole(), KarafDistributionOption.logLevel((LogLevelOption.LogLevel)LogLevelOption.LogLevel.WARN), WorkbenchModelsKarafIntegrationTest.loadKieFeatures("drools-wb-guided-decisiontables")};
    }

    private KieBase createKieBase(String ... resourcePaths) {
        KieHelper kieHelper = new KieHelper();
        ClassLoader bundleClassloader = this.getClass().getClassLoader();
        kieHelper.setClassLoader(bundleClassloader);
        for (String resourcePath : resourcePaths) {
            kieHelper.addResource(this.kieResources.newUrlResource(this.getClass().getResource(resourcePath)));
        }
        Results results = kieHelper.verify();
        Assert.assertTrue((String)results.toString(), (boolean)results.getMessages().isEmpty());
        return kieHelper.build(new KieBaseOption[0]);
    }

    private void assertContainsPackage(KieBase kieBase, String packageName) {
        if (kieBase.getKiePackage(packageName) == null) {
            Assert.fail((String)("KieBase with packages [" + kieBase.getKiePackages() + "] does not contain expected package [" + packageName + "]!"));
        }
    }
}

