/*
 * Decompiled with CFR 0.152.
 */
package org.kie.karaf.itest.camel.kiecamel;

import java.util.ArrayList;
import java.util.HashMap;
import javax.inject.Inject;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.component.bean.PojoProxyHelper;
import org.drools.core.command.runtime.BatchExecutionCommandImpl;
import org.drools.core.command.runtime.rule.FireAllRulesCommand;
import org.drools.core.command.runtime.rule.InsertObjectCommand;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.karaf.itest.AbstractKarafIntegrationTest;
import org.kie.karaf.itest.camel.kiecamel.proxy.RemoteExecutionService;
import org.kie.karaf.itest.camel.kiecamel.tools.ExecutionServerCommand;
import org.kie.karaf.itest.kieserver.KieServerConstants;
import org.kie.karaf.itest.util.PaxExamWithWireMock;
import org.kie.server.api.model.KieContainerResourceList;
import org.kie.server.api.model.definition.ProcessDefinition;
import org.ops4j.pax.exam.Configuration;
import org.ops4j.pax.exam.CoreOptions;
import org.ops4j.pax.exam.Option;
import org.ops4j.pax.exam.karaf.options.KarafDistributionOption;
import org.ops4j.pax.exam.karaf.options.LogLevelOption;
import org.ops4j.pax.exam.options.UrlReference;
import org.ops4j.pax.exam.spi.reactors.ExamReactorStrategy;
import org.ops4j.pax.exam.spi.reactors.PerClass;

@RunWith(value=PaxExamWithWireMock.class)
@ExamReactorStrategy(value={PerClass.class})
@Ignore
public class KieCamelRemoteIntegrationTest
extends AbstractKarafIntegrationTest {
    public static final String HOST = "localhost";
    public static final int PORT = 59400;
    public static final String TYPE = "jaxb";
    private RemoteExecutionService remoteExecutionService;
    @Inject
    private CamelContext camelContext;

    @Before
    public void init() throws Exception {
        this.remoteExecutionService = this.getRemoteExecutionService();
    }

    @Test
    public void testListContainers() {
        ExecutionServerCommand executionServerCommand = new ExecutionServerCommand();
        executionServerCommand.setClient("kieServices");
        executionServerCommand.setOperation("listContainers");
        Object response = this.remoteExecutionService.runOnExecServer(executionServerCommand);
        Assert.assertNotNull((Object)response);
        Assert.assertTrue((boolean)(response instanceof KieContainerResourceList));
        KieContainerResourceList kieContainerResourceList = (KieContainerResourceList)response;
        Assert.assertEquals((long)1L, (long)kieContainerResourceList.getContainers().size());
    }

    @Test
    public void testGetProcessDefinition() {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("containerId", KieServerConstants.containerId);
        parameters.put("processId", KieServerConstants.processId);
        ExecutionServerCommand executionServerCommand = new ExecutionServerCommand();
        executionServerCommand.setClient("process");
        executionServerCommand.setOperation("getProcessDefinition");
        executionServerCommand.setParameters(parameters);
        Object response = this.remoteExecutionService.runOnExecServer(executionServerCommand);
        Assert.assertNotNull((Object)response);
        Assert.assertTrue((boolean)(response instanceof ProcessDefinition));
        ProcessDefinition processDefinition = (ProcessDefinition)response;
        Assert.assertEquals((Object)"Evaluation", (Object)processDefinition.getName());
        Assert.assertEquals((Object)"1", (Object)processDefinition.getVersion());
    }

    @Test
    public void testStartProcess() {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("containerId", KieServerConstants.containerId);
        parameters.put("processId", KieServerConstants.processId);
        parameters.put("employee", KieServerConstants.user);
        ExecutionServerCommand executionServerCommand = new ExecutionServerCommand();
        executionServerCommand.setClient("process");
        executionServerCommand.setOperation("startProcess");
        executionServerCommand.setParameters(parameters);
        Object response = this.remoteExecutionService.runOnExecServer(executionServerCommand);
        Assert.assertNotNull((Object)response);
        Assert.assertTrue((boolean)(response instanceof Long));
        Long processInstanceId = (Long)response;
        Assert.assertEquals((Object)2L, (Object)processInstanceId);
    }

    @Test
    public void testExecuteCommand() {
        InsertObjectCommand insertObjectCommand = new InsertObjectCommand();
        insertObjectCommand.setOutIdentifier("person");
        insertObjectCommand.setObject((Object)"john");
        FireAllRulesCommand fireAllRulesCommand = new FireAllRulesCommand();
        ArrayList commands = new ArrayList();
        BatchExecutionCommandImpl executionCommand = new BatchExecutionCommandImpl(commands);
        executionCommand.setLookup("defaultKieSession");
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("id", KieServerConstants.containerId);
        ExecutionServerCommand executionServerCommand = new ExecutionServerCommand();
        executionServerCommand.setClient("rule");
        executionServerCommand.setOperation("executeCommands");
        executionServerCommand.setParameters(parameters);
        executionServerCommand.setBodyParam("cmd");
        executionServerCommand.setBody(executionCommand);
        Object response = this.remoteExecutionService.runOnExecServer(executionServerCommand);
        Assert.assertNotNull((Object)response);
        Assert.assertTrue((boolean)(response instanceof String));
        String responseString = (String)response;
        Assert.assertTrue((boolean)responseString.contains("execution-results"));
    }

    private RemoteExecutionService getRemoteExecutionService() throws Exception {
        return (RemoteExecutionService)PojoProxyHelper.createProxy((Endpoint)this.camelContext.getEndpoint("direct:remote"), (Class[])new Class[]{RemoteExecutionService.class});
    }

    @Configuration
    public static Option[] configure() {
        return new Option[]{AbstractKarafIntegrationTest.getKarafDistributionOption(), KarafDistributionOption.configureConsole().ignoreLocalConsole(), KarafDistributionOption.logLevel((LogLevelOption.LogLevel)LogLevelOption.LogLevel.WARN), AbstractKarafIntegrationTest.loadKieFeatures("drools-module", "drools-decisiontable", "kie-ci", "kie-aries-blueprint", "kie-camel"), CoreOptions.wrappedBundle((UrlReference)CoreOptions.mavenBundle().groupId("junit").artifactId("junit").versionAsInProject())};
    }
}

