/*
 * Decompiled with CFR 0.152.
 */
package org.kie.karaf.itest;

import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import org.apache.karaf.features.FeaturesService;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.karaf.itest.AbstractKarafIntegrationTest;
import org.ops4j.pax.exam.Configuration;
import org.ops4j.pax.exam.Option;
import org.ops4j.pax.exam.junit.PaxExamParameterized;
import org.ops4j.pax.exam.karaf.options.KarafDistributionOption;
import org.ops4j.pax.exam.karaf.options.LogLevelOption;
import org.ops4j.pax.exam.spi.reactors.ExamReactorStrategy;
import org.ops4j.pax.exam.spi.reactors.PerClass;

@RunWith(value=PaxExamParameterized.class)
@ExamReactorStrategy(value={PerClass.class})
public class InstallFeaturesKarafIntegrationTest
extends AbstractKarafIntegrationTest {
    private String featureName;
    @Inject
    protected FeaturesService featuresService;

    public InstallFeaturesKarafIntegrationTest(String featureName) {
        this.featureName = featureName;
    }

    @Parameterized.Parameters(name="{index}: {0}")
    public static List<Object[]> getParameters() {
        return Arrays.asList({"drools-common"}, {"drools-module"}, {"kie-pmml"}, {"drools-templates"}, {"drools-decisiontable"}, {"drools-wb-guided-decisiontables"}, {"drools-jpa"}, {"kie"}, {"kie-ci"}, {"kie-pmml"}, {"kie-spring"}, {"kie-aries-blueprint"}, {"jbpm-commons"}, {"jbpm-human-task"}, {"jbpm"}, {"jbpm-spring-persistent"}, {"droolsjbpm-hibernate"}, {"h2"});
    }

    @Configuration
    public static Option[] configure() {
        return new Option[]{InstallFeaturesKarafIntegrationTest.getKarafDistributionOption(), KarafDistributionOption.configureConsole().ignoreLocalConsole(), KarafDistributionOption.logLevel((LogLevelOption.LogLevel)LogLevelOption.LogLevel.WARN), InstallFeaturesKarafIntegrationTest.loadKieFeaturesRepo()};
    }

    @Test
    public void testInstallFeature() throws Exception {
        this.featuresService.installFeature(this.featureName);
        Assert.assertTrue((String)("Feature " + this.featureName + " not installed!"), (boolean)this.featuresService.isInstalled(this.featuresService.getFeature(this.featureName)));
    }

    @After
    public void removeInstalledFeature() throws Exception {
        this.featuresService.uninstallFeature(this.featureName);
        Assert.assertFalse((String)("Feature " + this.featureName + " is still installed, even after explicit call to uninstallFeature()!"), (boolean)this.featuresService.isInstalled(this.featuresService.getFeature(this.featureName)));
    }
}

