/*
 * Decompiled with CFR 0.152.
 */
package org.kie.maven.plugin;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashSet;
import java.util.List;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.drools.compiler.kie.builder.impl.KieContainerImpl;
import org.drools.compiler.kie.builder.impl.KieProject;
import org.drools.compiler.kie.builder.impl.ResultsImpl;
import org.kie.api.KieServices;
import org.kie.api.builder.KieModule;
import org.kie.api.builder.KieRepository;
import org.kie.api.builder.Message;
import org.kie.api.io.Resource;

public class BuildMojo
extends AbstractMojo {
    private File outputDirectory;
    private File sourceFolder;
    private MavenProject project;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            HashSet<URL> urls = new HashSet<URL>();
            List elements = this.project.getCompileClasspathElements();
            for (String element : elements) {
                urls.add(new File(element).toURI().toURL());
            }
            urls.add(this.outputDirectory.toURI().toURL());
            URLClassLoader projectClassLoader = URLClassLoader.newInstance(urls.toArray(new URL[0]), Thread.currentThread().getContextClassLoader());
            Thread.currentThread().setContextClassLoader(projectClassLoader);
        }
        catch (DependencyResolutionRequiredException e) {
            throw new RuntimeException(e);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        KieServices ks = KieServices.Factory.get();
        try {
            KieRepository kr = ks.getRepository();
            KieModule kModule = kr.addKieModule(ks.getResources().newFileSystemResource(this.sourceFolder), new Resource[0]);
            KieContainerImpl kContainer = (KieContainerImpl)ks.newKieContainer(kModule.getReleaseId());
            KieProject kieProject = kContainer.getKieProject();
            ResultsImpl messages = kieProject.verify();
            List errors = messages.filterMessages(new Message.Level[]{Message.Level.ERROR});
            if (!errors.isEmpty()) {
                for (Message error : errors) {
                    this.getLog().error((CharSequence)error.toString());
                }
                throw new MojoFailureException("Build failed!");
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextClassLoader);
        }
        this.getLog().info((CharSequence)"KieModule successfully built!");
    }
}

