/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.xpath.tobeinstrumented;

import java.util.Arrays;
import java.util.List;
import org.drools.core.phreak.ReactiveObject;
import org.junit.Assert;
import org.junit.Test;
import org.kie.maven.plugin.InjectReactiveMojo;

public class InjectReactiveMojoConfigTest {
    @Test
    public void testRegexpForPackagesDefault() {
        String[] inputConfig = new String[]{"*"};
        List config = InjectReactiveMojo.convertAllToPkgRegExps((String[])inputConfig);
        System.out.println(Arrays.asList(config));
        Assert.assertTrue((boolean)InjectReactiveMojo.isPackageNameIncluded((String)Object.class.getPackage().getName(), (List)config));
        Assert.assertTrue((boolean)InjectReactiveMojo.isPackageNameIncluded((String)ReactiveObject.class.getPackage().getName(), (List)config));
        Assert.assertTrue((boolean)InjectReactiveMojo.isPackageNameIncluded((String)"xyz.my", (List)config));
    }

    @Test
    public void testRegexpForPackagesSingleNoStars() {
        String[] inputConfig = new String[]{"org.drools"};
        List config = InjectReactiveMojo.convertAllToPkgRegExps((String[])inputConfig);
        System.out.println(Arrays.asList(config));
        Assert.assertFalse((boolean)InjectReactiveMojo.isPackageNameIncluded((String)Object.class.getPackage().getName(), (List)config));
        Assert.assertFalse((boolean)InjectReactiveMojo.isPackageNameIncluded((String)ReactiveObject.class.getPackage().getName(), (List)config));
        Assert.assertFalse((boolean)InjectReactiveMojo.isPackageNameIncluded((String)"xyz.my", (List)config));
    }

    @Test
    public void testRegexpForPackagesMultipleNoStars() {
        String[] inputConfig = new String[]{"org.drools", "xyz.my"};
        List config = InjectReactiveMojo.convertAllToPkgRegExps((String[])inputConfig);
        System.out.println(Arrays.asList(config));
        Assert.assertFalse((boolean)InjectReactiveMojo.isPackageNameIncluded((String)Object.class.getPackage().getName(), (List)config));
        Assert.assertFalse((boolean)InjectReactiveMojo.isPackageNameIncluded((String)ReactiveObject.class.getPackage().getName(), (List)config));
        Assert.assertTrue((boolean)InjectReactiveMojo.isPackageNameIncluded((String)"xyz.my", (List)config));
    }

    @Test
    public void testRegexpForPackagesSingleStars() {
        String[] inputConfig = new String[]{"org.drools.*"};
        List config = InjectReactiveMojo.convertAllToPkgRegExps((String[])inputConfig);
        System.out.println(Arrays.asList(config));
        Assert.assertFalse((boolean)InjectReactiveMojo.isPackageNameIncluded((String)Object.class.getPackage().getName(), (List)config));
        Assert.assertTrue((boolean)InjectReactiveMojo.isPackageNameIncluded((String)ReactiveObject.class.getPackage().getName(), (List)config));
        Assert.assertFalse((boolean)InjectReactiveMojo.isPackageNameIncluded((String)"xyz.my", (List)config));
    }

    @Test
    public void testRegexpForPackagesMultipleStars() {
        String[] inputConfig = new String[]{"org.drools.*", "xyz.my.*"};
        List config = InjectReactiveMojo.convertAllToPkgRegExps((String[])inputConfig);
        System.out.println(Arrays.asList(config));
        Assert.assertFalse((boolean)InjectReactiveMojo.isPackageNameIncluded((String)Object.class.getPackage().getName(), (List)config));
        Assert.assertTrue((boolean)InjectReactiveMojo.isPackageNameIncluded((String)ReactiveObject.class.getPackage().getName(), (List)config));
        Assert.assertTrue((boolean)InjectReactiveMojo.isPackageNameIncluded((String)"xyz.my", (List)config));
    }

    @Test
    public void testRegexpForPackagesCheckPart() {
        String[] inputConfig = new String[]{"my"};
        List config = InjectReactiveMojo.convertAllToPkgRegExps((String[])inputConfig);
        System.out.println(Arrays.asList(config));
        Assert.assertFalse((boolean)InjectReactiveMojo.isPackageNameIncluded((String)Object.class.getPackage().getName(), (List)config));
        Assert.assertFalse((boolean)InjectReactiveMojo.isPackageNameIncluded((String)ReactiveObject.class.getPackage().getName(), (List)config));
        Assert.assertFalse((boolean)InjectReactiveMojo.isPackageNameIncluded((String)"xyz.my", (List)config));
    }

    @Test
    public void testRegexpForPackagesCheckNaming() {
        String[] inputConfig = new String[]{"org.drools", "to.instrument.*"};
        List config = InjectReactiveMojo.convertAllToPkgRegExps((String[])inputConfig);
        System.out.println(Arrays.asList(config));
        Assert.assertFalse((boolean)InjectReactiveMojo.isPackageNameIncluded((String)Object.class.getPackage().getName(), (List)config));
        Assert.assertFalse((boolean)InjectReactiveMojo.isPackageNameIncluded((String)ReactiveObject.class.getPackage().getName(), (List)config));
        Assert.assertFalse((boolean)InjectReactiveMojo.isPackageNameIncluded((String)"xyz.my", (List)config));
        Assert.assertTrue((boolean)InjectReactiveMojo.isPackageNameIncluded((String)"to.instrument", (List)config));
        Assert.assertFalse((boolean)InjectReactiveMojo.isPackageNameIncluded((String)"to.not.instrument", (List)config));
    }
}

