/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.xpath.tobeinstrumented;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import javassist.ClassPool;
import javassist.CtClass;
import org.drools.compiler.xpath.tobeinstrumented.model.Child;
import org.drools.compiler.xpath.tobeinstrumented.model.Man;
import org.drools.compiler.xpath.tobeinstrumented.model.School;
import org.drools.compiler.xpath.tobeinstrumented.model.Toy;
import org.drools.compiler.xpath.tobeinstrumented.model.Woman;
import org.drools.core.base.ClassObjectType;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.MemoryFactory;
import org.drools.core.impl.InternalKnowledgeBase;
import org.drools.core.phreak.ReactiveObject;
import org.drools.core.reteoo.BetaMemory;
import org.drools.core.reteoo.EntryPointNode;
import org.drools.core.reteoo.LeftInputAdapterNode;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.core.reteoo.ReactiveFromNode;
import org.drools.core.reteoo.TupleMemory;
import org.drools.core.util.Iterator;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.kie.api.KieBase;
import org.kie.api.conf.KieBaseOption;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.KieSession;
import org.kie.internal.utils.KieHelper;
import org.kie.maven.plugin.BytecodeInjectReactive;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XPathTest {
    private static final Logger LOG = LoggerFactory.getLogger(XPathTest.class);

    @BeforeClass
    public static void init() throws Exception {
        ClassPool cp = new ClassPool(null);
        cp.appendSystemPath();
        cp.appendClassPath(BytecodeInjectReactive.classpathFromClass(ReactiveObject.class));
        BytecodeInjectReactive enhancer = BytecodeInjectReactive.newInstance((ClassPool)cp);
        byte[] personBytecode = enhancer.injectReactive("org.drools.compiler.xpath.tobeinstrumented.model.Person");
        byte[] schoolBytecode = enhancer.injectReactive("org.drools.compiler.xpath.tobeinstrumented.model.School");
        byte[] childBytecode = enhancer.injectReactive("org.drools.compiler.xpath.tobeinstrumented.model.Child");
        ClassPool cp2 = new ClassPool(null);
        cp2.appendSystemPath();
        cp2.appendClassPath(BytecodeInjectReactive.classpathFromClass(ReactiveObject.class));
        XPathTest.loadClassAndUtils(cp2, personBytecode);
        XPathTest.loadClassAndUtils(cp2, childBytecode);
        XPathTest.loadClassAndUtils(cp2, schoolBytecode);
    }

    private static void loadClassAndUtils(ClassPool cp, byte[] bytecode) throws Exception {
        CtClass theCtClass = cp.makeClass((InputStream)new ByteArrayInputStream(bytecode));
        Class class1 = theCtClass.toClass();
        LOG.info("Bytecode-injected class for {} now having the following methods:", (Object)theCtClass.getName());
        for (Method m : class1.getMethods()) {
            LOG.info(" {}", (Object)m);
        }
        File dir = new File("./target/JAVASSIST/");
        dir.mkdirs();
        File bytecodeFile = new File(dir, theCtClass.getPackageName() + theCtClass.getName() + ".class");
        bytecodeFile.createNewFile();
        FileOutputStream fos = new FileOutputStream(bytecodeFile);
        fos.write(bytecode);
        fos.close();
        LOG.info("Written bytecode for {} in file: {}.", (Object)theCtClass.getName(), (Object)bytecodeFile);
    }

    @Test
    public void testReactiveOnLia() {
        String drl = "import org.drools.compiler.xpath.tobeinstrumented.model.*;\nglobal java.util.List list\n\nrule R when\n  Man( $toy: /wife/children{age > 10}/toys )\nthen\n  list.add( $toy.getName() );\nend\n";
        KieSession ksession = new KieHelper().addContent(drl, ResourceType.DRL).build(new KieBaseOption[0]).newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        Woman alice = new Woman("Alice", 38);
        Man bob = new Man("Bob", 40);
        bob.setWife(alice);
        Child charlie = new Child("Charles", 12);
        Child debbie = new Child("Debbie", 10);
        alice.addChild(charlie);
        alice.addChild(debbie);
        charlie.addToy(new Toy("car"));
        charlie.addToy(new Toy("ball"));
        debbie.addToy(new Toy("doll"));
        ksession.insert((Object)bob);
        ksession.fireAllRules();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertTrue((boolean)list.contains("car"));
        Assert.assertTrue((boolean)list.contains("ball"));
        list.clear();
        debbie.setAge(11);
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertTrue((boolean)list.contains("doll"));
    }

    @Test
    public void testReactiveDeleteOnLia() {
        Object obj;
        String drl = "import org.drools.compiler.xpath.tobeinstrumented.model.*;\nglobal java.util.List list\n\nrule R when\n  Man( $toy: /wife/children{age > 10}/toys )\nthen\n  list.add( $toy.getName() );\nend\n";
        KieBase kbase = new KieHelper().addContent(drl, ResourceType.DRL).build(new KieBaseOption[0]);
        KieSession ksession = kbase.newKieSession();
        EntryPointNode epn = (EntryPointNode)((InternalKnowledgeBase)ksession.getKieBase()).getRete().getEntryPointNodes().values().iterator().next();
        ObjectTypeNode otn = epn.getObjectTypeNodes().values().stream().filter(ot -> ot.getObjectType() instanceof ClassObjectType && !((ClassObjectType)ot.getObjectType()).getClassName().contains("InitialFact")).findFirst().get();
        LeftInputAdapterNode lian = (LeftInputAdapterNode)otn.getObjectSinkPropagator().getSinks()[0];
        ReactiveFromNode from1 = (ReactiveFromNode)lian.getSinkPropagator().getSinks()[0];
        ReactiveFromNode from2 = (ReactiveFromNode)from1.getSinkPropagator().getSinks()[0];
        ReactiveFromNode from3 = (ReactiveFromNode)from2.getSinkPropagator().getSinks()[0];
        BetaMemory betaMemory = ((ReactiveFromNode.ReactiveFromMemory)((InternalWorkingMemory)ksession).getNodeMemory((MemoryFactory)from3)).getBetaMemory();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        Woman alice = new Woman("Alice", 38);
        Man bob = new Man("Bob", 40);
        bob.setWife(alice);
        Child charlie = new Child("Charles", 12);
        Child debbie = new Child("Debbie", 11);
        alice.addChild(charlie);
        alice.addChild(debbie);
        charlie.addToy(new Toy("car"));
        charlie.addToy(new Toy("ball"));
        debbie.addToy(new Toy("doll"));
        ksession.insert((Object)bob);
        ksession.fireAllRules();
        Assert.assertEquals((long)3L, (long)list.size());
        Assert.assertTrue((boolean)list.contains("car"));
        Assert.assertTrue((boolean)list.contains("ball"));
        Assert.assertTrue((boolean)list.contains("doll"));
        TupleMemory tupleMemory = betaMemory.getLeftTupleMemory();
        Assert.assertEquals((long)2L, (long)betaMemory.getLeftTupleMemory().size());
        Iterator it = tupleMemory.iterator();
        LeftTuple next = (LeftTuple)it.next();
        while (next != null) {
            obj = next.getFactHandle().getObject();
            Assert.assertTrue((obj == charlie || obj == debbie ? 1 : 0) != 0);
            next = (LeftTuple)it.next();
        }
        list.clear();
        debbie.setAge(10);
        ksession.fireAllRules();
        Assert.assertEquals((long)0L, (long)list.size());
        Assert.assertEquals((long)1L, (long)betaMemory.getLeftTupleMemory().size());
        it = tupleMemory.iterator();
        next = (LeftTuple)it.next();
        while (next != null) {
            obj = next.getFactHandle().getObject();
            Assert.assertTrue((obj == charlie ? 1 : 0) != 0);
            next = (LeftTuple)it.next();
        }
    }

    @Test
    public void testReactiveOnBeta() {
        String drl = "import org.drools.compiler.xpath.tobeinstrumented.model.*;\nglobal java.util.List list\n\nrule R when\n  $i : Integer()\n  Man( $toy: /wife/children{age > $i}?/toys )\nthen\n  list.add( $toy.getName() );\nend\n";
        KieSession ksession = new KieHelper().addContent(drl, ResourceType.DRL).build(new KieBaseOption[0]).newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        Woman alice = new Woman("Alice", 38);
        Man bob = new Man("Bob", 40);
        bob.setWife(alice);
        Child charlie = new Child("Charles", 12);
        Child debbie = new Child("Debbie", 10);
        alice.addChild(charlie);
        alice.addChild(debbie);
        charlie.addToy(new Toy("car"));
        charlie.addToy(new Toy("ball"));
        debbie.addToy(new Toy("doll"));
        ksession.insert((Object)10);
        ksession.insert((Object)bob);
        ksession.fireAllRules();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertTrue((boolean)list.contains("car"));
        Assert.assertTrue((boolean)list.contains("ball"));
        list.clear();
        debbie.setAge(11);
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertTrue((boolean)list.contains("doll"));
    }

    @Test
    public void testReactive2Rules() {
        String drl = "import org.drools.compiler.xpath.tobeinstrumented.model.*;\nglobal java.util.List toyList\nglobal java.util.List teenagers\n\nrule R1 when\n  $i : Integer()\n  Man( $toy: /wife/children{age >= $i}/toys )\nthen\n  toyList.add( $toy.getName() );\nend\nrule R2 when\n  School( $child: /children{age >= 13} )\nthen\n  teenagers.add( $child.getName() );\nend\n";
        KieSession ksession = new KieHelper().addContent(drl, ResourceType.DRL).build(new KieBaseOption[0]).newKieSession();
        ArrayList toyList = new ArrayList();
        ksession.setGlobal("toyList", toyList);
        ArrayList teenagers = new ArrayList();
        ksession.setGlobal("teenagers", teenagers);
        Woman alice = new Woman("Alice", 38);
        Man bob = new Man("Bob", 40);
        bob.setWife(alice);
        Child charlie = new Child("Charles", 15);
        Child debbie = new Child("Debbie", 12);
        alice.addChild(charlie);
        alice.addChild(debbie);
        charlie.addToy(new Toy("car"));
        charlie.addToy(new Toy("ball"));
        debbie.addToy(new Toy("doll"));
        School school = new School("Da Vinci");
        school.addChild(charlie);
        school.addChild(debbie);
        ksession.insert((Object)13);
        ksession.insert((Object)bob);
        ksession.insert((Object)school);
        ksession.fireAllRules();
        Assert.assertEquals((long)2L, (long)toyList.size());
        Assert.assertTrue((boolean)toyList.contains("car"));
        Assert.assertTrue((boolean)toyList.contains("ball"));
        Assert.assertEquals((long)1L, (long)teenagers.size());
        Assert.assertTrue((boolean)teenagers.contains("Charles"));
        toyList.clear();
        debbie.setAge(13);
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)toyList.size());
        Assert.assertTrue((boolean)toyList.contains("doll"));
        Assert.assertEquals((long)2L, (long)teenagers.size());
        Assert.assertTrue((boolean)teenagers.contains("Charles"));
        Assert.assertTrue((boolean)teenagers.contains("Debbie"));
    }

    @Test
    public void testListReactive() {
        String drl = "import org.drools.compiler.xpath.tobeinstrumented.model.*;\n\nrule R2 when\n  School( $child: /children{age >= 13 && age < 20} )\nthen\n  System.out.println( $child );\n  insertLogical( $child );\nend\n";
        KieSession ksession = new KieHelper().addContent(drl, ResourceType.DRL).build(new KieBaseOption[0]).newKieSession();
        Child charlie = new Child("Charles", 15);
        Child debbie = new Child("Debbie", 19);
        School school = new School("Da Vinci");
        school.addChild(charlie);
        ksession.insert((Object)school);
        ksession.fireAllRules();
        Assert.assertTrue((boolean)ksession.getObjects().contains(charlie));
        Assert.assertFalse((boolean)ksession.getObjects().contains(debbie));
        school.addChild(debbie);
        ksession.fireAllRules();
        Assert.assertTrue((boolean)ksession.getObjects().contains(charlie));
        Assert.assertTrue((boolean)ksession.getObjects().contains(debbie));
        school.removeChild(debbie);
        ksession.fireAllRules();
        Assert.assertTrue((boolean)ksession.getObjects().contains(charlie));
        Assert.assertFalse((boolean)ksession.getObjects().contains(debbie));
        school.addChild(debbie);
        ksession.fireAllRules();
        Assert.assertTrue((boolean)ksession.getObjects().contains(charlie));
        Assert.assertTrue((boolean)ksession.getObjects().contains(debbie));
        debbie.setAge(20);
        ksession.fireAllRules();
        Assert.assertTrue((boolean)ksession.getObjects().contains(charlie));
        Assert.assertFalse((boolean)ksession.getObjects().contains(debbie));
    }
}

