/*
 * Decompiled with CFR 0.152.
 */
package org.kie.maven.plugin;

import io.takari.maven.testing.executor.MavenExecutionResult;
import io.takari.maven.testing.executor.MavenRuntime;
import java.io.File;
import java.io.FilenameFilter;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import org.drools.core.phreak.ReactiveObject;
import org.junit.Assert;
import org.junit.Test;
import org.kie.maven.plugin.BytecodeInjectReactive;
import org.kie.maven.plugin.KieMavenPluginBaseIntegrationTest;

public class InjectReactiveIntegrationTest
extends KieMavenPluginBaseIntegrationTest {
    public InjectReactiveIntegrationTest(MavenRuntime.MavenRuntimeBuilder builder) throws Exception {
        super(builder);
    }

    @Test
    public void testBasicBytecodeInjection() throws Exception {
        File basedir = this.resources.getBasedir("kjar-4-bytecode-inject");
        MavenExecutionResult result = this.mavenRuntime.forProject(basedir).execute(new String[]{"clean", "install"});
        result.assertErrorFreeLog();
        File classDir = new File(basedir, "target/classes");
        System.out.println(classDir);
        ArrayList<URL> classloadingURLs = new ArrayList<URL>();
        classloadingURLs.add(classDir.toURI().toURL());
        classloadingURLs.add(new File(BytecodeInjectReactive.classpathFromClass(ReactiveObject.class)).toURI().toURL());
        File libDir = new File(basedir, "target/lib");
        for (File jar : libDir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".jar");
            }
        })) {
            classloadingURLs.add(jar.toURI().toURL());
        }
        URLClassLoader cl = new URLClassLoader(classloadingURLs.toArray(new URL[0]), null);
        Assert.assertTrue((boolean)this.looksLikeInstrumentedClass(cl.loadClass("org.drools.compiler.xpath.tobeinstrumented.model.Adult")));
        Assert.assertTrue((boolean)this.looksLikeInstrumentedClass(cl.loadClass("org.drools.compiler.xpath.tobeinstrumented.model.UsingADependencyClass")));
        Assert.assertTrue((boolean)this.looksLikeInstrumentedClass(cl.loadClass("org.drools.compiler.xpath.tobeinstrumented.model.UsingSpecializedList")));
        Assert.assertTrue((boolean)this.looksLikeInstrumentedClass(cl.loadClass("org.drools.compiler.xpath.tobeinstrumented.model.TMFile")));
        Assert.assertTrue((boolean)this.looksLikeInstrumentedClass(cl.loadClass("org.drools.compiler.xpath.tobeinstrumented.model.TMFileSet")));
        Assert.assertFalse((boolean)this.looksLikeInstrumentedClass(cl.loadClass("org.drools.compiler.xpath.tobeinstrumented.model.ImmutablePojo")));
        Assert.assertFalse((boolean)this.looksLikeInstrumentedClass(cl.loadClass("org.drools.compiler.xpath.tobeinstrumented.model.FieldIsNotListInterface")));
    }

    @Test
    public void testBasicBytecodeInjectionSelected() throws Exception {
        File basedir = this.resources.getBasedir("kjar-5-bytecode-inject-selected");
        MavenExecutionResult result = this.mavenRuntime.forProject(basedir).execute(new String[]{"clean", "install"});
        result.assertErrorFreeLog();
        File classDir = new File(basedir, "target/classes");
        System.out.println(classDir);
        ArrayList<URL> classloadingURLs = new ArrayList<URL>();
        classloadingURLs.add(classDir.toURI().toURL());
        classloadingURLs.add(new File(BytecodeInjectReactive.classpathFromClass(ReactiveObject.class)).toURI().toURL());
        File libDir = new File(basedir, "target/lib");
        for (File jar : libDir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".jar");
            }
        })) {
            classloadingURLs.add(jar.toURI().toURL());
        }
        URLClassLoader cl = new URLClassLoader(classloadingURLs.toArray(new URL[0]), null);
        Assert.assertTrue((boolean)this.looksLikeInstrumentedClass(cl.loadClass("org.drools.compiler.xpath.tobeinstrumented.model.Adult")));
        Assert.assertTrue((boolean)this.looksLikeInstrumentedClass(cl.loadClass("org.drools.compiler.xpath.tobeinstrumented.model.UsingADependencyClass")));
        Assert.assertTrue((boolean)this.looksLikeInstrumentedClass(cl.loadClass("org.drools.compiler.xpath.tobeinstrumented.model.UsingSpecializedList")));
        Assert.assertTrue((boolean)this.looksLikeInstrumentedClass(cl.loadClass("org.drools.compiler.xpath.tobeinstrumented.model.TMFile")));
        Assert.assertTrue((boolean)this.looksLikeInstrumentedClass(cl.loadClass("org.drools.compiler.xpath.tobeinstrumented.model.TMFileSet")));
        Assert.assertFalse((boolean)this.looksLikeInstrumentedClass(cl.loadClass("org.drools.compiler.xpath.tobeinstrumented.model.ImmutablePojo")));
        Assert.assertTrue((boolean)this.looksLikeInstrumentedClass(cl.loadClass("to.instrument.Adult")));
        Assert.assertTrue((boolean)this.looksLikeInstrumentedClass(cl.loadClass("to.instrument.UsingADependencyClass")));
        Assert.assertTrue((boolean)this.looksLikeInstrumentedClass(cl.loadClass("to.instrument.UsingSpecializedList")));
        Assert.assertTrue((boolean)this.looksLikeInstrumentedClass(cl.loadClass("to.instrument.TMFile")));
        Assert.assertTrue((boolean)this.looksLikeInstrumentedClass(cl.loadClass("to.instrument.TMFileSet")));
        Assert.assertFalse((boolean)this.looksLikeInstrumentedClass(cl.loadClass("to.instrument.ImmutablePojo")));
        Assert.assertFalse((boolean)this.looksLikeInstrumentedClass(cl.loadClass("to.not.instrument.Adult")));
        Assert.assertFalse((boolean)this.looksLikeInstrumentedClass(cl.loadClass("to.not.instrument.UsingADependencyClass")));
        Assert.assertFalse((boolean)this.looksLikeInstrumentedClass(cl.loadClass("to.not.instrument.UsingSpecializedList")));
        Assert.assertFalse((boolean)this.looksLikeInstrumentedClass(cl.loadClass("to.not.instrument.TMFile")));
        Assert.assertFalse((boolean)this.looksLikeInstrumentedClass(cl.loadClass("to.not.instrument.TMFileSet")));
        Assert.assertFalse((boolean)this.looksLikeInstrumentedClass(cl.loadClass("to.not.instrument.ImmutablePojo")));
    }

    private boolean looksLikeInstrumentedClass(Class<?> personClass) {
        boolean foundReactiveObjectInterface = false;
        for (Class<?> i : personClass.getInterfaces()) {
            if (!i.getName().equals(ReactiveObject.class.getName())) continue;
            foundReactiveObjectInterface = true;
        }
        boolean containsGetLeftTuple = this.checkContainsMethod(personClass, "getLeftTuples");
        boolean containsAddLeftTuple = this.checkContainsMethod(personClass, "addLeftTuple");
        boolean containsRemoveLeftTuple = this.checkContainsMethod(personClass, "removeLeftTuple");
        boolean foundReactiveInjectedMethods = false;
        for (Method m : personClass.getMethods()) {
            if (!m.getName().startsWith("$$_drools_")) continue;
            foundReactiveInjectedMethods = true;
        }
        return foundReactiveObjectInterface && containsGetLeftTuple && containsAddLeftTuple && containsRemoveLeftTuple && foundReactiveInjectedMethods;
    }

    private boolean checkContainsMethod(Class<?> personClass, Object methodName) {
        for (Method m : personClass.getMethods()) {
            if (!m.getName().equals(methodName)) continue;
            return true;
        }
        return false;
    }
}

