/*
 * Decompiled with CFR 0.152.
 */
package org.kie.maven.plugin;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.inject.Inject;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.resolver.filter.CumulativeScopeArtifactFilter;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.drools.compiler.commons.jci.stores.ResourceStore;
import org.drools.compiler.kie.builder.impl.FileKieModule;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.drools.compiler.kie.builder.impl.KieBuilderImpl;
import org.drools.compiler.kie.builder.impl.KieContainerImpl;
import org.drools.compiler.kie.builder.impl.KieMetaInfoBuilder;
import org.drools.compiler.kie.builder.impl.KieProject;
import org.drools.compiler.kie.builder.impl.ResultsImpl;
import org.drools.compiler.kie.builder.impl.ZipKieModule;
import org.drools.compiler.kproject.ReleaseIdImpl;
import org.drools.compiler.kproject.models.KieModuleModelImpl;
import org.drools.core.rule.KieModuleMetaInfo;
import org.kie.api.KieServices;
import org.kie.api.builder.KieRepository;
import org.kie.api.builder.Message;
import org.kie.api.builder.ReleaseId;
import org.kie.api.builder.model.KieModuleModel;
import org.kie.api.io.Resource;
import org.kie.maven.plugin.AbstractKieMojo;
import org.kie.maven.plugin.DiskResourceStore;

@Mojo(name="build", requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, requiresProject=true, defaultPhase=LifecyclePhase.COMPILE)
public class BuildMojo
extends AbstractKieMojo {
    @Parameter(required=true, defaultValue="${project.build.outputDirectory}")
    private File outputDirectory;
    @Parameter(required=true, defaultValue="src/main/resources")
    private File sourceFolder;
    @Parameter(required=true, defaultValue="${project}")
    private MavenProject project;
    @Parameter
    private Map<String, String> properties;
    @Parameter(required=false, defaultValue="${compilation.ID}")
    private String compilationID;
    @Inject
    private PlexusContainer container;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        ArrayList<ZipKieModule> kmoduleDeps = new ArrayList<ZipKieModule>();
        try {
            HashSet<URL> urls = new HashSet<URL>();
            for (String element : this.project.getCompileClasspathElements()) {
                urls.add(new File(element).toURI().toURL());
            }
            this.project.setArtifactFilter((ArtifactFilter)new CumulativeScopeArtifactFilter(Arrays.asList("compile", "runtime")));
            for (Artifact artifact : this.project.getArtifacts()) {
                File file = artifact.getFile();
                if (file == null) continue;
                urls.add(file.toURI().toURL());
                KieModuleModel kieModuleModel = this.getDependencyKieModel(file);
                if (kieModuleModel == null) continue;
                ReleaseIdImpl releaseId = new ReleaseIdImpl(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion());
                kmoduleDeps.add(new ZipKieModule((ReleaseId)releaseId, kieModuleModel, file));
            }
            urls.add(this.outputDirectory.toURI().toURL());
            URLClassLoader projectClassLoader = URLClassLoader.newInstance(urls.toArray(new URL[0]), Thread.currentThread().getContextClassLoader());
            Thread.currentThread().setContextClassLoader(projectClassLoader);
        }
        catch (DependencyResolutionRequiredException e) {
            throw new RuntimeException(e);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        KieServices ks = KieServices.Factory.get();
        try {
            this.setSystemProperties(this.properties);
            KieRepository kr = ks.getRepository();
            InternalKieModule kModule = (InternalKieModule)kr.addKieModule(ks.getResources().newFileSystemResource(this.sourceFolder), new Resource[0]);
            for (InternalKieModule internalKieModule : kmoduleDeps) {
                kModule.addKieDependency(internalKieModule);
            }
            KieContainerImpl kContainer = (KieContainerImpl)ks.newKieContainer(kModule.getReleaseId());
            KieProject kieProject = kContainer.getKieProject();
            ResultsImpl messages = kieProject.verify();
            List errors = messages.filterMessages(new Message.Level[]{Message.Level.ERROR});
            if (!errors.isEmpty()) {
                for (Message error : errors) {
                    this.getLog().error((CharSequence)error.toString());
                }
                throw new MojoFailureException("Build failed!");
            }
            if (this.container != null && this.compilationID != null) {
                this.shareKieObjectsWithMap(kModule);
            } else {
                new KieMetaInfoBuilder(kModule).writeKieModuleMetaInfo((ResourceStore)new DiskResourceStore(this.outputDirectory));
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextClassLoader);
        }
        this.getLog().info((CharSequence)"KieModule successfully built!");
    }

    private void shareKieObjectsWithMap(InternalKieModule kModule) {
        Optional<Map<String, Object>> optionalKieMap = this.getKieMap();
        if (optionalKieMap.isPresent()) {
            KieMetaInfoBuilder builder = new KieMetaInfoBuilder(kModule);
            KieModuleMetaInfo modelMetaInfo = builder.getKieModuleMetaInfo();
            StringBuilder sbModelMetaInfo = new StringBuilder(this.compilationID).append(".").append(KieModuleMetaInfo.class.getName());
            StringBuilder sbkModule = new StringBuilder(this.compilationID).append(".").append(FileKieModule.class.getName());
            if (modelMetaInfo != null) {
                optionalKieMap.get().put(sbModelMetaInfo.toString(), modelMetaInfo);
                this.getLog().info((CharSequence)"KieModelMetaInfo available in the map shared with the Maven Embedder");
            }
            if (kModule != null) {
                optionalKieMap.get().put(sbkModule.toString(), kModule);
                this.getLog().info((CharSequence)"KieModule available in the map shared with the Maven Embedder");
            }
        }
    }

    private Optional<Map<String, Object>> getKieMap() {
        try {
            Map kieMap = (Map)this.container.lookup(Map.class, "java.util.HashMap", "kieMap");
            return Optional.of(kieMap);
        }
        catch (ComponentLookupException cle) {
            this.getLog().info((CharSequence)"kieMap not present with compilationID and container present");
            return Optional.empty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private KieModuleModel getDependencyKieModel(File jar) {
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(jar);
            ZipEntry zipEntry = zipFile.getEntry("META-INF/kmodule.xml");
            if (zipEntry != null) {
                KieModuleModel kieModuleModel = KieModuleModelImpl.fromXML((InputStream)zipFile.getInputStream(zipEntry));
                KieBuilderImpl.setDefaultsforEmptyKieModule((KieModuleModel)kieModuleModel);
                KieModuleModel kieModuleModel2 = kieModuleModel;
                return kieModuleModel2;
            }
        }
        catch (Exception exception) {
        }
        finally {
            if (zipFile != null) {
                try {
                    zipFile.close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }
}

