/*
 * Decompiled with CFR 0.152.
 */
package org.kie.maven.plugin;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javassist.ClassPool;
import javassist.CtClass;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.drools.core.phreak.ReactiveObject;
import org.kie.maven.plugin.AbstractKieMojo;
import org.kie.maven.plugin.BytecodeInjectReactive;

@Mojo(name="injectreactive", requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, requiresProject=true, defaultPhase=LifecyclePhase.COMPILE)
@Execute(goal="injectreactive", phase=LifecyclePhase.COMPILE)
public class InjectReactiveMojo
extends AbstractKieMojo {
    private List<File> sourceSet = new ArrayList<File>();
    @Parameter(required=true, defaultValue="${project.build.outputDirectory}")
    private File outputDirectory;
    @Parameter(alias="instrument-enabled", property="kie.instrument.enabled", defaultValue="false")
    private boolean enabled;
    @Parameter(alias="instrument-failOnError", property="kie.instrument.failOnError", defaultValue="true")
    private boolean failOnError;
    @Parameter(alias="instrument-packages", property="kie.instrument.packages")
    private String[] instrumentPackages;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (!this.enabled) {
            this.getLog().debug((CharSequence)"Configuration for instrument-enabled is false, skipping goal 'injectreactive' execute() end.");
            return;
        }
        if (this.instrumentPackages.length == 0) {
            this.getLog().debug((CharSequence)"No configuration passed for instrument-packages, default to '*' .");
            this.instrumentPackages = new String[]{"*"};
        }
        this.getLog().debug((CharSequence)("Configured with resolved instrument-packages: " + Arrays.asList(this.instrumentPackages)));
        List<String> packageRegExps = InjectReactiveMojo.convertAllToPkgRegExps(this.instrumentPackages);
        for (String prefix : packageRegExps) {
            this.getLog().debug((CharSequence)(" " + prefix));
        }
        File root = this.outputDirectory;
        if (!root.exists()) {
            this.getLog().info((CharSequence)("Skipping InjectReactive enhancement plugin execution since there is no classes dir " + this.outputDirectory));
            return;
        }
        this.walkDir(root);
        if (this.sourceSet.isEmpty()) {
            this.getLog().info((CharSequence)("Skipping InjectReactive enhancement plugin execution since there are no classes to enhance on " + this.outputDirectory));
            return;
        }
        this.getLog().info((CharSequence)("Starting InjectReactive enhancement for classes on " + this.outputDirectory));
        ClassLoader classLoader = this.toClassLoader(Collections.singletonList(root));
        ClassPool classPool = new ClassPool(true);
        try {
            this.getLog().info((CharSequence)("Adding to ClassPool the classpath: " + this.outputDirectory.getAbsolutePath()));
            classPool.appendClassPath(this.outputDirectory.getAbsolutePath());
        }
        catch (Exception e) {
            this.getLog().error((CharSequence)("Unable to append path for outputDirectory : " + this.outputDirectory));
            if (this.failOnError) {
                throw new MojoExecutionException("Unable to append path for outputDirectory : " + this.outputDirectory, e);
            }
            return;
        }
        try {
            String aname = ReactiveObject.class.getPackage().getName().replaceAll("\\.", "/") + "/" + ReactiveObject.class.getSimpleName() + ".class";
            this.getLog().info((CharSequence)("Resolving ReactiveObject from : " + aname));
            String apath = Thread.currentThread().getContextClassLoader().getResource(aname).getPath();
            this.getLog().info((CharSequence)(".. as in resource: " + apath));
            String path = null;
            path = apath.contains("!") ? apath.substring(0, apath.indexOf("!")) : "file:" + apath.substring(0, apath.indexOf(aname));
            this.getLog().info((CharSequence)(".. as in file path: " + path));
            File f = new File(new URI(path));
            this.getLog().info((CharSequence)("Adding to ClassPool the classpath: " + f.getAbsolutePath()));
            classPool.appendClassPath(f.getAbsolutePath());
        }
        catch (Exception e) {
            this.getLog().error((CharSequence)"Unable to locate path for ReactiveObject.");
            e.printStackTrace();
            if (this.failOnError) {
                throw new MojoExecutionException("Unable to locate path for ReactiveObject.", e);
            }
            return;
        }
        for (URL url : this.dependenciesURLs()) {
            try {
                this.getLog().info((CharSequence)("Adding to ClassPool the classpath: " + url.getPath()));
                classPool.appendClassPath(url.getPath());
            }
            catch (Exception e) {
                this.getLog().error((CharSequence)("Unable to append path for project dependency : " + url.getPath()));
                if (this.failOnError) {
                    throw new MojoExecutionException("Unable to append path for project dependency : " + url.getPath(), e);
                }
                return;
            }
        }
        BytecodeInjectReactive enhancer = BytecodeInjectReactive.newInstance(classPool);
        for (File file : this.sourceSet) {
            CtClass ctClass = this.toCtClass(file, classPool);
            if (ctClass == null) continue;
            this.getLog().info((CharSequence)("Evaluating class [" + ctClass.getName() + "]"));
            this.getLog().info((CharSequence)ctClass.getPackageName());
            this.getLog().info((CharSequence)("" + Arrays.asList(packageRegExps)));
            if (!InjectReactiveMojo.isPackageNameIncluded(ctClass.getPackageName(), packageRegExps)) continue;
            try {
                byte[] enhancedBytecode = enhancer.injectReactive(ctClass.getName());
                this.writeOutEnhancedClass(enhancedBytecode, ctClass, file);
                this.getLog().info((CharSequence)("Successfully enhanced class [" + ctClass.getName() + "]"));
            }
            catch (Exception e) {
                this.getLog().error((CharSequence)("ERROR while trying to enhanced class [" + ctClass.getName() + "]"));
                e.printStackTrace();
                if (this.failOnError) {
                    throw new MojoExecutionException("ERROR while trying to enhanced class [" + ctClass.getName() + "]", e);
                }
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private CtClass toCtClass(File file, ClassPool classPool) throws MojoExecutionException {
        try {
            FileInputStream is = new FileInputStream(file.getAbsolutePath());
            try {
                CtClass ctClass = classPool.makeClass((InputStream)is);
                return ctClass;
            }
            catch (IOException e) {
                String msg = "Javassist unable to load class in preparation for enhancing: " + file.getAbsolutePath();
                if (this.failOnError) {
                    throw new MojoExecutionException(msg, (Exception)e);
                }
                this.getLog().warn((CharSequence)msg);
                CtClass ctClass2 = null;
                return ctClass2;
            }
            finally {
                try {
                    ((InputStream)is).close();
                }
                catch (IOException e4) {
                    this.getLog().info((CharSequence)("Was unable to close InputStream : " + file.getAbsolutePath()), (Throwable)e4);
                }
            }
        }
        catch (FileNotFoundException e3) {
            String msg = "Unable to locate class file for InputStream: " + file.getAbsolutePath();
            if (this.failOnError) {
                throw new MojoExecutionException(msg, (Exception)e3);
            }
            this.getLog().warn((CharSequence)msg);
            return null;
        }
    }

    private ClassLoader toClassLoader(List<File> runtimeClasspath) throws MojoExecutionException {
        ArrayList<URL> urls = new ArrayList<URL>();
        for (File file : runtimeClasspath) {
            try {
                urls.add(file.toURI().toURL());
                this.getLog().debug((CharSequence)("Adding classpath entry for classes root " + file.getAbsolutePath()));
            }
            catch (MalformedURLException e) {
                String msg = "Unable to resolve classpath entry to URL: " + file.getAbsolutePath();
                if (this.failOnError) {
                    throw new MojoExecutionException(msg, (Exception)e);
                }
                this.getLog().warn((CharSequence)msg);
            }
        }
        urls.addAll(this.dependenciesURLs());
        return new URLClassLoader(urls.toArray(new URL[urls.size()]), null);
    }

    private List<URL> dependenciesURLs() throws MojoExecutionException {
        ArrayList<URL> urls = new ArrayList<URL>();
        Set artifacts = null;
        MavenProject project = (MavenProject)this.getPluginContext().get("project");
        if (project != null) {
            MavenProject executionProject = project.getExecutionProject();
            Set set = artifacts = executionProject != null ? executionProject.getArtifacts() : project.getArtifacts();
        }
        if (artifacts != null) {
            for (Artifact a : artifacts) {
                if ("test".equals(a.getScope())) continue;
                try {
                    urls.add(a.getFile().toURI().toURL());
                    this.getLog().debug((CharSequence)("Adding classpath entry for dependency " + a.getId()));
                }
                catch (MalformedURLException e) {
                    String msg = "Unable to resolve URL for dependency " + a.getId() + " at " + a.getFile().getAbsolutePath();
                    if (this.failOnError) {
                        throw new MojoExecutionException(msg, (Exception)e);
                    }
                    this.getLog().warn((CharSequence)msg);
                }
            }
        }
        return urls;
    }

    private void walkDir(File dir) {
        this.walkDir(dir, new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isFile() && pathname.getName().endsWith(".class");
            }
        }, new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isDirectory();
            }
        });
    }

    private void walkDir(File dir, FileFilter classesFilter, FileFilter dirFilter) {
        File[] dirs;
        for (File dir1 : dirs = dir.listFiles(dirFilter)) {
            this.walkDir(dir1, classesFilter, dirFilter);
        }
        File[] files = dir.listFiles(classesFilter);
        Collections.addAll(this.sourceSet, files);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeOutEnhancedClass(byte[] enhancedBytecode, CtClass ctClass, File file) throws MojoExecutionException {
        if (enhancedBytecode == null) {
            return;
        }
        try {
            if (file.delete()) {
                if (!file.createNewFile()) {
                    this.getLog().error((CharSequence)("Unable to recreate class file [" + ctClass.getName() + "]"));
                }
            } else {
                this.getLog().error((CharSequence)("Unable to delete class file [" + ctClass.getName() + "]"));
            }
        }
        catch (IOException e) {
            this.getLog().warn((CharSequence)("Problem preparing class file for writing out enhancements [" + ctClass.getName() + "]"));
        }
        try {
            FileOutputStream outputStream = new FileOutputStream(file, false);
            try {
                outputStream.write(enhancedBytecode);
                outputStream.flush();
            }
            catch (IOException e) {
                String msg = String.format("Error writing to enhanced class [%s] to file [%s]", ctClass.getName(), file.getAbsolutePath());
                if (this.failOnError) {
                    throw new MojoExecutionException(msg, (Exception)e);
                }
                this.getLog().warn((CharSequence)msg);
            }
            finally {
                try {
                    outputStream.close();
                    ctClass.detach();
                }
                catch (IOException e) {}
            }
        }
        catch (FileNotFoundException e) {
            String msg = "Error opening class file for writing: " + file.getAbsolutePath();
            if (this.failOnError) {
                throw new MojoExecutionException(msg, (Exception)e);
            }
            this.getLog().warn((CharSequence)msg);
        }
    }

    public static List<String> convertAllToPkgRegExps(String[] patterns) {
        ArrayList<String> result = new ArrayList<String>();
        for (String p : patterns) {
            if (p.equals("*")) {
                result.add("^.*$");
                continue;
            }
            if (!p.endsWith(".*")) {
                result.add("^" + p.replaceAll("\\.", "\\\\.").replaceAll("\\*", ".*") + "$");
                continue;
            }
            if (p.endsWith(".*")) {
                result.add("^" + p.substring(0, p.length() - 2).replaceAll("\\.", "\\\\.").replaceAll("\\*", ".*") + "$");
                result.add("^" + p.replaceAll("\\.", "\\\\.").replaceAll("\\*", ".*") + "$");
                continue;
            }
            result.add(p);
        }
        return result;
    }

    public static boolean isPackageNameIncluded(String packageName, List<String> regexps) {
        for (String r : regexps) {
            if (!packageName.matches(r)) continue;
            return true;
        }
        return false;
    }
}

