/*
 * Decompiled with CFR 0.152.
 */
package org.kie.maven.plugin;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.project.MavenProject;
import org.appformer.maven.support.AFReleaseId;
import org.appformer.maven.support.AFReleaseIdImpl;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Condition;
import org.assertj.core.api.IterableAssert;
import org.junit.Test;
import org.kie.maven.plugin.ProjectPomModel;
import org.mockito.Mockito;

public class ProjectPomModelTest {
    private static final String GROUP_ID = "org.kie.test.groupid";
    private static final String ARTIFACT_ID = "test-artifact";
    private static final String PARENT_ARTIFACT_ID = "parent-artifact";
    private static final String VERSION = "1.0";
    private static final String PACKAGING = "kjar";
    private static final String DEPENDENCY_GROUP_ID = "org.kie.test.dependency.groupid";
    private static final String DEPENDENCY_ARTIFACT_ID1 = "dependency-artifact1";
    private static final String DEPENDENCY_ARTIFACT_ID2 = "dependency-artifact2";
    private static final String DEPENDENCY_VERSION = "1.0";
    private static final String DEPENDENCY_PACKAGING = "jar";
    private static final String DEPENDENCY_SCOPE1 = "compile";
    private static final String DEPENDENCY_SCOPE2 = "test";

    @Test
    public void getReleaseId() {
        MavenSession mavenSession = this.mockMavenSession(false);
        ProjectPomModel pomModel = new ProjectPomModel(mavenSession);
        AFReleaseId releaseId = pomModel.getReleaseId();
        this.assertReleaseId(releaseId, ARTIFACT_ID);
    }

    @Test
    public void getParentReleaseId() {
        MavenSession mavenSession = this.mockMavenSession(true);
        ProjectPomModel pomModel = new ProjectPomModel(mavenSession);
        AFReleaseId releaseId = pomModel.getParentReleaseId();
        this.assertReleaseId(releaseId, PARENT_ARTIFACT_ID);
    }

    @Test
    public void getParentReleaseIdNull() {
        MavenSession mavenSession = this.mockMavenSession(false);
        ProjectPomModel pomModel = new ProjectPomModel(mavenSession);
        Assertions.assertThat((Object)pomModel.getParentReleaseId()).isNull();
    }

    @Test
    public void getDependencies() {
        MavenSession mavenSession = this.mockMavenSession(false);
        this.mockDependencies(mavenSession.getCurrentProject());
        ProjectPomModel pomModel = new ProjectPomModel(mavenSession);
        Collection dependencies = pomModel.getDependencies();
        ((IterableAssert)Assertions.assertThat((Iterable)dependencies).isNotNull()).hasSize(2);
        Assertions.assertThat((Iterable)dependencies).areExactly(1, new Condition(releaseId -> releaseId instanceof AFReleaseIdImpl && DEPENDENCY_GROUP_ID.equals(releaseId.getGroupId()) && DEPENDENCY_ARTIFACT_ID1.equals(releaseId.getArtifactId()) && "1.0".equals(releaseId.getVersion()) && DEPENDENCY_PACKAGING.equals(((AFReleaseIdImpl)releaseId).getType()), "Is dependency 1", new Object[0]));
        Assertions.assertThat((Iterable)dependencies).areExactly(1, new Condition(releaseId -> releaseId instanceof AFReleaseIdImpl && DEPENDENCY_GROUP_ID.equals(releaseId.getGroupId()) && DEPENDENCY_ARTIFACT_ID2.equals(releaseId.getArtifactId()) && "1.0".equals(releaseId.getVersion()) && DEPENDENCY_PACKAGING.equals(((AFReleaseIdImpl)releaseId).getType()), "Is dependency 2", new Object[0]));
    }

    @Test
    public void getDependenciesEmpty() {
        MavenSession mavenSession = this.mockMavenSession(false);
        ProjectPomModel pomModel = new ProjectPomModel(mavenSession);
        Collection dependencies = pomModel.getDependencies();
        ((IterableAssert)Assertions.assertThat((Iterable)dependencies).isNotNull()).isEmpty();
    }

    @Test
    public void getDependenciesWithFilter() {
        MavenSession mavenSession = this.mockMavenSession(false);
        this.mockDependencies(mavenSession.getCurrentProject());
        ProjectPomModel pomModel = new ProjectPomModel(mavenSession);
        Collection dependencies = pomModel.getDependencies((releaseId, scope) -> DEPENDENCY_SCOPE1.equals(scope));
        ((IterableAssert)Assertions.assertThat((Iterable)dependencies).isNotNull()).hasSize(1);
        Assertions.assertThat((Iterable)dependencies).areExactly(1, new Condition(releaseId -> releaseId instanceof AFReleaseIdImpl && DEPENDENCY_GROUP_ID.equals(releaseId.getGroupId()) && DEPENDENCY_ARTIFACT_ID1.equals(releaseId.getArtifactId()) && "1.0".equals(releaseId.getVersion()) && DEPENDENCY_PACKAGING.equals(((AFReleaseIdImpl)releaseId).getType()), "Is dependency 1", new Object[0]));
    }

    private MavenSession mockMavenSession(boolean addParentProject) {
        MavenSession mavenSession = (MavenSession)Mockito.mock(MavenSession.class);
        MavenProject currentProject = this.mockMavenProject(ARTIFACT_ID);
        if (addParentProject) {
            MavenProject parentProject = this.mockMavenProject(PARENT_ARTIFACT_ID);
            Mockito.when((Object)currentProject.getParent()).thenReturn((Object)parentProject);
        }
        Mockito.when((Object)mavenSession.getCurrentProject()).thenReturn((Object)currentProject);
        return mavenSession;
    }

    private MavenProject mockMavenProject(String artifactId) {
        MavenProject mavenProject = (MavenProject)Mockito.mock(MavenProject.class);
        Mockito.when((Object)mavenProject.getGroupId()).thenReturn((Object)GROUP_ID);
        Mockito.when((Object)mavenProject.getArtifactId()).thenReturn((Object)artifactId);
        Mockito.when((Object)mavenProject.getVersion()).thenReturn((Object)"1.0");
        Mockito.when((Object)mavenProject.getPackaging()).thenReturn((Object)PACKAGING);
        return mavenProject;
    }

    private void mockDependencies(MavenProject mavenProject) {
        ArrayList<Dependency> dependencies = new ArrayList<Dependency>();
        dependencies.add(this.mockDependency(DEPENDENCY_ARTIFACT_ID1, DEPENDENCY_SCOPE1));
        dependencies.add(this.mockDependency(DEPENDENCY_ARTIFACT_ID2, DEPENDENCY_SCOPE2));
        Mockito.when((Object)mavenProject.getDependencies()).thenReturn(dependencies);
    }

    private Dependency mockDependency(String artifactId, String scope) {
        Dependency dependency = (Dependency)Mockito.mock(Dependency.class);
        Mockito.when((Object)dependency.getGroupId()).thenReturn((Object)DEPENDENCY_GROUP_ID);
        Mockito.when((Object)dependency.getArtifactId()).thenReturn((Object)artifactId);
        Mockito.when((Object)dependency.getVersion()).thenReturn((Object)"1.0");
        Mockito.when((Object)dependency.getType()).thenReturn((Object)DEPENDENCY_PACKAGING);
        Mockito.when((Object)dependency.getScope()).thenReturn((Object)scope);
        return dependency;
    }

    private void assertReleaseId(AFReleaseId releaseId, String artifactId) {
        ((AbstractObjectAssert)Assertions.assertThat((Object)releaseId).isNotNull()).isInstanceOf(AFReleaseIdImpl.class);
        Assertions.assertThat((String)releaseId.getGroupId()).isEqualTo((Object)GROUP_ID);
        Assertions.assertThat((String)releaseId.getArtifactId()).isEqualTo((Object)artifactId);
        Assertions.assertThat((String)releaseId.getVersion()).isEqualTo((Object)"1.0");
        Assertions.assertThat((String)((AFReleaseIdImpl)releaseId).getType()).isEqualTo((Object)PACKAGING);
    }
}

