/*
 * Decompiled with CFR 0.152.
 */
package org.kie.maven.plugin;

import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.ArtifactRepositoryPolicy;
import org.apache.maven.artifact.repository.MavenArtifactRepository;
import org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.repository.RepositorySystem;
import org.apache.maven.settings.Settings;
import org.apache.maven.shared.artifact.ArtifactCoordinate;
import org.apache.maven.shared.artifact.DefaultArtifactCoordinate;
import org.apache.maven.shared.artifact.resolve.ArtifactResolver;
import org.apache.maven.shared.artifact.resolve.ArtifactResolverException;
import org.apache.maven.shared.artifact.resolve.ArtifactResult;
import org.apache.maven.shared.dependencies.DefaultDependableCoordinate;
import org.apache.maven.shared.dependencies.DependableCoordinate;
import org.apache.maven.shared.dependencies.resolve.DependencyResolver;
import org.apache.maven.shared.dependencies.resolve.DependencyResolverException;
import org.apache.maven.shared.utils.StringUtils;
import org.kie.maven.plugin.AbstractKieMojo;
import org.kie.maven.plugin.ArtifactItem;

@Mojo(name="package-dependencies-kjar", defaultPhase=LifecyclePhase.PREPARE_PACKAGE, threadSafe=true, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class PackageKjarDependenciesMojo
extends AbstractKieMojo {
    private static final Pattern ALT_REPO_SYNTAX_PATTERN = Pattern.compile("(.+)::(.*)::(.+)");
    @Parameter(defaultValue="${project.build.outputDirectory}", required=true, readonly=true)
    private String outputDirectory;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter
    private String classifier;
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    private MavenSession session;
    @Component
    private ArtifactResolver artifactResolver;
    @Component
    private DependencyResolver dependencyResolver;
    @Parameter(defaultValue="${project.remoteArtifactRepositories}", readonly=true, required=true)
    private List<ArtifactRepository> pomRemoteRepositories;
    @Parameter(property="remoteRepositories")
    private String remoteRepositories;
    @Component
    private RepositorySystem repositorySystem;
    @Component
    private ArtifactHandlerManager artifactHandlerManager;
    @Component(role=ArtifactRepositoryLayout.class)
    private Map<String, ArtifactRepositoryLayout> repositoryLayouts;
    @Parameter
    private List<ArtifactItem> artifactItems;

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            File outputFolder;
            if (this.artifactItems == null || this.artifactItems.isEmpty()) {
                this.getLog().info((CharSequence)"Skipping plugin execution");
                return;
            }
            ArtifactRepositoryPolicy always = new ArtifactRepositoryPolicy(true, "always", "warn");
            ArrayList<ArtifactRepository> repoList = new ArrayList<ArtifactRepository>();
            if (this.pomRemoteRepositories != null) {
                repoList.addAll(this.pomRemoteRepositories);
            }
            if (this.remoteRepositories != null) {
                String[] repos = StringUtils.split((String)this.remoteRepositories, (String)",");
                for (String repo : repos) {
                    repoList.add(this.parseRepository(repo, always));
                }
            }
            if (!(outputFolder = new File(this.outputDirectory + "/KIE-INF/lib")).exists()) {
                outputFolder.mkdirs();
            }
            this.getLog().info((CharSequence)("Create directory: " + outputFolder));
            for (ArtifactItem artifactItem : this.artifactItems) {
                DefaultDependableCoordinate coordinate = new DefaultDependableCoordinate();
                coordinate.setArtifactId(artifactItem.getArtifactId());
                coordinate.setGroupId(artifactItem.getGroupId());
                coordinate.setVersion(artifactItem.getVersion());
                coordinate.setClassifier(artifactItem.getClassifier());
                coordinate.setType(artifactItem.getType());
                this.getLog().info((CharSequence)("Resolving " + coordinate + " with transitive dependencies"));
                DefaultProjectBuildingRequest buildingRequest = new DefaultProjectBuildingRequest(this.session.getProjectBuildingRequest());
                Settings settings = this.session.getSettings();
                this.repositorySystem.injectMirror(repoList, settings.getMirrors());
                this.repositorySystem.injectProxy(repoList, settings.getProxies());
                this.repositorySystem.injectAuthentication(repoList, settings.getServers());
                buildingRequest.setRemoteRepositories(repoList);
                Iterable results = this.dependencyResolver.resolveDependencies((ProjectBuildingRequest)buildingRequest, (DependableCoordinate)coordinate, null);
                for (ArtifactResult artifact : results) {
                    this.getLog().info((CharSequence)("Copying dependencies: " + artifact.getArtifact()));
                    ArtifactResult artifactResolverResult = this.artifactResolver.resolveArtifact((ProjectBuildingRequest)buildingRequest, this.toArtifactCoordinate(artifact.getArtifact()));
                    Artifact artifactResolved = artifactResolverResult.getArtifact();
                    File local = artifactResolved.getFile();
                    Files.copy((File)local, (File)new File(outputFolder, local.getName()));
                }
            }
        }
        catch (IOException | ArtifactResolverException | DependencyResolverException e) {
            throw new MojoExecutionException("Couldn't download artifact: " + e.getMessage(), (Exception)e);
        }
    }

    private ArtifactCoordinate toArtifactCoordinate(Artifact dependableCoordinate) {
        ArtifactHandler artifactHandler = this.artifactHandlerManager.getArtifactHandler(dependableCoordinate.getType());
        DefaultArtifactCoordinate artifactCoordinate = new DefaultArtifactCoordinate();
        artifactCoordinate.setGroupId(dependableCoordinate.getGroupId());
        artifactCoordinate.setArtifactId(dependableCoordinate.getArtifactId());
        artifactCoordinate.setVersion(dependableCoordinate.getVersion());
        artifactCoordinate.setClassifier(dependableCoordinate.getClassifier());
        artifactCoordinate.setExtension(artifactHandler.getExtension());
        return artifactCoordinate;
    }

    private ArtifactRepository parseRepository(String repo, ArtifactRepositoryPolicy policy) throws MojoFailureException {
        String id = "temp";
        ArtifactRepositoryLayout layout = this.getLayout("default");
        String url = repo;
        if (repo.contains("::")) {
            Matcher matcher = ALT_REPO_SYNTAX_PATTERN.matcher(repo);
            if (!matcher.matches()) {
                throw new MojoFailureException((Object)repo, "Invalid syntax for repository: " + repo, "Invalid syntax for repository. Use \"id::layout::url\" or \"URL\".");
            }
            id = matcher.group(1).trim();
            if (!StringUtils.isEmpty((String)matcher.group(2))) {
                layout = this.getLayout(matcher.group(2).trim());
            }
            url = matcher.group(3).trim();
        }
        return new MavenArtifactRepository(id, url, layout, policy, policy);
    }

    private ArtifactRepositoryLayout getLayout(String id) throws MojoFailureException {
        ArtifactRepositoryLayout layout = this.repositoryLayouts.get(id);
        if (layout == null) {
            throw new MojoFailureException((Object)id, "Invalid repository layout", "Invalid repository layout: " + id);
        }
        return layout;
    }
}

