/*
 * Decompiled with CFR 0.152.
 */
package org.kie.maven.plugin;

import java.io.File;
import java.io.IOException;
import java.net.URLClassLoader;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.appformer.maven.support.PomModel;
import org.drools.compiler.compiler.io.Folder;
import org.drools.compiler.compiler.io.memory.MemoryFile;
import org.drools.compiler.compiler.io.memory.MemoryFileSystem;
import org.drools.compiler.kie.builder.impl.BuildContext;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.drools.compiler.kie.builder.impl.KieBuilderImpl;
import org.drools.compiler.kie.builder.impl.KieModuleKieProject;
import org.drools.compiler.kie.builder.impl.MemoryKieModule;
import org.drools.modelcompiler.CanonicalKieModule;
import org.drools.modelcompiler.builder.CanonicalModelKieProject;
import org.drools.modelcompiler.builder.ModelBuilderImpl;
import org.drools.modelcompiler.builder.ModelSourceClass;
import org.drools.modelcompiler.builder.ModelWriter;
import org.kie.api.KieServices;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.ReleaseId;
import org.kie.maven.plugin.AbstractDMNValidationAwareMojo;
import org.kie.maven.plugin.ExecModelMode;
import org.kie.maven.plugin.GenerateCodeUtil;
import org.kie.maven.plugin.ProjectPomModel;
import org.kie.memorycompiler.JavaCompilerSettings;

@Mojo(name="generateModel", requiresDependencyResolution=ResolutionScope.NONE, requiresProject=true, defaultPhase=LifecyclePhase.COMPILE)
public class GenerateModelMojo
extends AbstractDMNValidationAwareMojo {
    public static PathMatcher drlFileMatcher = FileSystems.getDefault().getPathMatcher("glob:**.drl");
    @Parameter(defaultValue="${session}", required=true, readonly=true)
    private MavenSession mavenSession;
    @Parameter(required=true, defaultValue="${project.build.directory}")
    private File targetDirectory;
    @Parameter(required=true, defaultValue="${project.basedir}")
    private File projectDir;
    @Parameter(required=true, defaultValue="${project.build.testSourceDirectory}")
    private File testDir;
    @Parameter
    private Map<String, String> properties;
    @Parameter(required=true, defaultValue="${project}")
    private MavenProject project;
    @Parameter(required=true, defaultValue="${project.build.outputDirectory}")
    private File outputDirectory;

    public void execute() throws MojoExecutionException, MojoFailureException {
        boolean modelParameterEnabled = this.isModelParameterEnabled();
        boolean modelCompilerInClassPath = ExecModelMode.isModelCompilerInClassPath(this.project.getDependencies());
        if (modelParameterEnabled && modelCompilerInClassPath) {
            this.generateModel();
        } else if (modelParameterEnabled) {
            this.getLog().warn((CharSequence)"You're trying to build rule assets in a project from an executable rule model, but you did not provide the required dependency on the project classpath.\nTo enable executable rule models for your project, add the `drools-model-compiler` dependency in the `pom.xml` file of your project.\n");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateModel() throws MojoExecutionException, MojoFailureException {
        JavaCompilerSettings javaCompilerSettings = GenerateCodeUtil.createJavaCompilerSettings();
        URLClassLoader projectClassLoader = GenerateCodeUtil.getProjectClassLoader(this.project, this.outputDirectory, javaCompilerSettings);
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(projectClassLoader);
        try {
            this.setSystemProperties(this.properties);
            KieServices ks = KieServices.Factory.get();
            KieBuilderImpl kieBuilder = (KieBuilderImpl)ks.newKieBuilder(this.projectDir);
            kieBuilder.setPomModel((PomModel)new ProjectPomModel(this.mavenSession));
            kieBuilder.buildAll(ExecutableModelMavenProject.SUPPLIER, s -> !s.contains("src/test/java") && !s.contains("src\\test\\java"));
            InternalKieModule kieModule = (InternalKieModule)kieBuilder.getKieModule();
            List generatedFiles = kieModule.getFileNames().stream().filter(f -> f.endsWith("java")).collect(Collectors.toList());
            this.getLog().info((CharSequence)String.format("Found %d generated files in Canonical Model", generatedFiles.size()));
            MemoryFileSystem mfs = kieModule instanceof CanonicalKieModule ? ((MemoryKieModule)((CanonicalKieModule)kieModule).getInternalKieModule()).getMemoryFileSystem() : ((MemoryKieModule)kieModule).getMemoryFileSystem();
            HashMap<String, String> classNameSourceMap = new HashMap<String, String>();
            for (String generatedFile : generatedFiles) {
                MemoryFile f2 = (MemoryFile)mfs.getFile(generatedFile);
                String className = GenerateCodeUtil.toClassName(generatedFile);
                classNameSourceMap.put(className, new String(mfs.getFileContents(f2)));
                this.getLog().info((CharSequence)("Generating " + className));
            }
            GenerateCodeUtil.compileAndWriteClasses(this.targetDirectory, projectClassLoader, javaCompilerSettings, this.getCompilerType(), classNameSourceMap, this.dumpKieSourcesFolder);
            String path = CanonicalKieModule.getModelFileWithGAV((ReleaseId)kieModule.getReleaseId());
            MemoryFile packagesMemoryFile = (MemoryFile)mfs.getFile(path);
            String packagesMemoryFilePath = packagesMemoryFile.getFolder().getPath().toPortableString();
            Path packagesDestinationPath = Paths.get(this.targetDirectory.getPath(), "classes", packagesMemoryFilePath, packagesMemoryFile.getName());
            try {
                if (!Files.exists(packagesDestinationPath, new LinkOption[0])) {
                    Files.createDirectories(packagesDestinationPath.getParent(), new FileAttribute[0]);
                }
                Files.copy(packagesMemoryFile.getContents(), packagesDestinationPath, StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new MojoExecutionException("Unable to write file", (Exception)e);
            }
            if (this.shallPerformDMNDTAnalysis()) {
                this.performDMNDTAnalysis(kieModule);
            }
            if (ExecModelMode.shouldDeleteFile(this.getGenerateModelOption())) {
                Set<String> drlFiles = kieModule.getFileNames().stream().filter(f -> f.endsWith("drl")).collect(Collectors.toSet());
                this.deleteDrlFiles(drlFiles);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextClassLoader);
            if (projectClassLoader != null) {
                try {
                    projectClassLoader.close();
                }
                catch (IOException e) {
                    this.getLog().warn((Throwable)e);
                }
            }
        }
        this.getLog().info((CharSequence)"DSL successfully generated");
    }

    private void deleteDrlFiles(Set<String> actualDrlFiles) throws MojoExecutionException {
        try (Stream<Path> drlFilesToDeleted = Files.find(this.outputDirectory.toPath(), Integer.MAX_VALUE, (p, f) -> drlFileMatcher.matches((Path)p), new FileVisitOption[0]);){
            HashSet deletedFiles = new HashSet();
            drlFilesToDeleted.forEach(p -> {
                try {
                    Files.delete(p);
                    deletedFiles.add(p.toString());
                }
                catch (IOException e) {
                    e.printStackTrace();
                    throw new RuntimeException("Unable to delete file " + p);
                }
            });
            actualDrlFiles.retainAll(deletedFiles);
            if (!actualDrlFiles.isEmpty()) {
                String actualDrlFiles1 = String.join((CharSequence)",", actualDrlFiles);
                this.getLog().warn((CharSequence)("Base directory: " + this.projectDir));
                this.getLog().warn((CharSequence)("Files not deleted: " + actualDrlFiles1));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new MojoExecutionException("Unable to find .drl files");
        }
    }

    public static class ExecutableModelMavenProject
    implements KieBuilder.ProjectType {
        public static final BiFunction<InternalKieModule, ClassLoader, KieModuleKieProject> SUPPLIER = ExecutableModelMavenPluginKieProject::new;

        public static class ExecutableModelMavenPluginKieProject
        extends CanonicalModelKieProject {
            public ExecutableModelMavenPluginKieProject(InternalKieModule kieModule, ClassLoader classLoader) {
                super(kieModule, classLoader);
            }

            public void writeProjectOutput(MemoryFileSystem trgMfs, BuildContext buildContext) {
                MemoryFileSystem srcMfs = new MemoryFileSystem();
                Folder sourceFolder = srcMfs.getFolder("src/main/java");
                ArrayList modelFiles = new ArrayList();
                ModelWriter modelWriter = new ModelWriter();
                HashMap<String, List> modelsByKBase = new HashMap<String, List>();
                for (Map.Entry modelBuilder : this.modelBuilders.entrySet()) {
                    ModelWriter.Result result = modelWriter.writeModel(srcMfs, ((ModelBuilderImpl)modelBuilder.getValue()).getPackageSources());
                    modelFiles.addAll(result.getModelFiles());
                    modelsByKBase.put((String)modelBuilder.getKey(), result.getModelFiles());
                }
                InternalKieModule kieModule = this.getInternalKieModule();
                ModelSourceClass modelSourceClass = new ModelSourceClass(kieModule.getReleaseId(), kieModule.getKieModuleModel().getKieBaseModels(), modelsByKBase, this.hasDynamicClassLoader());
                String projectSourcePath = modelSourceClass.getName();
                srcMfs.write(projectSourcePath, modelSourceClass.generate().getBytes());
                Folder targetFolder = trgMfs.getFolder(".");
                srcMfs.copyFolder(sourceFolder, trgMfs, targetFolder, new String[0]);
                modelWriter.writeModelFile(modelFiles, trgMfs, this.getInternalKieModule().getReleaseId());
            }
        }
    }
}

