/*
 * Decompiled with CFR 0.152.
 */
package org.kie.maven.plugin.mojos;

import java.io.File;
import java.util.List;
import java.util.Map;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.kie.maven.plugin.KieMavenPluginContext;
import org.kie.maven.plugin.helpers.ExecModelModeHelper;
import org.kie.memorycompiler.JavaConfiguration;

public abstract class AbstractKieMojo
extends AbstractMojo {
    @Parameter(property="dumpKieSourcesFolder", defaultValue="")
    private String dumpKieSourcesFolder;
    @Parameter(property="generateModel", defaultValue="YES_WITHDRL")
    private String generateModel;
    @Parameter(property="generateDMNModel", defaultValue="no")
    private String generateDMNModel;
    @Parameter(required=true, defaultValue="${project.build.resources}")
    protected List<Resource> resources;
    @Parameter(property="validateDMN", defaultValue="VALIDATE_SCHEMA,VALIDATE_MODEL,ANALYZE_DECISION_TABLE")
    protected String validateDMN;
    @Parameter(required=true, defaultValue="${project.basedir}")
    private File projectDir;
    @Parameter(required=true, defaultValue="${project.build.directory}")
    private File targetDirectory;
    @Parameter
    private Map<String, String> properties;
    @Parameter(required=true, defaultValue="${project}")
    private MavenProject project;
    @Parameter(defaultValue="${session}", required=true, readonly=true)
    private MavenSession mavenSession;
    @Parameter(defaultValue="${project.resources}", required=true, readonly=true)
    private List<Resource> resourcesDirectories;
    @Parameter(required=true, defaultValue="${project.build.outputDirectory}")
    private File outputDirectory;
    @Parameter(required=true, defaultValue="${project.build.testSourceDirectory}")
    private File testDir;
    @Parameter(required=true, defaultValue="src/main/resources")
    private File resourceFolder;
    @Parameter(property="javaCompiler", defaultValue="ecj")
    private String javaCompiler;

    protected KieMavenPluginContext getKieMavenPluginContext() {
        return new KieMavenPluginContext(this.dumpKieSourcesFolder, this.generateModel, this.generateDMNModel, this.resources, this.validateDMN, this.projectDir, this.targetDirectory, this.properties, this.project, this.mavenSession, this.resourcesDirectories, this.outputDirectory, this.testDir, this.resourceFolder, this.isModelParameterEnabled(), this.getCompilerType(), this.getLog());
    }

    private boolean isModelParameterEnabled() {
        return ExecModelModeHelper.execModelParameterEnabled(this.generateModel);
    }

    private JavaConfiguration.CompilerType getCompilerType() {
        return this.javaCompiler.equalsIgnoreCase("native") ? JavaConfiguration.CompilerType.NATIVE : JavaConfiguration.CompilerType.ECLIPSE;
    }
}

