/*
 * Decompiled with CFR 0.152.
 */
package org.kie.maven.plugin.helpers;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.resolver.filter.CumulativeScopeArtifactFilter;
import org.apache.maven.project.MavenProject;
import org.kie.memorycompiler.JavaCompilerSettings;
import org.kie.memorycompiler.JavaConfiguration;
import org.kie.memorycompiler.KieMemoryCompiler;

public class GenerateCodeHelper {
    private GenerateCodeHelper() {
    }

    public static URLClassLoader getProjectClassLoader(MavenProject project, File outputDirectory, JavaCompilerSettings javaCompilerSettings) {
        try {
            File file;
            HashSet<URL> urls = new HashSet<URL>();
            for (String element : project.getCompileClasspathElements()) {
                file = new File(element);
                javaCompilerSettings.addClasspath(file);
                urls.add(file.toURI().toURL());
            }
            project.setArtifactFilter((ArtifactFilter)new CumulativeScopeArtifactFilter(Arrays.asList("compile", "runtime")));
            for (Artifact artifact : project.getArtifacts()) {
                file = artifact.getFile();
                if (file == null) continue;
                javaCompilerSettings.addClasspath(file);
                urls.add(file.toURI().toURL());
            }
            urls.add(outputDirectory.toURI().toURL());
            return URLClassLoader.newInstance(urls.toArray(new URL[0]), GenerateCodeHelper.class.getClassLoader());
        }
        catch (MalformedURLException | DependencyResolutionRequiredException e) {
            throw new RuntimeException(e);
        }
    }

    public static void compileAndWriteClasses(File targetDirectory, ClassLoader projectClassLoader, JavaCompilerSettings javaCompilerSettings, JavaConfiguration.CompilerType compilerType, Map<String, String> classNameSourceMap, String dumpKieSourcesFolder) {
        if (dumpKieSourcesFolder != null && !dumpKieSourcesFolder.isEmpty()) {
            GenerateCodeHelper.dumpGeneratedSources(targetDirectory, classNameSourceMap, dumpKieSourcesFolder);
        }
        Map compiledClassesMap = KieMemoryCompiler.compileNoLoad(classNameSourceMap, (ClassLoader)projectClassLoader, (JavaCompilerSettings)javaCompilerSettings, (JavaConfiguration.CompilerType)compilerType);
        GenerateCodeHelper.writeClasses(targetDirectory, compiledClassesMap);
    }

    public static void writeClasses(File targetDirectory, Map<String, byte[]> compiledClassesMap) {
        for (Map.Entry<String, byte[]> entry : compiledClassesMap.entrySet()) {
            Path packagesDestinationPath = Paths.get(targetDirectory.getPath(), "classes", entry.getKey().replace('.', '/') + ".class");
            GenerateCodeHelper.writeFile(packagesDestinationPath, entry.getValue());
        }
    }

    private static void dumpGeneratedSources(File targetDirectory, Map<String, String> classNameSourceMap, String dumpKieSourcesFolder) {
        for (Map.Entry<String, String> entry : classNameSourceMap.entrySet()) {
            Path sourceDestinationPath = Paths.get(targetDirectory.getPath(), dumpKieSourcesFolder, entry.getKey().replace('.', '/') + ".java");
            GenerateCodeHelper.writeFile(sourceDestinationPath, entry.getValue().getBytes(StandardCharsets.UTF_8));
        }
    }

    private static void writeFile(Path packagesDestinationPath, byte[] value) {
        try {
            if (!Files.exists(packagesDestinationPath, new LinkOption[0])) {
                Files.createDirectories(packagesDestinationPath.getParent(), new FileAttribute[0]);
            }
            Files.write(packagesDestinationPath, value, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static JavaCompilerSettings createJavaCompilerSettings() {
        JavaCompilerSettings javaCompilerSettings = new JavaCompilerSettings();
        String javaVersion = JavaConfiguration.findJavaVersion((String)System.getProperty("java.version"));
        javaCompilerSettings.setSourceVersion(javaVersion);
        javaCompilerSettings.setTargetVersion(javaVersion);
        return javaCompilerSettings;
    }

    public static String toClassName(String source) {
        if (source.startsWith("./") || source.startsWith(".\\")) {
            source = source.substring(2);
        }
        if (source.endsWith(".java")) {
            source = source.substring(0, source.length() - 5);
        }
        return source.replace('/', '.').replace('\\', '.');
    }
}

