/*
 * Decompiled with CFR 0.152.
 */
package org.kie.maven.plugin;

import java.io.File;
import java.util.List;
import java.util.Map;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.kie.maven.plugin.helpers.ExecModelModeHelper;
import org.kie.maven.plugin.mojos.AbstractKieMojo;
import org.kie.memorycompiler.JavaConfiguration;

public class KieMavenPluginContext {
    private final String dumpKieSourcesFolder;
    private final String generateModel;
    private final String generateDMNModel;
    private final List<Resource> resources;
    private final String validateDMN;
    private final File projectDir;
    private final File targetDirectory;
    private final Map<String, String> properties;
    private final MavenProject project;
    private final MavenSession mavenSession;
    private final List<Resource> resourcesDirectories;
    private final File outputDirectory;
    private final File testDir;
    private final File resourceFolder;
    private final boolean isModelParameterEnabled;
    private final boolean isModelCompilerInClass;
    private final JavaConfiguration.CompilerType compilerType;
    private final Log log;

    public static KieMavenPluginContext getKieMavenPluginContext(AbstractKieMojo abstractKieMojo) {
        return new KieMavenPluginContext(abstractKieMojo.getDumpKieSourcesFolder(), abstractKieMojo.getGenerateModel(), abstractKieMojo.getGenerateDMNModel(), abstractKieMojo.getResources(), abstractKieMojo.getValidateDMN(), abstractKieMojo.getProjectDir(), abstractKieMojo.getTargetDirectory(), abstractKieMojo.getProperties(), abstractKieMojo.getProject(), abstractKieMojo.getMavenSession(), abstractKieMojo.getResourcesDirectories(), abstractKieMojo.getOutputDirectory(), abstractKieMojo.getTestDir(), abstractKieMojo.getResourceFolder(), abstractKieMojo.isModelParameterEnabled(), abstractKieMojo.getCompilerType(), abstractKieMojo.getLog());
    }

    private KieMavenPluginContext(String dumpKieSourcesFolder, String generateModel, String generateDMNModel, List<Resource> resources, String validateDMN, File projectDir, File targetDirectory, Map<String, String> properties, MavenProject project, MavenSession mavenSession, List<Resource> resourcesDirectories, File outputDirectory, File testDir, File resourceFolder, boolean isModelParameterEnabled, JavaConfiguration.CompilerType compilerType, Log log) {
        this.dumpKieSourcesFolder = dumpKieSourcesFolder;
        this.generateModel = generateModel;
        this.generateDMNModel = generateDMNModel;
        this.resources = resources;
        this.validateDMN = validateDMN;
        this.projectDir = projectDir;
        this.targetDirectory = targetDirectory;
        this.properties = properties;
        this.project = project;
        this.mavenSession = mavenSession;
        this.resourcesDirectories = resourcesDirectories;
        this.outputDirectory = outputDirectory;
        this.testDir = testDir;
        this.resourceFolder = resourceFolder;
        this.isModelParameterEnabled = isModelParameterEnabled;
        this.isModelCompilerInClass = ExecModelModeHelper.isModelCompilerInClassPath(project.getDependencies());
        this.compilerType = compilerType;
        this.log = log;
    }

    public String getDumpKieSourcesFolder() {
        return this.dumpKieSourcesFolder;
    }

    public String getGenerateModel() {
        return this.generateModel;
    }

    public String getGenerateDMNModel() {
        return this.generateDMNModel;
    }

    public List<Resource> getResources() {
        return this.resources;
    }

    public String getValidateDMN() {
        return this.validateDMN;
    }

    public File getProjectDir() {
        return this.projectDir;
    }

    public File getTargetDirectory() {
        return this.targetDirectory;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public MavenProject getProject() {
        return this.project;
    }

    public MavenSession getMavenSession() {
        return this.mavenSession;
    }

    public List<Resource> getResourcesDirectories() {
        return this.resourcesDirectories;
    }

    public File getOutputDirectory() {
        return this.outputDirectory;
    }

    public File getTestDir() {
        return this.testDir;
    }

    public File getResourceFolder() {
        return this.resourceFolder;
    }

    public boolean isModelParameterEnabled() {
        return this.isModelParameterEnabled;
    }

    public boolean isModelCompilerInClass() {
        return this.isModelCompilerInClass;
    }

    public JavaConfiguration.CompilerType getCompilerType() {
        return this.compilerType;
    }

    public Log getLog() {
        return this.log;
    }
}

