/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.compiler.api.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.xml.namespace.QName;
import org.dmg.pmml.Array;
import org.dmg.pmml.DataDictionary;
import org.dmg.pmml.DataField;
import org.dmg.pmml.DataType;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.Field;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.MiningField;
import org.dmg.pmml.MiningSchema;
import org.dmg.pmml.Model;
import org.dmg.pmml.OpType;
import org.dmg.pmml.ParameterField;
import org.dmg.pmml.Row;
import org.dmg.pmml.Target;
import org.dmg.pmml.Targets;
import org.dmg.pmml.regression.RegressionModel;
import org.jpmml.model.inlinetable.InputCell;
import org.jpmml.model.inlinetable.OutputCell;
import org.junit.Assert;
import org.junit.Test;
import org.kie.pmml.api.enums.DATA_TYPE;
import org.kie.pmml.api.enums.FIELD_USAGE_TYPE;
import org.kie.pmml.api.enums.OP_TYPE;
import org.kie.pmml.api.enums.RESULT_FEATURE;
import org.kie.pmml.api.exceptions.KiePMMLInternalException;
import org.kie.pmml.api.models.MiningField;
import org.kie.pmml.api.models.OutputField;
import org.kie.pmml.compiler.api.CommonTestingUtils;
import org.kie.pmml.compiler.api.testutils.PMMLModelTestUtils;
import org.kie.pmml.compiler.api.utils.ModelUtils;

public class ModelUtilsTest {
    private static Map<String, String> expectedBoxedClassName = new HashMap<String, String>();

    @Test
    public void getTargetFieldName() {
        String fieldName = "fieldName";
        MiningField.UsageType usageType = MiningField.UsageType.ACTIVE;
        org.dmg.pmml.MiningField miningField = PMMLModelTestUtils.getMiningField("fieldName", usageType);
        DataField dataField = PMMLModelTestUtils.getDataField("fieldName", OpType.CATEGORICAL, DataType.STRING);
        DataDictionary dataDictionary = new DataDictionary();
        dataDictionary.addDataFields(new DataField[]{dataField});
        MiningSchema miningSchema = new MiningSchema();
        miningSchema.addMiningFields(new org.dmg.pmml.MiningField[]{miningField});
        RegressionModel model = new RegressionModel();
        model.setMiningSchema(miningSchema);
        List<Field<?>> fields = CommonTestingUtils.getFieldsFromDataDictionary(dataDictionary);
        Optional retrieved = ModelUtils.getTargetFieldName(fields, (Model)model);
        Assert.assertFalse((boolean)retrieved.isPresent());
        usageType = MiningField.UsageType.PREDICTED;
        miningField = PMMLModelTestUtils.getMiningField("fieldName", usageType);
        miningSchema = new MiningSchema();
        miningSchema.addMiningFields(new org.dmg.pmml.MiningField[]{miningField});
        model.setMiningSchema(miningSchema);
        retrieved = ModelUtils.getTargetFieldName(fields, (Model)model);
        Assert.assertTrue((boolean)retrieved.isPresent());
        Assert.assertEquals((Object)"fieldName", retrieved.get());
    }

    @Test
    public void getTargetFieldTypeWithTargetField() {
        String fieldName = "fieldName";
        MiningField.UsageType usageType = MiningField.UsageType.PREDICTED;
        org.dmg.pmml.MiningField miningField = PMMLModelTestUtils.getMiningField("fieldName", usageType);
        DataField dataField = PMMLModelTestUtils.getDataField("fieldName", OpType.CATEGORICAL, DataType.STRING);
        DataDictionary dataDictionary = new DataDictionary();
        dataDictionary.addDataFields(new DataField[]{dataField});
        MiningSchema miningSchema = new MiningSchema();
        miningSchema.addMiningFields(new org.dmg.pmml.MiningField[]{miningField});
        RegressionModel model = new RegressionModel();
        model.setMiningSchema(miningSchema);
        DATA_TYPE retrieved = ModelUtils.getTargetFieldType(CommonTestingUtils.getFieldsFromDataDictionary(dataDictionary), (Model)model);
        Assert.assertNotNull((Object)retrieved);
        Assert.assertEquals((Object)DATA_TYPE.STRING, (Object)retrieved);
    }

    @Test(expected=Exception.class)
    public void getTargetFieldTypeWithoutTargetField() {
        String fieldName = "fieldName";
        MiningField.UsageType usageType = MiningField.UsageType.ACTIVE;
        org.dmg.pmml.MiningField miningField = PMMLModelTestUtils.getMiningField("fieldName", usageType);
        DataField dataField = PMMLModelTestUtils.getDataField("fieldName", OpType.CATEGORICAL, DataType.STRING);
        DataDictionary dataDictionary = new DataDictionary();
        dataDictionary.addDataFields(new DataField[]{dataField});
        MiningSchema miningSchema = new MiningSchema();
        miningSchema.addMiningFields(new org.dmg.pmml.MiningField[]{miningField});
        RegressionModel model = new RegressionModel();
        model.setMiningSchema(miningSchema);
        ModelUtils.getTargetFieldType(CommonTestingUtils.getFieldsFromDataDictionary(dataDictionary), (Model)model);
    }

    @Test
    public void getTargetFieldsWithoutTargetFields() {
        RegressionModel model = new RegressionModel();
        DataDictionary dataDictionary = new DataDictionary();
        MiningSchema miningSchema = new MiningSchema();
        IntStream.range(0, 3).forEach(i -> {
            String fieldName = "fieldName-" + i;
            DataField dataField = PMMLModelTestUtils.getDataField(fieldName, OpType.CATEGORICAL, DataType.STRING);
            dataDictionary.addDataFields(new DataField[]{dataField});
            org.dmg.pmml.MiningField miningField = PMMLModelTestUtils.getMiningField(fieldName, MiningField.UsageType.ACTIVE);
            miningSchema.addMiningFields(new org.dmg.pmml.MiningField[]{miningField});
        });
        model.setMiningSchema(miningSchema);
        List retrieved = ModelUtils.getTargetFields(CommonTestingUtils.getFieldsFromDataDictionary(dataDictionary), (Model)model);
        Assert.assertNotNull((Object)retrieved);
        Assert.assertTrue((boolean)retrieved.isEmpty());
    }

    @Test
    public void getTargetFieldsWithTargetFieldsWithoutOptType() {
        RegressionModel model = new RegressionModel();
        DataDictionary dataDictionary = new DataDictionary();
        MiningSchema miningSchema = new MiningSchema();
        IntStream.range(0, 3).forEach(i -> {
            String fieldName = "fieldName-" + i;
            DataField dataField = PMMLModelTestUtils.getDataField(fieldName, OpType.CATEGORICAL, DataType.STRING);
            dataDictionary.addDataFields(new DataField[]{dataField});
            org.dmg.pmml.MiningField miningField = PMMLModelTestUtils.getMiningField(fieldName, MiningField.UsageType.PREDICTED);
            miningField.setOpType(null);
            miningSchema.addMiningFields(new org.dmg.pmml.MiningField[]{miningField});
        });
        model.setMiningSchema(miningSchema);
        List retrieved = ModelUtils.getTargetFields(CommonTestingUtils.getFieldsFromDataDictionary(dataDictionary), (Model)model);
        Assert.assertNotNull((Object)retrieved);
        Assert.assertEquals((long)miningSchema.getMiningFields().size(), (long)retrieved.size());
        retrieved.forEach(kiePMMLNameOpType -> {
            Assert.assertTrue((boolean)miningSchema.getMiningFields().stream().anyMatch(fld -> kiePMMLNameOpType.getName().equals(fld.getName().getValue())));
            Optional<DataField> optionalDataField = dataDictionary.getDataFields().stream().filter(fld -> kiePMMLNameOpType.getName().equals(fld.getName().getValue())).findFirst();
            Assert.assertTrue((boolean)optionalDataField.isPresent());
            DataField dataField = optionalDataField.get();
            OP_TYPE expected = OP_TYPE.byName((String)dataField.getOpType().value());
            Assert.assertEquals((Object)expected, (Object)kiePMMLNameOpType.getOpType());
        });
    }

    @Test
    public void getTargetFieldsWithTargetFieldsWithOptType() {
        RegressionModel model = new RegressionModel();
        DataDictionary dataDictionary = new DataDictionary();
        MiningSchema miningSchema = new MiningSchema();
        IntStream.range(0, 3).forEach(i -> {
            String fieldName = "fieldName-" + i;
            DataField dataField = PMMLModelTestUtils.getDataField(fieldName, OpType.CATEGORICAL, DataType.STRING);
            dataDictionary.addDataFields(new DataField[]{dataField});
            org.dmg.pmml.MiningField miningField = PMMLModelTestUtils.getMiningField(fieldName, MiningField.UsageType.PREDICTED);
            miningField.setOpType(OpType.CONTINUOUS);
            miningSchema.addMiningFields(new org.dmg.pmml.MiningField[]{miningField});
        });
        model.setMiningSchema(miningSchema);
        List retrieved = ModelUtils.getTargetFields(CommonTestingUtils.getFieldsFromDataDictionary(dataDictionary), (Model)model);
        Assert.assertNotNull((Object)retrieved);
        Assert.assertEquals((long)miningSchema.getMiningFields().size(), (long)retrieved.size());
        retrieved.forEach(kiePMMLNameOpType -> {
            Optional<org.dmg.pmml.MiningField> optionalMiningField = miningSchema.getMiningFields().stream().filter(fld -> kiePMMLNameOpType.getName().equals(fld.getName().getValue())).findFirst();
            Assert.assertTrue((boolean)optionalMiningField.isPresent());
            org.dmg.pmml.MiningField miningField = optionalMiningField.get();
            OP_TYPE expected = OP_TYPE.byName((String)miningField.getOpType().value());
            Assert.assertEquals((Object)expected, (Object)kiePMMLNameOpType.getOpType());
        });
    }

    @Test
    public void getTargetFieldsWithTargetFieldsWithTargetsWithoutOptType() {
        RegressionModel model = new RegressionModel();
        DataDictionary dataDictionary = new DataDictionary();
        MiningSchema miningSchema = new MiningSchema();
        Targets targets = new Targets();
        IntStream.range(0, 3).forEach(i -> {
            String fieldName = "fieldName-" + i;
            DataField dataField = PMMLModelTestUtils.getDataField(fieldName, OpType.CATEGORICAL, DataType.STRING);
            dataDictionary.addDataFields(new DataField[]{dataField});
            org.dmg.pmml.MiningField miningField = PMMLModelTestUtils.getMiningField(fieldName, MiningField.UsageType.PREDICTED);
            miningField.setOpType(OpType.CONTINUOUS);
            miningSchema.addMiningFields(new org.dmg.pmml.MiningField[]{miningField});
            Target targetField = PMMLModelTestUtils.getTarget(fieldName, null);
            targets.addTargets(new Target[]{targetField});
        });
        model.setMiningSchema(miningSchema);
        model.setTargets(targets);
        List retrieved = ModelUtils.getTargetFields(CommonTestingUtils.getFieldsFromDataDictionary(dataDictionary), (Model)model);
        Assert.assertNotNull((Object)retrieved);
        Assert.assertEquals((long)miningSchema.getMiningFields().size(), (long)retrieved.size());
        retrieved.forEach(kiePMMLNameOpType -> {
            Optional<org.dmg.pmml.MiningField> optionalMiningField = miningSchema.getMiningFields().stream().filter(fld -> kiePMMLNameOpType.getName().equals(fld.getName().getValue())).findFirst();
            Assert.assertTrue((boolean)optionalMiningField.isPresent());
            org.dmg.pmml.MiningField miningField = optionalMiningField.get();
            OP_TYPE expected = OP_TYPE.byName((String)miningField.getOpType().value());
            Assert.assertEquals((Object)expected, (Object)kiePMMLNameOpType.getOpType());
        });
    }

    @Test
    public void getTargetFieldsWithTargetFieldsWithTargetsWithOptType() {
        RegressionModel model = new RegressionModel();
        DataDictionary dataDictionary = new DataDictionary();
        MiningSchema miningSchema = new MiningSchema();
        Targets targets = new Targets();
        IntStream.range(0, 3).forEach(i -> {
            String fieldName = "fieldName-" + i;
            DataField dataField = PMMLModelTestUtils.getDataField(fieldName, OpType.CATEGORICAL, DataType.STRING);
            dataDictionary.addDataFields(new DataField[]{dataField});
            org.dmg.pmml.MiningField miningField = PMMLModelTestUtils.getMiningField(fieldName, MiningField.UsageType.PREDICTED);
            miningField.setOpType(OpType.CONTINUOUS);
            miningSchema.addMiningFields(new org.dmg.pmml.MiningField[]{miningField});
            Target targetField = PMMLModelTestUtils.getTarget(fieldName, OpType.CATEGORICAL);
            targets.addTargets(new Target[]{targetField});
        });
        model.setMiningSchema(miningSchema);
        model.setTargets(targets);
        List retrieved = ModelUtils.getTargetFields(CommonTestingUtils.getFieldsFromDataDictionary(dataDictionary), (Model)model);
        Assert.assertNotNull((Object)retrieved);
        Assert.assertEquals((long)miningSchema.getMiningFields().size(), (long)retrieved.size());
        retrieved.forEach(kiePMMLNameOpType -> {
            Optional<Target> optionalTarget = targets.getTargets().stream().filter(fld -> kiePMMLNameOpType.getName().equals(fld.getField().getValue())).findFirst();
            Assert.assertTrue((boolean)optionalTarget.isPresent());
            Target target = optionalTarget.get();
            OP_TYPE expected = OP_TYPE.byName((String)target.getOpType().value());
            Assert.assertEquals((Object)expected, (Object)kiePMMLNameOpType.getOpType());
        });
    }

    @Test
    public void getTargetFieldsTypeMapWithTargetFieldsWithoutTargets() {
        RegressionModel model = new RegressionModel();
        DataDictionary dataDictionary = new DataDictionary();
        MiningSchema miningSchema = new MiningSchema();
        IntStream.range(0, 3).forEach(i -> {
            DataField dataField = PMMLModelTestUtils.getRandomDataField();
            dataDictionary.addDataFields(new DataField[]{dataField});
            org.dmg.pmml.MiningField miningField = PMMLModelTestUtils.getMiningField(dataField.getName().getValue(), MiningField.UsageType.PREDICTED);
            miningSchema.addMiningFields(new org.dmg.pmml.MiningField[]{miningField});
        });
        model.setMiningSchema(miningSchema);
        Map retrieved = ModelUtils.getTargetFieldsTypeMap(CommonTestingUtils.getFieldsFromDataDictionary(dataDictionary), (Model)model);
        Assert.assertNotNull((Object)retrieved);
        Assert.assertEquals((long)miningSchema.getMiningFields().size(), (long)retrieved.size());
        Assert.assertTrue((boolean)(retrieved instanceof LinkedHashMap));
        Iterator iterator = retrieved.entrySet().iterator();
        for (int i2 = 0; i2 < miningSchema.getMiningFields().size(); ++i2) {
            org.dmg.pmml.MiningField miningField = (org.dmg.pmml.MiningField)miningSchema.getMiningFields().get(i2);
            DataField dataField = dataDictionary.getDataFields().stream().filter(df -> df.getName().equals((Object)miningField.getName())).findFirst().get();
            DATA_TYPE expected = DATA_TYPE.byName((String)dataField.getDataType().value());
            Map.Entry next = iterator.next();
            Assert.assertEquals((Object)expected, next.getValue());
        }
    }

    @Test
    public void getTargetFieldsTypeMapWithoutTargetFieldsWithoutTargets() {
        RegressionModel model = new RegressionModel();
        DataDictionary dataDictionary = new DataDictionary();
        MiningSchema miningSchema = new MiningSchema();
        IntStream.range(0, 3).forEach(i -> {
            DataField dataField = PMMLModelTestUtils.getRandomDataField();
            dataDictionary.addDataFields(new DataField[]{dataField});
            org.dmg.pmml.MiningField miningField = PMMLModelTestUtils.getMiningField(dataField.getName().getValue(), MiningField.UsageType.ACTIVE);
            miningSchema.addMiningFields(new org.dmg.pmml.MiningField[]{miningField});
        });
        model.setMiningSchema(miningSchema);
        Map retrieved = ModelUtils.getTargetFieldsTypeMap(CommonTestingUtils.getFieldsFromDataDictionary(dataDictionary), (Model)model);
        Assert.assertNotNull((Object)retrieved);
        Assert.assertTrue((boolean)retrieved.isEmpty());
    }

    @Test
    public void getTargetFieldsWithoutTargetFieldsWithTargets() {
        RegressionModel model = new RegressionModel();
        DataDictionary dataDictionary = new DataDictionary();
        MiningSchema miningSchema = new MiningSchema();
        Targets targets = new Targets();
        IntStream.range(0, 3).forEach(i -> {
            DataField dataField = PMMLModelTestUtils.getRandomDataField();
            dataDictionary.addDataFields(new DataField[]{dataField});
            org.dmg.pmml.MiningField miningField = PMMLModelTestUtils.getMiningField(dataField.getName().getValue(), MiningField.UsageType.ACTIVE);
            miningSchema.addMiningFields(new org.dmg.pmml.MiningField[]{miningField});
            Target targetField = PMMLModelTestUtils.getTarget(dataField.getName().getValue(), null);
            targets.addTargets(new Target[]{targetField});
        });
        model.setMiningSchema(miningSchema);
        model.setTargets(targets);
        Map retrieved = ModelUtils.getTargetFieldsTypeMap(CommonTestingUtils.getFieldsFromDataDictionary(dataDictionary), (Model)model);
        Assert.assertNotNull((Object)retrieved);
        Assert.assertTrue((boolean)retrieved.isEmpty());
    }

    @Test
    public void getOpTypeByDataFields() {
        RegressionModel model = new RegressionModel();
        DataDictionary dataDictionary = new DataDictionary();
        MiningSchema miningSchema = new MiningSchema();
        IntStream.range(0, 3).forEach(i -> {
            DataField dataField = PMMLModelTestUtils.getRandomDataField();
            dataDictionary.addDataFields(new DataField[]{dataField});
        });
        model.setMiningSchema(miningSchema);
        dataDictionary.getDataFields().forEach(arg_0 -> ModelUtilsTest.lambda$getOpTypeByDataFields$19(dataDictionary, (Model)model, arg_0));
    }

    @Test(expected=KiePMMLInternalException.class)
    public void getOpTypeByDataFieldsNotFound() {
        RegressionModel model = new RegressionModel();
        DataDictionary dataDictionary = new DataDictionary();
        IntStream.range(0, 3).forEach(i -> {
            String fieldName = "field" + i;
            DataField dataField = PMMLModelTestUtils.getRandomDataField();
            dataField.setName(FieldName.create((String)fieldName));
            dataDictionary.addDataFields(new DataField[]{dataField});
        });
        ModelUtils.getOpType(CommonTestingUtils.getFieldsFromDataDictionary(dataDictionary), (Model)model, (String)"NOT_EXISTING");
    }

    @Test
    public void getOpTypeByMiningFields() {
        RegressionModel model = new RegressionModel();
        DataDictionary dataDictionary = new DataDictionary();
        MiningSchema miningSchema = new MiningSchema();
        IntStream.range(0, 3).forEach(i -> {
            DataField dataField = PMMLModelTestUtils.getRandomDataField();
            dataDictionary.addDataFields(new DataField[]{dataField});
            org.dmg.pmml.MiningField miningField = PMMLModelTestUtils.getRandomMiningField();
            miningField.setName(dataField.getName());
            miningSchema.addMiningFields(new org.dmg.pmml.MiningField[]{miningField});
        });
        model.setMiningSchema(miningSchema);
        miningSchema.getMiningFields().forEach(arg_0 -> ModelUtilsTest.lambda$getOpTypeByMiningFields$22(dataDictionary, (Model)model, arg_0));
    }

    @Test(expected=KiePMMLInternalException.class)
    public void getOpTypeByMiningFieldsNotFound() {
        RegressionModel model = new RegressionModel();
        DataDictionary dataDictionary = new DataDictionary();
        MiningSchema miningSchema = new MiningSchema();
        IntStream.range(0, 3).forEach(i -> {
            String fieldName = "field" + i;
            DataField dataField = PMMLModelTestUtils.getRandomDataField();
            dataField.setName(FieldName.create((String)fieldName));
            dataDictionary.addDataFields(new DataField[]{dataField});
            org.dmg.pmml.MiningField miningField = PMMLModelTestUtils.getRandomMiningField();
            miningField.setName(dataField.getName());
            miningSchema.addMiningFields(new org.dmg.pmml.MiningField[]{miningField});
        });
        model.setMiningSchema(miningSchema);
        ModelUtils.getOpType(CommonTestingUtils.getFieldsFromDataDictionary(dataDictionary), (Model)model, (String)"NOT_EXISTING");
    }

    @Test
    public void getOpTypeByTargets() {
        RegressionModel model = new RegressionModel();
        DataDictionary dataDictionary = new DataDictionary();
        MiningSchema miningSchema = new MiningSchema();
        Targets targets = new Targets();
        IntStream.range(0, 3).forEach(i -> {
            DataField dataField = PMMLModelTestUtils.getRandomDataField();
            dataDictionary.addDataFields(new DataField[]{dataField});
            org.dmg.pmml.MiningField miningField = PMMLModelTestUtils.getRandomMiningField();
            miningField.setName(dataField.getName());
            miningSchema.addMiningFields(new org.dmg.pmml.MiningField[]{miningField});
            Target targetField = PMMLModelTestUtils.getRandomTarget();
            targetField.setField(dataField.getName());
            targets.addTargets(new Target[]{targetField});
        });
        model.setMiningSchema(miningSchema);
        model.setTargets(targets);
        CommonTestingUtils.getFieldsFromDataDictionary(dataDictionary);
        targets.getTargets().forEach(arg_0 -> ModelUtilsTest.lambda$getOpTypeByTargets$25(dataDictionary, (Model)model, arg_0));
    }

    @Test(expected=KiePMMLInternalException.class)
    public void getOpTypeByTargetsNotFound() {
        RegressionModel model = new RegressionModel();
        DataDictionary dataDictionary = new DataDictionary();
        MiningSchema miningSchema = new MiningSchema();
        Targets targets = new Targets();
        IntStream.range(0, 3).forEach(i -> {
            String fieldName = "field" + i;
            DataField dataField = PMMLModelTestUtils.getRandomDataField();
            dataField.setName(FieldName.create((String)fieldName));
            dataDictionary.addDataFields(new DataField[]{dataField});
            org.dmg.pmml.MiningField miningField = PMMLModelTestUtils.getRandomMiningField();
            miningField.setName(dataField.getName());
            miningSchema.addMiningFields(new org.dmg.pmml.MiningField[]{miningField});
            Target targetField = PMMLModelTestUtils.getRandomTarget();
            targetField.setField(dataField.getName());
            targets.addTargets(new Target[]{targetField});
        });
        model.setMiningSchema(miningSchema);
        model.setTargets(targets);
        ModelUtils.getOpType(CommonTestingUtils.getFieldsFromDataDictionary(dataDictionary), (Model)model, (String)"NOT_EXISTING");
    }

    @Test
    public void getOpTypeFromFields() {
        Optional opType = ModelUtils.getOpTypeFromFields(null, (String)"vsd");
        Assert.assertNotNull((Object)opType);
        Assert.assertFalse((boolean)opType.isPresent());
        DataDictionary dataDictionary = new DataDictionary();
        List<Field<?>> fields = CommonTestingUtils.getFieldsFromDataDictionary(dataDictionary);
        opType = ModelUtils.getOpTypeFromFields(fields, (String)"vsd");
        Assert.assertNotNull((Object)opType);
        Assert.assertFalse((boolean)opType.isPresent());
        IntStream.range(0, 3).forEach(i -> {
            DataField dataField = PMMLModelTestUtils.getRandomDataField();
            dataDictionary.addDataFields(new DataField[]{dataField});
        });
        fields.clear();
        fields.addAll(CommonTestingUtils.getFieldsFromDataDictionary(dataDictionary));
        dataDictionary.getDataFields().forEach(dataField -> {
            Optional retrieved = ModelUtils.getOpTypeFromFields((List)fields, (String)dataField.getName().getValue());
            Assert.assertNotNull((Object)retrieved);
            Assert.assertTrue((boolean)retrieved.isPresent());
            OP_TYPE expected = OP_TYPE.byName((String)dataField.getOpType().value());
            Assert.assertEquals((Object)expected, retrieved.get());
        });
    }

    @Test
    public void getOpTypeFromMiningFields() {
        Optional opType = ModelUtils.getOpTypeFromMiningFields(null, (String)"vsd");
        Assert.assertNotNull((Object)opType);
        Assert.assertFalse((boolean)opType.isPresent());
        MiningSchema miningSchema = new MiningSchema();
        opType = ModelUtils.getOpTypeFromMiningFields((MiningSchema)miningSchema, (String)"vsd");
        Assert.assertNotNull((Object)opType);
        Assert.assertFalse((boolean)opType.isPresent());
        IntStream.range(0, 3).forEach(i -> {
            org.dmg.pmml.MiningField miningField = PMMLModelTestUtils.getRandomMiningField();
            miningSchema.addMiningFields(new org.dmg.pmml.MiningField[]{miningField});
        });
        miningSchema.getMiningFields().forEach(miningField -> {
            Optional retrieved = ModelUtils.getOpTypeFromMiningFields((MiningSchema)miningSchema, (String)miningField.getName().getValue());
            Assert.assertNotNull((Object)retrieved);
            Assert.assertTrue((boolean)retrieved.isPresent());
            OP_TYPE expected = OP_TYPE.byName((String)miningField.getOpType().value());
            Assert.assertEquals((Object)expected, retrieved.get());
        });
    }

    @Test
    public void getOpTypeFromTargets() {
        Optional opType = ModelUtils.getOpTypeFromTargets(null, (String)"vsd");
        Assert.assertNotNull((Object)opType);
        Assert.assertFalse((boolean)opType.isPresent());
        Targets targets = new Targets();
        opType = ModelUtils.getOpTypeFromTargets((Targets)targets, (String)"vsd");
        Assert.assertNotNull((Object)opType);
        Assert.assertFalse((boolean)opType.isPresent());
        IntStream.range(0, 3).forEach(i -> {
            Target target = PMMLModelTestUtils.getRandomTarget();
            targets.addTargets(new Target[]{target});
        });
        targets.getTargets().forEach(target -> {
            Optional retrieved = ModelUtils.getOpTypeFromTargets((Targets)targets, (String)target.getField().getValue());
            Assert.assertNotNull((Object)retrieved);
            Assert.assertTrue((boolean)retrieved.isPresent());
            OP_TYPE expected = OP_TYPE.byName((String)target.getOpType().value());
            Assert.assertEquals((Object)expected, retrieved.get());
        });
    }

    @Test
    public void getDataTypeFromDerivedFieldsAndDataDictionary() {
        DataDictionary dataDictionary = new DataDictionary();
        IntStream.range(0, 3).forEach(i -> {
            DataField dataField = PMMLModelTestUtils.getRandomDataField();
            dataDictionary.addDataFields(new DataField[]{dataField});
        });
        List<DerivedField> derivedFields = dataDictionary.getDataFields().stream().map(dataField -> {
            DerivedField toReturn = new DerivedField();
            toReturn.setName(FieldName.create((String)("DER_" + dataField.getName().getValue())));
            DataType dataType = PMMLModelTestUtils.getRandomDataType();
            while (dataType.equals((Object)dataField.getDataType())) {
                dataType = PMMLModelTestUtils.getRandomDataType();
            }
            toReturn.setDataType(dataType);
            return toReturn;
        }).collect(Collectors.toList());
        ArrayList fields = new ArrayList();
        dataDictionary.getDataFields().stream().map(Field.class::cast).forEach(fields::add);
        derivedFields.stream().map(Field.class::cast).forEach(fields::add);
        dataDictionary.getDataFields().forEach(dataField -> {
            String fieldName = dataField.getName().getValue();
            DataType retrieved = ModelUtils.getDataType((List)fields, (String)fieldName);
            Assert.assertNotNull((Object)retrieved);
            DataType expected = dataField.getDataType();
            Assert.assertEquals((Object)expected, (Object)retrieved);
        });
        derivedFields.forEach(derivedField -> {
            String fieldName = derivedField.getName().getValue();
            DataType retrieved = ModelUtils.getDataType((List)fields, (String)fieldName);
            Assert.assertNotNull((Object)retrieved);
            DataType expected = derivedField.getDataType();
            Assert.assertEquals((Object)expected, (Object)retrieved);
        });
    }

    @Test
    public void getDataTypeFromDataDictionary() {
        DataDictionary dataDictionary = new DataDictionary();
        IntStream.range(0, 3).forEach(i -> {
            DataField dataField = PMMLModelTestUtils.getRandomDataField();
            dataDictionary.addDataFields(new DataField[]{dataField});
        });
        dataDictionary.getDataFields().forEach(dataField -> {
            DATA_TYPE retrieved = ModelUtils.getDATA_TYPE(CommonTestingUtils.getFieldsFromDataDictionary(dataDictionary), (String)dataField.getName().getValue());
            Assert.assertNotNull((Object)retrieved);
            DATA_TYPE expected = DATA_TYPE.byName((String)dataField.getDataType().value());
            Assert.assertEquals((Object)expected, (Object)retrieved);
        });
    }

    @Test(expected=KiePMMLInternalException.class)
    public void getDataTypeNotFound() {
        DataDictionary dataDictionary = new DataDictionary();
        IntStream.range(0, 3).forEach(i -> {
            String fieldName = "field" + i;
            DataField dataField = PMMLModelTestUtils.getRandomDataField();
            dataField.setName(FieldName.create((String)fieldName));
            dataDictionary.addDataFields(new DataField[]{dataField});
        });
        ModelUtils.getDATA_TYPE(CommonTestingUtils.getFieldsFromDataDictionary(dataDictionary), (String)"NOT_EXISTING");
    }

    @Test
    public void getObjectsFromArray() {
        Number expected;
        Object obj;
        int i;
        List<String> values = Arrays.asList("32", "11", "43");
        Array array = PMMLModelTestUtils.getArray(Array.Type.INT, values);
        List retrieved = ModelUtils.getObjectsFromArray((Array)array);
        Assert.assertEquals((long)values.size(), (long)retrieved.size());
        for (i = 0; i < values.size(); ++i) {
            obj = retrieved.get(i);
            Assert.assertTrue((boolean)(obj instanceof Integer));
            expected = Integer.valueOf(values.get(i));
            Assert.assertEquals((Object)expected, obj);
        }
        values = Arrays.asList("just", "11", "fun");
        array = PMMLModelTestUtils.getArray(Array.Type.STRING, values);
        retrieved = ModelUtils.getObjectsFromArray((Array)array);
        Assert.assertEquals((long)values.size(), (long)retrieved.size());
        for (i = 0; i < values.size(); ++i) {
            obj = retrieved.get(i);
            Assert.assertTrue((boolean)(obj instanceof String));
            Assert.assertEquals((Object)values.get(i), obj);
        }
        values = Arrays.asList("23.11", "11", "123.123");
        array = PMMLModelTestUtils.getArray(Array.Type.REAL, values);
        retrieved = ModelUtils.getObjectsFromArray((Array)array);
        Assert.assertEquals((long)values.size(), (long)retrieved.size());
        for (i = 0; i < values.size(); ++i) {
            obj = retrieved.get(i);
            Assert.assertTrue((boolean)(obj instanceof Double));
            expected = Double.valueOf(values.get(i));
            Assert.assertEquals((Object)expected, obj);
        }
    }

    @Test
    public void convertToKieMiningField() {
        String fieldName = "fieldName";
        MiningField.UsageType usageType = MiningField.UsageType.ACTIVE;
        org.dmg.pmml.MiningField toConvert = PMMLModelTestUtils.getMiningField("fieldName", usageType);
        toConvert.setOpType(null);
        DataField dataField = PMMLModelTestUtils.getDataField("fieldName", OpType.CATEGORICAL, DataType.STRING);
        MiningField retrieved = ModelUtils.convertToKieMiningField((org.dmg.pmml.MiningField)toConvert, (Field)dataField);
        Assert.assertNotNull((Object)retrieved);
        Assert.assertEquals((Object)"fieldName", (Object)retrieved.getName());
        Assert.assertEquals((Object)FIELD_USAGE_TYPE.ACTIVE, (Object)retrieved.getUsageType());
        Assert.assertEquals((Object)DATA_TYPE.STRING, (Object)retrieved.getDataType());
        Assert.assertNull((Object)retrieved.getOpType());
        toConvert.setOpType(OpType.CATEGORICAL);
        retrieved = ModelUtils.convertToKieMiningField((org.dmg.pmml.MiningField)toConvert, (Field)dataField);
        Assert.assertEquals((Object)OP_TYPE.CATEGORICAL, (Object)retrieved.getOpType());
    }

    @Test
    public void convertToKieOutputField() {
        org.dmg.pmml.OutputField toConvert = PMMLModelTestUtils.getRandomOutputField();
        OutputField retrieved = ModelUtils.convertToKieOutputField((org.dmg.pmml.OutputField)toConvert, null);
        Assert.assertNotNull((Object)retrieved);
        Assert.assertEquals((Object)toConvert.getName().getValue(), (Object)retrieved.getName());
        OP_TYPE expectedOpType = OP_TYPE.byName((String)toConvert.getOpType().value());
        Assert.assertEquals((Object)expectedOpType, (Object)retrieved.getOpType());
        DATA_TYPE expectedDataType = DATA_TYPE.byName((String)toConvert.getDataType().value());
        Assert.assertEquals((Object)expectedDataType, (Object)retrieved.getDataType());
        Assert.assertEquals((Object)toConvert.getTargetField().getValue(), (Object)retrieved.getTargetField());
        RESULT_FEATURE expectedResultFeature = RESULT_FEATURE.byName((String)toConvert.getResultFeature().value());
        Assert.assertEquals((Object)expectedResultFeature, (Object)retrieved.getResultFeature());
        toConvert.setOpType(null);
        toConvert.setTargetField(null);
        retrieved = ModelUtils.convertToKieOutputField((org.dmg.pmml.OutputField)toConvert, null);
        Assert.assertNull((Object)retrieved.getOpType());
        Assert.assertNull((Object)retrieved.getTargetField());
    }

    @Test
    public void getBoxedClassNameByParameterFields() {
        List<ParameterField> parameterFields = PMMLModelTestUtils.getParameterFields();
        parameterFields.forEach(parameterField -> {
            String retrieved = ModelUtils.getBoxedClassName((ParameterField)parameterField);
            this.commonVerifyEventuallyBoxedClassName(retrieved, parameterField.getDataType());
        });
    }

    @Test
    public void getBoxedClassNameByDataTypes() {
        List<DataType> dataTypes = PMMLModelTestUtils.getDataTypes();
        dataTypes.forEach(dataType -> {
            String retrieved = ModelUtils.getBoxedClassName((DataType)dataType);
            this.commonVerifyEventuallyBoxedClassName(retrieved, (DataType)dataType);
        });
    }

    @Test
    public void getRowDataMap() {
        Row source = PMMLModelTestUtils.getRandomRowWithCells();
        Map retrieved = ModelUtils.getRowDataMap((Row)source);
        InputCell inputCell = source.getContent().stream().filter(InputCell.class::isInstance).map(InputCell.class::cast).findFirst().get();
        OutputCell outputCell = source.getContent().stream().filter(OutputCell.class::isInstance).map(OutputCell.class::cast).findFirst().get();
        Assert.assertEquals((long)2L, (long)retrieved.size());
        String expected = ModelUtils.getPrefixedName((QName)inputCell.getName());
        Assert.assertTrue((boolean)retrieved.containsKey(expected));
        Assert.assertEquals((Object)inputCell.getValue(), retrieved.get(expected));
        expected = ModelUtils.getPrefixedName((QName)outputCell.getName());
        Assert.assertTrue((boolean)retrieved.containsKey(expected));
        Assert.assertEquals((Object)outputCell.getValue(), retrieved.get(expected));
    }

    private void commonVerifyEventuallyBoxedClassName(String toVerify, DataType dataType) {
        Assert.assertEquals((Object)expectedBoxedClassName.get(dataType.value()), (Object)toVerify);
    }

    private static /* synthetic */ void lambda$getOpTypeByTargets$25(DataDictionary dataDictionary, Model model, Target target) {
        OP_TYPE retrieved = ModelUtils.getOpType(CommonTestingUtils.getFieldsFromDataDictionary(dataDictionary), (Model)model, (String)target.getField().getValue());
        Assert.assertNotNull((Object)retrieved);
        OP_TYPE expected = OP_TYPE.byName((String)target.getOpType().value());
        Assert.assertEquals((Object)expected, (Object)retrieved);
    }

    private static /* synthetic */ void lambda$getOpTypeByMiningFields$22(DataDictionary dataDictionary, Model model, org.dmg.pmml.MiningField miningField) {
        OP_TYPE retrieved = ModelUtils.getOpType(CommonTestingUtils.getFieldsFromDataDictionary(dataDictionary), (Model)model, (String)miningField.getName().getValue());
        Assert.assertNotNull((Object)retrieved);
        OP_TYPE expected = OP_TYPE.byName((String)miningField.getOpType().value());
        Assert.assertEquals((Object)expected, (Object)retrieved);
    }

    private static /* synthetic */ void lambda$getOpTypeByDataFields$19(DataDictionary dataDictionary, Model model, DataField dataField) {
        OP_TYPE retrieved = ModelUtils.getOpType(CommonTestingUtils.getFieldsFromDataDictionary(dataDictionary), (Model)model, (String)dataField.getName().getValue());
        Assert.assertNotNull((Object)retrieved);
        OP_TYPE expected = OP_TYPE.byName((String)dataField.getOpType().value());
        Assert.assertEquals((Object)expected, (Object)retrieved);
    }

    static {
        expectedBoxedClassName.put("string", String.class.getName());
        expectedBoxedClassName.put("integer", Integer.class.getName());
        expectedBoxedClassName.put("float", Float.class.getName());
        expectedBoxedClassName.put("double", Double.class.getName());
        expectedBoxedClassName.put("boolean", Boolean.class.getName());
        expectedBoxedClassName.put("date", Date.class.getName());
        expectedBoxedClassName.put("time", Date.class.getName());
        expectedBoxedClassName.put("dateTime", Date.class.getName());
        expectedBoxedClassName.put("dateDaysSince[0]", Long.class.getName());
        expectedBoxedClassName.put("dateDaysSince[1960]", Long.class.getName());
        expectedBoxedClassName.put("dateDaysSince[1970]", Long.class.getName());
        expectedBoxedClassName.put("dateDaysSince[1980]", Long.class.getName());
        expectedBoxedClassName.put("timeSeconds", Long.class.getName());
        expectedBoxedClassName.put("dateTimeSecondsSince[0]", Long.class.getName());
        expectedBoxedClassName.put("dateTimeSecondsSince[1960]", Long.class.getName());
        expectedBoxedClassName.put("dateTimeSecondsSince[1970]", Long.class.getName());
        expectedBoxedClassName.put("dateTimeSecondsSince[1980]", Long.class.getName());
    }
}

