/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.compiler.api.provider;

import java.util.Map;
import org.dmg.pmml.Model;
import org.kie.pmml.api.enums.PMML_MODEL;
import org.kie.pmml.api.exceptions.KiePMMLException;
import org.kie.pmml.commons.model.IsInterpreted;
import org.kie.pmml.commons.model.KiePMMLModel;
import org.kie.pmml.commons.model.KiePMMLModelWithSources;
import org.kie.pmml.compiler.api.dto.CompilationDTO;

public interface ModelImplementationProvider<T extends Model, E extends KiePMMLModel> {
    public PMML_MODEL getPMMLModelType();

    public Class<E> getKiePMMLModelClass();

    default public KiePMMLModelWithSources getKiePMMLModelWithSources(CompilationDTO<T> compilationDTO) {
        Map<String, String> sourcesMap = this.getSourcesMap(compilationDTO);
        boolean isInterpreted = IsInterpreted.class.isAssignableFrom(this.getKiePMMLModelClass());
        return new KiePMMLModelWithSources(compilationDTO.getFileName(), compilationDTO.getModelName(), compilationDTO.getPackageName(), compilationDTO.getKieMiningFields(), compilationDTO.getKieOutputFields(), compilationDTO.getKieTargetFields(), sourcesMap, isInterpreted);
    }

    public Map<String, String> getSourcesMap(CompilationDTO<T> var1);

    default public KiePMMLModelWithSources getKiePMMLModelWithSourcesCompiled(CompilationDTO<T> compilationDTO) {
        KiePMMLModelWithSources toReturn = this.getKiePMMLModelWithSources(compilationDTO);
        Map sourcesMap = toReturn.getSourcesMap();
        try {
            compilationDTO.compileClasses(sourcesMap);
        }
        catch (Exception e) {
            throw new KiePMMLException((Throwable)e);
        }
        return toReturn;
    }
}

