/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.models.clustering.model;

import java.util.ArrayList;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.assertj.core.data.Offset;
import org.junit.Test;
import org.kie.pmml.api.utils.EnumUtils;
import org.kie.pmml.models.clustering.model.KiePMMLAggregateFunction;
import org.kie.pmml.models.clustering.model.KiePMMLClusteringField;
import org.kie.pmml.models.clustering.model.KiePMMLCompareFunction;

public class KiePMMLAggregateFunctionTest {
    private static final Offset<Double> DOUBLE_OFFSET = Offset.offset((Number)1.0E-9);
    private static final List<KiePMMLClusteringField> TEST_FIELDS = new ArrayList<KiePMMLClusteringField>(2);
    private static final KiePMMLCompareFunction TEST_COMPARE_FN = KiePMMLCompareFunction.ABS_DIFF;
    private static final Double[] TEST_INPUTS = new Double[2];
    private static final double[] TEST_SEEDS = new double[2];
    private static final double TEST_ADJUST = 1.0;

    @Test
    public void testNames() {
        Assertions.assertThat((Comparable)((KiePMMLAggregateFunction)EnumUtils.enumByName(KiePMMLAggregateFunction.class, (String)"euclidean"))).isEqualTo((Object)KiePMMLAggregateFunction.EUCLIDEAN);
        Assertions.assertThat((Comparable)((KiePMMLAggregateFunction)EnumUtils.enumByName(KiePMMLAggregateFunction.class, (String)"squaredEuclidean"))).isEqualTo((Object)KiePMMLAggregateFunction.SQUARED_EUCLIDEAN);
        Assertions.assertThat((Comparable)((KiePMMLAggregateFunction)EnumUtils.enumByName(KiePMMLAggregateFunction.class, (String)"chebychev"))).isEqualTo((Object)KiePMMLAggregateFunction.CHEBYCHEV);
        Assertions.assertThat((Comparable)((KiePMMLAggregateFunction)EnumUtils.enumByName(KiePMMLAggregateFunction.class, (String)"cityBlock"))).isEqualTo((Object)KiePMMLAggregateFunction.CITY_BLOCK);
        Assertions.assertThat((Comparable)((KiePMMLAggregateFunction)EnumUtils.enumByName(KiePMMLAggregateFunction.class, (String)"minkowski"))).isEqualTo((Object)KiePMMLAggregateFunction.MINKOWSKI);
        Assertions.assertThat((Comparable)((KiePMMLAggregateFunction)EnumUtils.enumByName(KiePMMLAggregateFunction.class, (String)"simpleMatching"))).isEqualTo((Object)KiePMMLAggregateFunction.SIMPLE_MATCHING);
        Assertions.assertThat((Comparable)((KiePMMLAggregateFunction)EnumUtils.enumByName(KiePMMLAggregateFunction.class, (String)"jaccard"))).isEqualTo((Object)KiePMMLAggregateFunction.JACCARD);
        Assertions.assertThat((Comparable)((KiePMMLAggregateFunction)EnumUtils.enumByName(KiePMMLAggregateFunction.class, (String)"tanimoto"))).isEqualTo((Object)KiePMMLAggregateFunction.TANIMOTO);
        Assertions.assertThat((Comparable)((KiePMMLAggregateFunction)EnumUtils.enumByName(KiePMMLAggregateFunction.class, (String)"binarySimilarity"))).isEqualTo((Object)KiePMMLAggregateFunction.BINARY_SIMILARITY);
    }

    @Test
    public void testApply() {
        Assertions.assertThat((double)KiePMMLAggregateFunction.EUCLIDEAN.apply(TEST_FIELDS, TEST_COMPARE_FN, TEST_INPUTS, TEST_SEEDS, 1.0)).isEqualTo(KiePMMLAggregateFunction.euclidean(TEST_FIELDS, (KiePMMLCompareFunction)TEST_COMPARE_FN, (Double[])TEST_INPUTS, (double[])TEST_SEEDS, (double)1.0), DOUBLE_OFFSET);
        Assertions.assertThat((double)KiePMMLAggregateFunction.SQUARED_EUCLIDEAN.apply(TEST_FIELDS, TEST_COMPARE_FN, TEST_INPUTS, TEST_SEEDS, 1.0)).isEqualTo(KiePMMLAggregateFunction.squaredEuclidean(TEST_FIELDS, (KiePMMLCompareFunction)TEST_COMPARE_FN, (Double[])TEST_INPUTS, (double[])TEST_SEEDS, (double)1.0), DOUBLE_OFFSET);
        Assertions.assertThatThrownBy(() -> KiePMMLAggregateFunction.CHEBYCHEV.apply(TEST_FIELDS, TEST_COMPARE_FN, TEST_INPUTS, TEST_SEEDS, 1.0)).isInstanceOf(UnsupportedOperationException.class);
        Assertions.assertThatThrownBy(() -> KiePMMLAggregateFunction.CITY_BLOCK.apply(TEST_FIELDS, TEST_COMPARE_FN, TEST_INPUTS, TEST_SEEDS, 1.0)).isInstanceOf(UnsupportedOperationException.class);
        Assertions.assertThatThrownBy(() -> KiePMMLAggregateFunction.MINKOWSKI.apply(TEST_FIELDS, TEST_COMPARE_FN, TEST_INPUTS, TEST_SEEDS, 1.0)).isInstanceOf(UnsupportedOperationException.class);
        Assertions.assertThatThrownBy(() -> KiePMMLAggregateFunction.SIMPLE_MATCHING.apply(TEST_FIELDS, TEST_COMPARE_FN, TEST_INPUTS, TEST_SEEDS, 1.0)).isInstanceOf(UnsupportedOperationException.class);
        Assertions.assertThatThrownBy(() -> KiePMMLAggregateFunction.JACCARD.apply(TEST_FIELDS, TEST_COMPARE_FN, TEST_INPUTS, TEST_SEEDS, 1.0)).isInstanceOf(UnsupportedOperationException.class);
        Assertions.assertThatThrownBy(() -> KiePMMLAggregateFunction.TANIMOTO.apply(TEST_FIELDS, TEST_COMPARE_FN, TEST_INPUTS, TEST_SEEDS, 1.0)).isInstanceOf(UnsupportedOperationException.class);
        Assertions.assertThatThrownBy(() -> KiePMMLAggregateFunction.BINARY_SIMILARITY.apply(TEST_FIELDS, TEST_COMPARE_FN, TEST_INPUTS, TEST_SEEDS, 1.0)).isInstanceOf(UnsupportedOperationException.class);
    }

    @Test
    public void testEuclidean() {
        Assertions.assertThat((double)KiePMMLAggregateFunction.euclidean(TEST_FIELDS, (KiePMMLCompareFunction)TEST_COMPARE_FN, (Double[])TEST_INPUTS, (double[])TEST_SEEDS, (double)1.0)).isEqualTo(5.0, DOUBLE_OFFSET);
    }

    @Test
    public void testSquaredEuclidean() {
        Assertions.assertThat((double)KiePMMLAggregateFunction.squaredEuclidean(TEST_FIELDS, (KiePMMLCompareFunction)TEST_COMPARE_FN, (Double[])TEST_INPUTS, (double[])TEST_SEEDS, (double)1.0)).isEqualTo(25.0, DOUBLE_OFFSET);
    }

    static {
        TEST_FIELDS.add(new KiePMMLClusteringField("test1", Double.valueOf(1.0), Boolean.valueOf(true), null, null));
        TEST_FIELDS.add(new KiePMMLClusteringField("test2", Double.valueOf(1.0), Boolean.valueOf(true), null, null));
        KiePMMLAggregateFunctionTest.TEST_INPUTS[0] = 5.0;
        KiePMMLAggregateFunctionTest.TEST_INPUTS[1] = 3.0;
        KiePMMLAggregateFunctionTest.TEST_SEEDS[0] = 1.0;
        KiePMMLAggregateFunctionTest.TEST_SEEDS[1] = 6.0;
    }
}

