/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.models.drools.utils;

import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.PackageDeclaration;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.ConstructorDeclaration;
import com.github.javaparser.ast.expr.AssignExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.IntegerLiteralExpr;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.ObjectCreationExpr;
import com.github.javaparser.ast.expr.SimpleName;
import com.github.javaparser.ast.expr.StringLiteralExpr;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.stmt.ExpressionStmt;
import com.github.javaparser.ast.stmt.Statement;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.dmg.pmml.DataDictionary;
import org.dmg.pmml.DataField;
import org.dmg.pmml.DataType;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.MiningField;
import org.dmg.pmml.MiningFunction;
import org.dmg.pmml.MiningSchema;
import org.dmg.pmml.Model;
import org.dmg.pmml.OpType;
import org.dmg.pmml.tree.TreeModel;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.kie.pmml.commons.model.KiePMMLOutputField;
import org.kie.pmml.commons.model.enums.MINING_FUNCTION;
import org.kie.pmml.commons.model.enums.PMML_MODEL;
import org.kie.pmml.commons.model.enums.RESULT_FEATURE;
import org.kie.pmml.commons.utils.KiePMMLModelUtils;
import org.kie.pmml.compiler.commons.utils.JavaParserUtils;
import org.kie.pmml.models.drools.tuples.KiePMMLOriginalTypeGeneratedType;
import org.kie.pmml.models.drools.utils.KiePMMLDroolsModelFactoryUtils;

public class KiePMMLDroolsModelFactoryUtilsTest {
    private static final String TEMPLATE_SOURCE = "Template.tmpl";
    private static final String TEMPLATE_CLASS_NAME = "Template";
    private static CompilationUnit COMPILATION_UNIT;
    private static ClassOrInterfaceDeclaration MODEL_TEMPLATE;

    @BeforeClass
    public static void setup() {
        COMPILATION_UNIT = JavaParserUtils.getFromFileName((String)TEMPLATE_SOURCE);
        MODEL_TEMPLATE = (ClassOrInterfaceDeclaration)COMPILATION_UNIT.getClassByName(TEMPLATE_CLASS_NAME).get();
    }

    @Test
    public void getKiePMMLModelCompilationUnit() {
        DataDictionary dataDictionary = new DataDictionary();
        String targetFieldString = "target.field";
        FieldName targetFieldName = FieldName.create((String)targetFieldString);
        dataDictionary.addDataFields(new DataField[]{new DataField(targetFieldName, OpType.CONTINUOUS, DataType.DOUBLE)});
        String modelName = "ModelName";
        TreeModel model = new TreeModel();
        model.setModelName(modelName);
        model.setMiningFunction(MiningFunction.CLASSIFICATION);
        MiningField targetMiningField = new MiningField(targetFieldName);
        targetMiningField.setUsageType(MiningField.UsageType.TARGET);
        MiningSchema miningSchema = new MiningSchema();
        miningSchema.addMiningFields(new MiningField[]{targetMiningField});
        model.setMiningSchema(miningSchema);
        HashMap<String, KiePMMLOriginalTypeGeneratedType> fieldTypeMap = new HashMap<String, KiePMMLOriginalTypeGeneratedType>();
        fieldTypeMap.put(targetFieldString, new KiePMMLOriginalTypeGeneratedType(targetFieldString, KiePMMLModelUtils.getSanitizedClassName((String)targetFieldString)));
        String packageName = "net.test";
        CompilationUnit retrieved = KiePMMLDroolsModelFactoryUtils.getKiePMMLModelCompilationUnit((DataDictionary)dataDictionary, (Model)model, fieldTypeMap, (String)packageName, (String)TEMPLATE_SOURCE, (String)TEMPLATE_CLASS_NAME);
        Assert.assertEquals((Object)packageName, (Object)((PackageDeclaration)retrieved.getPackageDeclaration().get()).getNameAsString());
        ConstructorDeclaration constructorDeclaration = (ConstructorDeclaration)((ClassOrInterfaceDeclaration)retrieved.getClassByName(modelName).get()).getDefaultConstructor().get();
        MINING_FUNCTION miningFunction = MINING_FUNCTION.CLASSIFICATION;
        PMML_MODEL pmmlModel = PMML_MODEL.byName((String)model.getClass().getSimpleName());
        HashMap<String, Expression> assignExpressionMap = new HashMap<String, Expression>();
        assignExpressionMap.put("targetField", (Expression)new StringLiteralExpr(targetFieldString));
        assignExpressionMap.put("miningFunction", (Expression)new NameExpr(miningFunction.getClass().getName() + "." + miningFunction.name()));
        assignExpressionMap.put("pmmlMODEL", (Expression)new NameExpr(pmmlModel.getClass().getName() + "." + pmmlModel.name()));
        this.commonEvaluateAssignExpr(constructorDeclaration.getBody(), assignExpressionMap);
        int expectedMethodCallExprs = assignExpressionMap.size() + fieldTypeMap.size() + 1;
        this.commonEvaluateFieldTypeMap(constructorDeclaration.getBody(), fieldTypeMap, expectedMethodCallExprs);
    }

    @Test
    public void setConstructor() {
        TreeModel model = new TreeModel();
        PMML_MODEL pmmlModel = PMML_MODEL.byName((String)model.getClass().getSimpleName());
        ConstructorDeclaration constructorDeclaration = (ConstructorDeclaration)MODEL_TEMPLATE.getDefaultConstructor().get();
        SimpleName tableName = new SimpleName("TABLE_NAME");
        String targetField = "TARGET_FIELD";
        MINING_FUNCTION miningFunction = MINING_FUNCTION.CLASSIFICATION;
        KiePMMLDroolsModelFactoryUtils.setConstructor((Model)model, (ConstructorDeclaration)constructorDeclaration, (SimpleName)tableName, (String)targetField, (MINING_FUNCTION)miningFunction);
        Assert.assertEquals((Object)tableName, (Object)constructorDeclaration.getName());
        HashMap<String, Expression> assignExpressionMap = new HashMap<String, Expression>();
        assignExpressionMap.put("targetField", (Expression)new StringLiteralExpr(targetField));
        assignExpressionMap.put("miningFunction", (Expression)new NameExpr(miningFunction.getClass().getName() + "." + miningFunction.name()));
        assignExpressionMap.put("pmmlMODEL", (Expression)new NameExpr(pmmlModel.getClass().getName() + "." + pmmlModel.name()));
        this.commonEvaluateAssignExpr(constructorDeclaration.getBody(), assignExpressionMap);
    }

    @Test
    public void addOutputFieldsPopulation() {
        BlockStmt blockStmt = new BlockStmt();
        List outputFields = IntStream.range(0, 3).mapToObj(index -> (KiePMMLOutputField)KiePMMLOutputField.builder((String)("OUTPUTFIELD-" + index), Collections.emptyList()).withRank(Integer.valueOf(new Random().nextInt(3))).withValue((Object)("VALUE-" + index)).withTargetField("TARGETFIELD-" + index).build()).collect(Collectors.toList());
        KiePMMLDroolsModelFactoryUtils.addOutputFieldsPopulation((BlockStmt)blockStmt, outputFields);
        List<MethodCallExpr> retrieved = this.getMethodCallExprList(blockStmt, outputFields.size(), "outputFields", "add");
        for (KiePMMLOutputField outputField : outputFields) {
            Assert.assertTrue((boolean)retrieved.stream().filter(methodCallExpr -> methodCallExpr.getArguments().size() == 1).map(methodCallExpr -> methodCallExpr.getArgument(0)).filter(Expression::isMethodCallExpr).map(expressionArgument -> (MethodCallExpr)expressionArgument).anyMatch(methodCallExpr -> this.evaluateOutputFieldPopulation((MethodCallExpr)methodCallExpr, outputField)));
        }
    }

    @Test
    public void addFieldTypeMapPopulation() {
        BlockStmt blockStmt = new BlockStmt();
        HashMap<String, KiePMMLOriginalTypeGeneratedType> fieldTypeMap = new HashMap<String, KiePMMLOriginalTypeGeneratedType>();
        IntStream.range(0, 3).forEach(index -> {
            String key = "KEY-" + index;
            KiePMMLOriginalTypeGeneratedType value = new KiePMMLOriginalTypeGeneratedType("ORIGINALTYPE-" + index, "GENERATEDTYPE-" + index);
            fieldTypeMap.put(key, value);
        });
        KiePMMLDroolsModelFactoryUtils.addFieldTypeMapPopulation((BlockStmt)blockStmt, fieldTypeMap);
        this.commonEvaluateFieldTypeMap(blockStmt, fieldTypeMap, fieldTypeMap.size());
    }

    private boolean evaluateOutputFieldPopulation(MethodCallExpr methodCallExpr, KiePMMLOutputField outputField) {
        boolean toReturn = this.commonEvaluateMethodCallExpr(methodCallExpr, "build", (NodeList<Expression>)new NodeList(), MethodCallExpr.class);
        MethodCallExpr resultFeatureScopeExpr = (MethodCallExpr)methodCallExpr.getScope().get();
        NodeList expectedArguments = NodeList.nodeList((Node[])new Expression[]{new NameExpr(RESULT_FEATURE.class.getName() + "." + outputField.getResultFeature().toString())});
        toReturn &= this.commonEvaluateMethodCallExpr(resultFeatureScopeExpr, "withResultFeature", (NodeList<Expression>)expectedArguments, MethodCallExpr.class);
        MethodCallExpr targetFieldScopeExpr = (MethodCallExpr)resultFeatureScopeExpr.getScope().get();
        expectedArguments = NodeList.nodeList((Node[])new Expression[]{new StringLiteralExpr((String)outputField.getTargetField().get())});
        toReturn &= this.commonEvaluateMethodCallExpr(targetFieldScopeExpr, "withTargetField", (NodeList<Expression>)expectedArguments, MethodCallExpr.class);
        MethodCallExpr valueScopeExpr = (MethodCallExpr)targetFieldScopeExpr.getScope().get();
        expectedArguments = NodeList.nodeList((Node[])new Expression[]{new StringLiteralExpr(outputField.getValue().toString())});
        toReturn &= this.commonEvaluateMethodCallExpr(valueScopeExpr, "withValue", (NodeList<Expression>)expectedArguments, MethodCallExpr.class);
        MethodCallExpr rankScopeExpr = (MethodCallExpr)valueScopeExpr.getScope().get();
        expectedArguments = NodeList.nodeList((Node[])new Expression[]{new IntegerLiteralExpr(outputField.getRank().intValue())});
        toReturn &= this.commonEvaluateMethodCallExpr(rankScopeExpr, "withRank", (NodeList<Expression>)expectedArguments, MethodCallExpr.class);
        MethodCallExpr builderScopeExpr = (MethodCallExpr)rankScopeExpr.getScope().get();
        expectedArguments = NodeList.nodeList((Node[])new Expression[]{new StringLiteralExpr(outputField.getName()), new NameExpr("Collections.emptyList()")});
        toReturn &= this.commonEvaluateMethodCallExpr(builderScopeExpr, "builder", (NodeList<Expression>)expectedArguments, NameExpr.class);
        toReturn &= builderScopeExpr.getName().equals((Object)new SimpleName("builder"));
        return toReturn &= ((Expression)builderScopeExpr.getScope().get()).equals((Object)new NameExpr("KiePMMLOutputField"));
    }

    private void commonEvaluateAssignExpr(BlockStmt blockStmt, Map<String, Expression> assignExpressionMap) {
        List retrieved = blockStmt.findAll(AssignExpr.class);
        for (Map.Entry<String, Expression> entry : assignExpressionMap.entrySet()) {
            Assert.assertTrue((boolean)retrieved.stream().filter(assignExpr -> assignExpr.getTarget().asNameExpr().equals((Object)new NameExpr((String)entry.getKey()))).anyMatch(assignExpr -> assignExpr.getValue().equals(entry.getValue())));
        }
    }

    private void commonEvaluateFieldTypeMap(BlockStmt blockStmt, Map<String, KiePMMLOriginalTypeGeneratedType> fieldTypeMap, int expectedMethodCallSize) {
        List<MethodCallExpr> retrieved = this.getMethodCallExprList(blockStmt, expectedMethodCallSize, "fieldTypeMap", "put");
        for (Map.Entry<String, KiePMMLOriginalTypeGeneratedType> entry : fieldTypeMap.entrySet()) {
            Assert.assertTrue((boolean)retrieved.stream().map(MethodCallExpr::getArguments).anyMatch(arguments -> this.evaluateFieldTypeMapPopulation(entry, (NodeList<Expression>)arguments)));
        }
    }

    private boolean evaluateFieldTypeMapPopulation(Map.Entry<String, KiePMMLOriginalTypeGeneratedType> entry, NodeList<Expression> arguments) {
        boolean toReturn = arguments.size() == 2;
        Expression firstArgument = (Expression)arguments.get(0);
        Expression secondArgument = (Expression)arguments.get(1);
        toReturn &= firstArgument.isStringLiteralExpr() && ((StringLiteralExpr)firstArgument).getValue().equals(entry.getKey());
        return toReturn &= secondArgument.isObjectCreationExpr() && ((ObjectCreationExpr)secondArgument).getArgument(0).isStringLiteralExpr() && ((StringLiteralExpr)((ObjectCreationExpr)secondArgument).getArgument(0)).getValue().equals(entry.getValue().getOriginalType()) && ((ObjectCreationExpr)secondArgument).getArgument(1).isStringLiteralExpr() && ((StringLiteralExpr)((ObjectCreationExpr)secondArgument).getArgument(1)).getValue().equals(entry.getValue().getGeneratedType());
    }

    private boolean commonEvaluateMethodCallExpr(MethodCallExpr toEvaluate, String name, NodeList<Expression> expectedArguments, Class<? extends Expression> expectedScopeType) {
        boolean toReturn = Objects.equals(new SimpleName(name), toEvaluate.getName());
        toReturn &= expectedArguments.size() == toEvaluate.getArguments().size();
        for (int i = 0; i < expectedArguments.size(); ++i) {
            toReturn &= ((Expression)expectedArguments.get(i)).equals((Object)toEvaluate.getArgument(i));
        }
        if (expectedScopeType != null) {
            toReturn &= toEvaluate.getScope().isPresent() && ((Expression)toEvaluate.getScope().get()).getClass().equals(expectedScopeType);
        }
        return toReturn;
    }

    private List<MethodCallExpr> getMethodCallExprList(BlockStmt blockStmt, int expectedSize, String scope, String method) {
        Stream<Statement> statementStream = this.getStatementStream(blockStmt, expectedSize);
        return statementStream.filter(Statement::isExpressionStmt).map(expressionStmt -> ((ExpressionStmt)expressionStmt).getExpression()).filter(expression -> expression instanceof MethodCallExpr).map(expression -> (MethodCallExpr)expression).filter(methodCallExpr -> this.evaluateMethodCallExpr((MethodCallExpr)methodCallExpr, scope, method)).collect(Collectors.toList());
    }

    private boolean evaluateMethodCallExpr(MethodCallExpr methodCallExpr, String scope, String method) {
        return methodCallExpr.getScope().isPresent() && ((Expression)methodCallExpr.getScope().get()).isNameExpr() && ((NameExpr)methodCallExpr.getScope().get()).getName().asString().equals(scope) && methodCallExpr.getName().asString().equals(method);
    }

    private Stream<Statement> getStatementStream(BlockStmt blockStmt, int expectedSize) {
        NodeList statements = blockStmt.getStatements();
        Assert.assertEquals((long)expectedSize, (long)statements.size());
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(statements.iterator(), 16), false);
    }
}

