/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.models.drools.tuples;

import java.util.Objects;
import org.kie.pmml.commons.model.enums.OPERATOR;

public class KiePMMLOperatorValue {
    public static final String VALUE_CONSTRAINT_PATTERN = "value %s %s";
    private final OPERATOR operator;
    private final Object value;
    private final String constraintsString;

    public KiePMMLOperatorValue(OPERATOR operator, Object value) {
        this.operator = operator;
        this.value = value;
        this.constraintsString = this.buildConstraintsString();
    }

    public OPERATOR getOperator() {
        return this.operator;
    }

    public Object getValue() {
        return this.value;
    }

    public String getConstraintsAsString() {
        return this.constraintsString;
    }

    public String toString() {
        return "KiePMMLOperatorValue{operator='" + this.operator + '\'' + ", value=" + this.value + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KiePMMLOperatorValue that = (KiePMMLOperatorValue)o;
        return Objects.equals(this.operator, that.operator) && Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return Objects.hash(this.operator, this.value);
    }

    protected String buildConstraintsString() {
        return String.format(VALUE_CONSTRAINT_PATTERN, this.operator.getOperator(), this.value);
    }
}

