/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.models.drools.provider;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.dmg.pmml.DataDictionary;
import org.dmg.pmml.LocalTransformations;
import org.dmg.pmml.Model;
import org.dmg.pmml.TransformationDictionary;
import org.drools.compiler.builder.impl.KnowledgeBuilderImpl;
import org.drools.compiler.lang.descr.PackageDescr;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.pmml.commons.exceptions.KiePMMLException;
import org.kie.pmml.commons.model.enums.DATA_TYPE;
import org.kie.pmml.compiler.api.provider.ModelImplementationProvider;
import org.kie.pmml.models.drools.ast.KiePMMLDroolsAST;
import org.kie.pmml.models.drools.ast.KiePMMLDroolsType;
import org.kie.pmml.models.drools.ast.factories.KiePMMLDataDictionaryASTFactory;
import org.kie.pmml.models.drools.ast.factories.KiePMMLDerivedFieldASTFactory;
import org.kie.pmml.models.drools.commons.factories.KiePMMLDescrFactory;
import org.kie.pmml.models.drools.commons.model.KiePMMLDroolsModel;
import org.kie.pmml.models.drools.commons.model.KiePMMLDroolsModelWithSources;
import org.kie.pmml.models.drools.tuples.KiePMMLOriginalTypeGeneratedType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DroolsModelProvider<T extends Model, E extends KiePMMLDroolsModel>
implements ModelImplementationProvider<T, E> {
    private static final Logger logger = LoggerFactory.getLogger((String)DroolsModelProvider.class.getName());

    public E getKiePMMLModel(DataDictionary dataDictionary, TransformationDictionary transformationDictionary, T model, Object kBuilder) {
        logger.trace("getKiePMMLModel {} {} {}", new Object[]{dataDictionary, transformationDictionary, model});
        if (!(kBuilder instanceof KnowledgeBuilder)) {
            throw new KiePMMLException(String.format("Expecting KnowledgeBuilder, received %s", kBuilder.getClass().getName()));
        }
        HashMap<String, KiePMMLOriginalTypeGeneratedType> fieldTypeMap = new HashMap<String, KiePMMLOriginalTypeGeneratedType>();
        KiePMMLDroolsAST kiePMMLDroolsAST = this.getKiePMMLDroolsASTCommon(dataDictionary, transformationDictionary, model, fieldTypeMap);
        E toReturn = this.getKiePMMLDroolsModel(dataDictionary, transformationDictionary, model, fieldTypeMap);
        PackageDescr packageDescr = this.getPackageDescr(kiePMMLDroolsAST, ((KiePMMLDroolsModel)((Object)toReturn)).getKModulePackageName());
        ((KnowledgeBuilderImpl)kBuilder).addPackage(packageDescr);
        return toReturn;
    }

    public E getKiePMMLModelFromPlugin(String packageName, DataDictionary dataDictionary, TransformationDictionary transformationDictionary, T model, Object kBuilder) {
        logger.trace("getKiePMMLModelFromPlugin {} {} {}", new Object[]{dataDictionary, model, kBuilder});
        if (!(kBuilder instanceof KnowledgeBuilder)) {
            throw new KiePMMLException(String.format("Expecting KnowledgeBuilder, received %s", kBuilder.getClass().getName()));
        }
        try {
            HashMap<String, KiePMMLOriginalTypeGeneratedType> fieldTypeMap = new HashMap<String, KiePMMLOriginalTypeGeneratedType>();
            KiePMMLDroolsAST kiePMMLDroolsAST = this.getKiePMMLDroolsASTCommon(dataDictionary, transformationDictionary, model, fieldTypeMap);
            Map<String, String> sourcesMap = this.getKiePMMLDroolsModelSourcesMap(dataDictionary, transformationDictionary, model, fieldTypeMap, packageName);
            PackageDescr packageDescr = this.getPackageDescr(kiePMMLDroolsAST, packageName);
            KiePMMLDroolsModelWithSources toReturn = new KiePMMLDroolsModelWithSources(model.getModelName(), packageName, sourcesMap, packageDescr);
            ((KnowledgeBuilderImpl)kBuilder).addPackage(packageDescr);
            return (E)((Object)toReturn);
        }
        catch (Exception e) {
            throw new KiePMMLException((Throwable)e);
        }
    }

    public PackageDescr getPackageDescr(KiePMMLDroolsAST kiePMMLDroolsAST, String packageName) {
        return KiePMMLDescrFactory.getBaseDescr(kiePMMLDroolsAST, packageName);
    }

    public abstract E getKiePMMLDroolsModel(DataDictionary var1, TransformationDictionary var2, T var3, Map<String, KiePMMLOriginalTypeGeneratedType> var4);

    public abstract KiePMMLDroolsAST getKiePMMLDroolsAST(DataDictionary var1, T var2, Map<String, KiePMMLOriginalTypeGeneratedType> var3, List<KiePMMLDroolsType> var4);

    public abstract Map<String, String> getKiePMMLDroolsModelSourcesMap(DataDictionary var1, TransformationDictionary var2, T var3, Map<String, KiePMMLOriginalTypeGeneratedType> var4, String var5) throws IOException;

    protected KiePMMLDroolsAST getKiePMMLDroolsASTCommon(DataDictionary dataDictionary, TransformationDictionary transformationDictionary, T model, Map<String, KiePMMLOriginalTypeGeneratedType> fieldTypeMap) {
        this.addTransformationsDerivedFields(fieldTypeMap, transformationDictionary, model.getLocalTransformations());
        List<KiePMMLDroolsType> types = fieldTypeMap.values().stream().map(kiePMMLOriginalTypeGeneratedType -> {
            String type = DATA_TYPE.byName((String)kiePMMLOriginalTypeGeneratedType.getOriginalType()).getMappedClass().getSimpleName();
            return new KiePMMLDroolsType(kiePMMLOriginalTypeGeneratedType.getGeneratedType(), type);
        }).collect(Collectors.toList());
        types.addAll(KiePMMLDataDictionaryASTFactory.factory(fieldTypeMap).declareTypes(dataDictionary));
        return this.getKiePMMLDroolsAST(dataDictionary, model, fieldTypeMap, types);
    }

    protected void addTransformationsDerivedFields(Map<String, KiePMMLOriginalTypeGeneratedType> fieldTypeMap, TransformationDictionary transformationDictionary, LocalTransformations localTransformations) {
        KiePMMLDerivedFieldASTFactory kiePMMLDerivedFieldASTFactory = KiePMMLDerivedFieldASTFactory.factory(fieldTypeMap);
        if (transformationDictionary != null && transformationDictionary.getDerivedFields() != null) {
            kiePMMLDerivedFieldASTFactory.declareTypes(transformationDictionary.getDerivedFields());
        }
        if (localTransformations != null && localTransformations.getDerivedFields() != null) {
            kiePMMLDerivedFieldASTFactory.declareTypes(localTransformations.getDerivedFields());
        }
    }
}

