/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.models.drools.commons.factories;

import java.util.Collections;
import java.util.List;
import java.util.StringJoiner;
import org.drools.compiler.lang.api.DescrFactory;
import org.drools.compiler.lang.api.PackageDescrBuilder;
import org.drools.compiler.lang.api.RuleDescrBuilder;
import org.drools.compiler.lang.descr.RuleDescr;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.pmml.commons.enums.ResultCode;
import org.kie.pmml.commons.model.KiePMMLOutputField;
import org.kie.pmml.commons.model.abstracts.AbstractKiePMMLComponent;
import org.kie.pmml.commons.model.enums.RESULT_FEATURE;
import org.kie.pmml.models.drools.ast.KiePMMLDroolsRule;
import org.kie.pmml.models.drools.commons.factories.KiePMMLDescrRhsFactory;

public class KiePMMLDescrRhsFactoryTest {
    private static final String PACKAGE_NAME = "package";
    private static final String CURRENT_RULE = "currentRule";
    private RuleDescrBuilder ruleBuilder;

    @Before
    public void setUp() throws Exception {
        PackageDescrBuilder builder = DescrFactory.newPackage().name(PACKAGE_NAME);
        this.ruleBuilder = builder.newRule().name(CURRENT_RULE);
        Assert.assertEquals((Object)CURRENT_RULE, (Object)((RuleDescr)this.ruleBuilder.getDescr()).getName());
    }

    @Test
    public void declareRhsWithoutIfBreak() {
        String name = "NAME";
        String statusToSet = "STATUS_TO_SET";
        KiePMMLDroolsRule rule = KiePMMLDroolsRule.builder((String)name, (String)statusToSet, Collections.emptyList()).build();
        KiePMMLDescrRhsFactory.factory((RuleDescrBuilder)this.ruleBuilder).declareRhs(rule);
        Assert.assertNotNull((Object)((RuleDescr)this.ruleBuilder.getDescr()).getConsequence());
        String expectedConsequence = String.format("\r\n$statusHolder.setStatus(\"%s\");", statusToSet);
        Assert.assertTrue((boolean)((RuleDescr)this.ruleBuilder.getDescr()).getConsequence().toString().contains(expectedConsequence));
        Assert.assertNotNull((Object)((RuleDescr)this.ruleBuilder.getDescr()).getNamedConsequences());
        Assert.assertTrue((boolean)((RuleDescr)this.ruleBuilder.getDescr()).getNamedConsequences().isEmpty());
    }

    @Test
    public void declareRhsWithIfBreak() {
        String name = "NAME";
        String statusToSet = "STATUS_TO_SET";
        String ifBreakField = "ifBreakField";
        String ifBreakOperator = "ifBreakOperator";
        String ifBreakValue = "ifBreakValue";
        KiePMMLDroolsRule rule = KiePMMLDroolsRule.builder((String)name, (String)statusToSet, Collections.emptyList()).withIfBreak(ifBreakField, ifBreakOperator, (Object)ifBreakValue).build();
        KiePMMLDescrRhsFactory.factory((RuleDescrBuilder)this.ruleBuilder).declareRhs(rule);
        Assert.assertNotNull((Object)((RuleDescr)this.ruleBuilder.getDescr()).getConsequence());
        String expectedConsequence = String.format("\r\n$statusHolder.setStatus(\"%s\");", statusToSet);
        Assert.assertTrue((boolean)((RuleDescr)this.ruleBuilder.getDescr()).getConsequence().toString().contains(expectedConsequence));
        Assert.assertNotNull((Object)((RuleDescr)this.ruleBuilder.getDescr()).getNamedConsequences());
        Assert.assertEquals((long)1L, (long)((RuleDescr)this.ruleBuilder.getDescr()).getNamedConsequences().size());
        Assert.assertNotNull(((RuleDescr)this.ruleBuilder.getDescr()).getNamedConsequences().get("match"));
    }

    @Test
    public void declareDefaultThenWithoutResult() {
        String name = "NAME";
        String statusToSet = "STATUS_TO_SET";
        KiePMMLDroolsRule rule = KiePMMLDroolsRule.builder((String)name, (String)statusToSet, Collections.emptyList()).build();
        KiePMMLDescrRhsFactory.factory((RuleDescrBuilder)this.ruleBuilder).declareDefaultThen(rule);
        Assert.assertNotNull((Object)((RuleDescr)this.ruleBuilder.getDescr()).getConsequence());
        String expectedConsequence = String.format("\r\n$statusHolder.setStatus(\"%s\");", statusToSet);
        Assert.assertTrue((boolean)((RuleDescr)this.ruleBuilder.getDescr()).getConsequence().toString().contains(expectedConsequence));
        Assert.assertNotNull((Object)((RuleDescr)this.ruleBuilder.getDescr()).getNamedConsequences());
        Assert.assertTrue((boolean)((RuleDescr)this.ruleBuilder.getDescr()).getNamedConsequences().isEmpty());
    }

    @Test
    public void declareDefaultThenWithResult() {
        String name = "NAME";
        String statusToSet = "STATUS_TO_SET";
        String result = "RESULT";
        ResultCode resultCode = ResultCode.OK;
        KiePMMLDroolsRule rule = KiePMMLDroolsRule.builder((String)name, (String)statusToSet, Collections.emptyList()).withResultCode(resultCode).withResult((Object)result).build();
        KiePMMLDescrRhsFactory.factory((RuleDescrBuilder)this.ruleBuilder).declareDefaultThen(rule);
        Assert.assertNotNull((Object)((RuleDescr)this.ruleBuilder.getDescr()).getConsequence());
        String retrievedConsequence = ((RuleDescr)this.ruleBuilder.getDescr()).getConsequence().toString();
        Assert.assertTrue((boolean)retrievedConsequence.contains(String.format("\r\n$statusHolder.setStatus(\"%s\");", statusToSet)));
        Assert.assertTrue((boolean)retrievedConsequence.contains(String.format("\r\n$pmml4Result.setResultCode(\"%s\");", resultCode)));
        Assert.assertTrue((boolean)retrievedConsequence.contains(String.format("\r\n$pmml4Result.addResultVariable($pmml4Result.getResultObjectName(), %s);", result)));
        Assert.assertNotNull((Object)((RuleDescr)this.ruleBuilder.getDescr()).getNamedConsequences());
        Assert.assertTrue((boolean)((RuleDescr)this.ruleBuilder.getDescr()).getNamedConsequences().isEmpty());
    }

    @Test
    public void declareIfThenWithoutResult() {
        String name = "NAME";
        String statusToSet = "STATUS_TO_SET";
        KiePMMLDroolsRule rule = KiePMMLDroolsRule.builder((String)name, (String)statusToSet, Collections.emptyList()).build();
        KiePMMLDescrRhsFactory.factory((RuleDescrBuilder)this.ruleBuilder).declareIfThen(rule);
        Assert.assertNotNull((Object)((RuleDescr)this.ruleBuilder.getDescr()).getConsequence());
        String expectedConsequence = String.format("\r\n$statusHolder.setStatus(\"%s\");", statusToSet);
        Assert.assertEquals((Object)expectedConsequence, (Object)((RuleDescr)this.ruleBuilder.getDescr()).getConsequence());
        Assert.assertNotNull((Object)((RuleDescr)this.ruleBuilder.getDescr()).getNamedConsequences());
        Assert.assertEquals((long)1L, (long)((RuleDescr)this.ruleBuilder.getDescr()).getNamedConsequences().size());
        Assert.assertNotNull(((RuleDescr)this.ruleBuilder.getDescr()).getNamedConsequences().get("match"));
        expectedConsequence = String.format("\r\n$statusHolder.setStatus(\"%s\");", "DONE");
        Assert.assertTrue((String)expectedConsequence, (boolean)((RuleDescr)this.ruleBuilder.getDescr()).getNamedConsequences().get("match").toString().contains(expectedConsequence));
    }

    @Test
    public void declareIfThenWithResult() {
        String name = "NAME";
        String statusToSet = "STATUS_TO_SET";
        String result = "RESULT";
        ResultCode resultCode = ResultCode.OK;
        KiePMMLDroolsRule rule = KiePMMLDroolsRule.builder((String)name, (String)statusToSet, Collections.emptyList()).withResultCode(resultCode).withResult((Object)result).build();
        KiePMMLDescrRhsFactory.factory((RuleDescrBuilder)this.ruleBuilder).declareIfThen(rule);
        Assert.assertNotNull((Object)((RuleDescr)this.ruleBuilder.getDescr()).getConsequence());
        String expectedConsequence = String.format("\r\n$statusHolder.setStatus(\"%s\");", statusToSet);
        Assert.assertEquals((Object)expectedConsequence, (Object)((RuleDescr)this.ruleBuilder.getDescr()).getConsequence());
        Assert.assertNotNull((Object)((RuleDescr)this.ruleBuilder.getDescr()).getNamedConsequences());
        Assert.assertEquals((long)1L, (long)((RuleDescr)this.ruleBuilder.getDescr()).getNamedConsequences().size());
        Assert.assertNotNull(((RuleDescr)this.ruleBuilder.getDescr()).getNamedConsequences().get("match"));
        String retrievedConsequence = ((RuleDescr)this.ruleBuilder.getDescr()).getNamedConsequences().get("match").toString();
        Assert.assertTrue((boolean)retrievedConsequence.contains(String.format("\r\n$statusHolder.setStatus(\"%s\");", "DONE")));
        Assert.assertTrue((boolean)retrievedConsequence.contains(String.format("\r\n$pmml4Result.setResultCode(\"%s\");", resultCode)));
        Assert.assertTrue((boolean)retrievedConsequence.contains(String.format("\r\n$pmml4Result.addResultVariable($pmml4Result.getResultObjectName(), %s);", result)));
    }

    @Test
    public void commonDeclareThen() {
        String ruleName = "RULENAME";
        String statusToSet = "STATUSTOSET";
        String outputFieldName = "OUTPUTFIELDNAME";
        String result = "RESULT";
        List<AbstractKiePMMLComponent> outputFields = Collections.singletonList(KiePMMLOutputField.builder((String)outputFieldName, null).withResultFeature(RESULT_FEATURE.PREDICTED_VALUE).build());
        KiePMMLDroolsRule.Builder builder = KiePMMLDroolsRule.builder((String)ruleName, (String)statusToSet, outputFields);
        KiePMMLDroolsRule rule = builder.build();
        StringJoiner joiner = new StringJoiner("");
        KiePMMLDescrRhsFactory.factory((RuleDescrBuilder)this.ruleBuilder).commonDeclareThen(rule, joiner);
        String retrieved = joiner.toString();
        Assert.assertTrue((boolean)retrieved.isEmpty());
        ResultCode resultCode = ResultCode.OK;
        builder = builder.withResultCode(resultCode);
        rule = builder.build();
        joiner = new StringJoiner("");
        KiePMMLDescrRhsFactory.factory((RuleDescrBuilder)this.ruleBuilder).commonDeclareThen(rule, joiner);
        retrieved = joiner.toString();
        String expected = String.format("\r\n$pmml4Result.setResultCode(\"%s\");", resultCode);
        Assert.assertTrue((boolean)retrieved.contains(expected));
        builder = builder.withResult((Object)result);
        rule = builder.build();
        joiner = new StringJoiner("");
        KiePMMLDescrRhsFactory.factory((RuleDescrBuilder)this.ruleBuilder).commonDeclareThen(rule, joiner);
        retrieved = joiner.toString();
        expected = String.format("\r\n$pmml4Result.addResultVariable($pmml4Result.getResultObjectName(), %s);", result);
        Assert.assertTrue((boolean)retrieved.contains(expected));
        expected = String.format("\r\n$pmml4Result.addResultVariable(\"%s\", %s);", outputFieldName, result);
        Assert.assertTrue((boolean)retrieved.contains(expected));
        String focusedAgendaGroup = "FOCUSEDAGENDAGROUP";
        builder = builder.withFocusedAgendaGroup(focusedAgendaGroup);
        rule = builder.build();
        joiner = new StringJoiner("");
        KiePMMLDescrRhsFactory.factory((RuleDescrBuilder)this.ruleBuilder).commonDeclareThen(rule, joiner);
        retrieved = joiner.toString();
        expected = String.format("\r\nkcontext.getKieRuntime().getAgenda().getAgendaGroup( \"%s\" ).setFocus();", focusedAgendaGroup);
        Assert.assertTrue((boolean)retrieved.contains(expected));
    }

    @Test
    public void commonDeclareOutputFields() {
        String outputFieldName = "OUTPUTFIELDNAME";
        String result = "RESULT";
        List<AbstractKiePMMLComponent> outputFields = Collections.singletonList(KiePMMLOutputField.builder((String)outputFieldName, null).withResultFeature(RESULT_FEATURE.PREDICTED_VALUE).build());
        StringJoiner joiner = new StringJoiner("");
        KiePMMLDescrRhsFactory.factory((RuleDescrBuilder)this.ruleBuilder).commonDeclareOutputFields(outputFields, (Object)result, joiner);
        String retrieved = joiner.toString();
        String expected = String.format("\r\n$pmml4Result.addResultVariable(\"%s\", %s);", outputFieldName, result);
        Assert.assertEquals((Object)expected, (Object)retrieved);
    }
}

