/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.models.drools.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.dmg.pmml.CompoundPredicate;
import org.dmg.pmml.DataType;
import org.dmg.pmml.SimplePredicate;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.kie.pmml.commons.exceptions.KiePMMLException;
import org.kie.pmml.commons.model.enums.BOOLEAN_OPERATOR;
import org.kie.pmml.commons.model.enums.OPERATOR;
import org.kie.pmml.commons.utils.KiePMMLModelUtils;
import org.kie.pmml.compiler.commons.testutils.PMMLModelTestUtils;
import org.kie.pmml.models.drools.ast.KiePMMLFieldOperatorValue;
import org.kie.pmml.models.drools.tuples.KiePMMLOperatorValue;
import org.kie.pmml.models.drools.tuples.KiePMMLOriginalTypeGeneratedType;
import org.kie.pmml.models.drools.utils.KiePMMLASTFactoryUtils;

public class KiePMMLASTFactoryUtilsTest {
    private static Map<String, KiePMMLOriginalTypeGeneratedType> fieldTypeMap;
    private static Map<String, DataType> simplePredicateNameType;
    private static List<SimplePredicate> simplePredicates;
    private static List<CompoundPredicate> compoundPredicates;

    @BeforeClass
    public static void setup() {
        fieldTypeMap = new HashMap<String, KiePMMLOriginalTypeGeneratedType>();
        simplePredicateNameType = new HashMap<String, DataType>();
        simplePredicateNameType.put("age", DataType.INTEGER);
        simplePredicateNameType.put("weight", DataType.DOUBLE);
        simplePredicateNameType.put("name", DataType.STRING);
        simplePredicateNameType.put("runner", DataType.BOOLEAN);
        simplePredicates = simplePredicateNameType.entrySet().stream().map(entry -> {
            fieldTypeMap.put((String)entry.getKey(), new KiePMMLOriginalTypeGeneratedType(((DataType)entry.getValue()).value(), KiePMMLModelUtils.getSanitizedClassName((String)((String)entry.getKey()).toUpperCase())));
            return PMMLModelTestUtils.getSimplePredicate((String)((String)entry.getKey()), (Object)PMMLModelTestUtils.getRandomValue((DataType)((DataType)entry.getValue())), (SimplePredicate.Operator)PMMLModelTestUtils.getRandomSimplePredicateOperator());
        }).collect(Collectors.toList());
        compoundPredicates = IntStream.range(0, 4).mapToObj(index -> PMMLModelTestUtils.getCompoundPredicate(simplePredicates, (int)index)).collect(Collectors.toList());
    }

    @Test
    public void getConstraintEntriesFromXOrCompoundPredicate() {
        CompoundPredicate compoundPredicate = new CompoundPredicate();
        compoundPredicate.setBooleanOperator(CompoundPredicate.BooleanOperator.XOR);
        List predicates = IntStream.range(0, 2).mapToObj(index -> simplePredicates.get(index)).collect(Collectors.toList());
        compoundPredicate.getPredicates().addAll(predicates);
        List retrieved = KiePMMLASTFactoryUtils.getConstraintEntriesFromXOrCompoundPredicate((CompoundPredicate)compoundPredicate, fieldTypeMap);
        Assert.assertNotNull((Object)retrieved);
        Assert.assertEquals((long)predicates.size(), (long)retrieved.size());
        this.commonVerifyKiePMMLFieldOperatorValueList(retrieved, null);
    }

    @Test(expected=KiePMMLException.class)
    public void getConstraintEntriesFromXOrCompoundPredicateWrongSize() {
        CompoundPredicate compoundPredicate = new CompoundPredicate();
        compoundPredicate.setBooleanOperator(CompoundPredicate.BooleanOperator.XOR);
        compoundPredicate.getPredicates().addAll(simplePredicates);
        KiePMMLASTFactoryUtils.getConstraintEntriesFromXOrCompoundPredicate((CompoundPredicate)compoundPredicate, fieldTypeMap);
    }

    @Test(expected=KiePMMLException.class)
    public void getConstraintEntriesFromXOrCompoundPredicateWrongOperator() {
        CompoundPredicate compoundPredicate = new CompoundPredicate();
        compoundPredicate.setBooleanOperator(CompoundPredicate.BooleanOperator.AND);
        KiePMMLASTFactoryUtils.getConstraintEntriesFromXOrCompoundPredicate((CompoundPredicate)compoundPredicate, fieldTypeMap);
    }

    @Test
    public void getConstraintEntryFromSimplePredicates() {
        HashMap fieldTypeMap = new HashMap();
        String fieldName = "FIELD_NAME";
        List simplePredicates = IntStream.range(0, 2).mapToObj(index -> {
            fieldTypeMap.put(fieldName, new KiePMMLOriginalTypeGeneratedType(DataType.STRING.value(), KiePMMLModelUtils.getSanitizedClassName((String)fieldName.toUpperCase())));
            return PMMLModelTestUtils.getSimplePredicate((String)fieldName, (Object)("VALUE-" + index), (SimplePredicate.Operator)SimplePredicate.Operator.LESS_THAN);
        }).collect(Collectors.toList());
        KiePMMLFieldOperatorValue retrieved = KiePMMLASTFactoryUtils.getConstraintEntryFromSimplePredicates((String)fieldName, (BOOLEAN_OPERATOR)BOOLEAN_OPERATOR.OR, simplePredicates, fieldTypeMap);
        Assert.assertEquals((Object)fieldName, (Object)retrieved.getName());
        Assert.assertNotNull((Object)retrieved.getConstraintsAsString());
        String expected = "value < \"VALUE-0\" || value < \"VALUE-1\"";
        Assert.assertEquals((Object)expected, (Object)retrieved.getConstraintsAsString());
    }

    @Test
    public void getXORConstraintEntryFromSimplePredicates() {
        ArrayList<SimplePredicate> predicates = new ArrayList<SimplePredicate>(simplePredicates);
        List retrieved = KiePMMLASTFactoryUtils.getXORConstraintEntryFromSimplePredicates(predicates, fieldTypeMap);
        Assert.assertNotNull((Object)retrieved);
        Assert.assertEquals((long)simplePredicates.size(), (long)retrieved.size());
        this.commonVerifyKiePMMLFieldOperatorValueList(retrieved, null);
    }

    @Test
    public void getCorrectlyFormattedObject() {
        simplePredicates.forEach(simplePredicate -> {
            Object retrieved = KiePMMLASTFactoryUtils.getCorrectlyFormattedObject((SimplePredicate)simplePredicate, fieldTypeMap);
            Object expected = simplePredicate.getValue();
            if (expected instanceof String) {
                expected = String.format("\"%s\"", expected);
            }
            Assert.assertEquals((Object)expected, (Object)retrieved);
        });
    }

    @Test
    public void populateKiePMMLFieldOperatorValueListWithSimplePredicatesWithAnd() {
        this.commonPopulateKiePMMLFieldOperatorValueListWithSimplePredicates(CompoundPredicate.BooleanOperator.AND, BOOLEAN_OPERATOR.AND);
    }

    @Test
    public void populateKiePMMLFieldOperatorValueListWithSimplePredicatesWithOr() {
        this.commonPopulateKiePMMLFieldOperatorValueListWithSimplePredicates(CompoundPredicate.BooleanOperator.OR, BOOLEAN_OPERATOR.OR);
    }

    @Test
    public void populateKiePMMLFieldOperatorValueListWithCompoundPredicates() {
        ArrayList toPopulate = new ArrayList();
        KiePMMLASTFactoryUtils.populateKiePMMLFieldOperatorValueListWithCompoundPredicates(toPopulate, KiePMMLASTFactoryUtilsTest.compoundPredicates, fieldTypeMap);
        Assert.assertFalse((boolean)toPopulate.isEmpty());
        Assert.assertEquals((long)2L, (long)toPopulate.size());
        Map<CompoundPredicate.BooleanOperator, List<CompoundPredicate>> partitionedCompoundPredicates = KiePMMLASTFactoryUtilsTest.compoundPredicates.stream().collect(Collectors.groupingBy(CompoundPredicate::getBooleanOperator));
        partitionedCompoundPredicates.forEach((booleanOperator, compoundPredicates) -> {
            KiePMMLFieldOperatorValue operatorValue = toPopulate.stream().filter(kiePMMLFieldOperatorValue -> kiePMMLFieldOperatorValue.getOperator().equals((Object)BOOLEAN_OPERATOR.byName((String)booleanOperator.value()))).findFirst().orElseThrow(() -> new RuntimeException("Failed toRetrieve KiePMMLFieldOperatorValue for BooleanOperator " + booleanOperator));
            List nestedKiePMMLFieldOperatorValues = operatorValue.getNestedKiePMMLFieldOperatorValues();
            final List nestedPredicates = compoundPredicates.stream().flatMap(compoundPredicate -> compoundPredicate.getPredicates().stream()).collect(Collectors.toList());
            Assert.assertEquals((long)nestedPredicates.size(), (long)nestedKiePMMLFieldOperatorValues.size());
            nestedKiePMMLFieldOperatorValues.forEach(new Consumer<KiePMMLFieldOperatorValue>(){

                @Override
                public void accept(KiePMMLFieldOperatorValue kiePMMLFieldOperatorValue) {
                    Assert.assertEquals((long)1L, (long)kiePMMLFieldOperatorValue.getKiePMMLOperatorValues().size());
                    KiePMMLOperatorValue kiePMMLOperatorValue = (KiePMMLOperatorValue)kiePMMLFieldOperatorValue.getKiePMMLOperatorValues().get(0);
                    SimplePredicate simplePredicate = nestedPredicates.stream().map(predicate -> (SimplePredicate)predicate).filter(predicate -> predicate.getField().getValue().equals(KiePMMLASTFactoryUtilsTest.this.getOriginalPredicateName(kiePMMLFieldOperatorValue.getName()))).findFirst().orElseThrow(() -> new RuntimeException("Failed to find SimplePredicate for " + kiePMMLFieldOperatorValue.getName()));
                    KiePMMLASTFactoryUtilsTest.this.commonVerifyKiePMMLOperatorValue(kiePMMLOperatorValue, simplePredicate);
                    nestedPredicates.remove(simplePredicate);
                }
            });
            Assert.assertTrue((boolean)nestedPredicates.isEmpty());
        });
    }

    private void commonPopulateKiePMMLFieldOperatorValueListWithSimplePredicates(CompoundPredicate.BooleanOperator compoundBooleanOperator, BOOLEAN_OPERATOR booleanOperator) {
        Map<String, List<SimplePredicate>> predicatesByField = simplePredicates.stream().collect(Collectors.groupingBy(child -> fieldTypeMap.get(child.getField().getValue()).getGeneratedType()));
        ArrayList<KiePMMLFieldOperatorValue> toPopulate = new ArrayList<KiePMMLFieldOperatorValue>();
        KiePMMLASTFactoryUtils.populateKiePMMLFieldOperatorValueListWithSimplePredicates(toPopulate, (CompoundPredicate.BooleanOperator)compoundBooleanOperator, predicatesByField, fieldTypeMap);
        Assert.assertEquals((long)simplePredicates.size(), (long)toPopulate.size());
        this.commonVerifyKiePMMLFieldOperatorValueList(toPopulate, booleanOperator);
    }

    private void commonVerifyKiePMMLFieldOperatorValueList(List<KiePMMLFieldOperatorValue> toVerify, BOOLEAN_OPERATOR booleanOperator) {
        toVerify.forEach(kiePMMLFieldOperatorValue -> {
            Assert.assertEquals((Object)booleanOperator, (Object)kiePMMLFieldOperatorValue.getOperator());
            this.commonVerifyKiePMMLFieldOperatorValue((KiePMMLFieldOperatorValue)kiePMMLFieldOperatorValue);
        });
    }

    private void commonVerifyKiePMMLFieldOperatorValue(KiePMMLFieldOperatorValue toVerify) {
        SimplePredicate simplePredicate = this.getSimplePredicate(toVerify.getName());
        this.commonVerifyKiePMMLFieldOperatorValue(toVerify, simplePredicate);
    }

    private void commonVerifyKiePMMLFieldOperatorValue(KiePMMLFieldOperatorValue toVerify, SimplePredicate simplePredicate) {
        Assert.assertEquals((long)1L, (long)toVerify.getKiePMMLOperatorValues().size());
        KiePMMLOperatorValue kiePMMLOperatorValue = (KiePMMLOperatorValue)toVerify.getKiePMMLOperatorValues().get(0);
        this.commonVerifyKiePMMLOperatorValue(kiePMMLOperatorValue, simplePredicate);
        Object expectedValue = simplePredicate.getValue();
        if (expectedValue instanceof String) {
            expectedValue = String.format("\"%s\"", expectedValue);
        }
        String expectedOperator = OPERATOR.byName((String)simplePredicate.getOperator().value()).getOperator();
        String expected = String.format("value %s %s", expectedOperator, expectedValue);
        Assert.assertEquals((Object)expected, (Object)toVerify.getConstraintsAsString());
    }

    private void commonVerifyKiePMMLOperatorValue(KiePMMLOperatorValue toVerify, SimplePredicate simplePredicate) {
        Assert.assertNotNull((Object)toVerify.getOperator());
        Object expectedValue = simplePredicate.getValue();
        if (expectedValue instanceof String) {
            expectedValue = String.format("\"%s\"", expectedValue);
        }
        Assert.assertEquals((Object)expectedValue, (Object)toVerify.getValue());
    }

    private SimplePredicate getSimplePredicate(String generatedType) {
        String predicateName = this.getOriginalPredicateName(generatedType);
        return simplePredicates.stream().filter(simplePredicate -> simplePredicate.getField().getValue().equals(predicateName)).findFirst().orElseThrow(() -> new RuntimeException("Failed to find SimplePredicate for " + predicateName));
    }

    private String getOriginalPredicateName(String generatedType) {
        return fieldTypeMap.entrySet().stream().filter(entry -> ((KiePMMLOriginalTypeGeneratedType)entry.getValue()).getGeneratedType().equals(generatedType)).findFirst().map(Map.Entry::getKey).orElseThrow(() -> new RuntimeException("Failed to find original type for " + generatedType));
    }
}

