/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.models.drools.commons.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.pmml.api.exceptions.KiePMMLException;
import org.kie.pmml.commons.model.KiePMMLExtension;
import org.kie.pmml.commons.utils.KiePMMLModelUtils;
import org.kie.pmml.models.drools.commons.model.KiePMMLDroolsModel;
import org.kie.pmml.models.drools.tuples.KiePMMLOriginalTypeGeneratedType;

public class KiePMMLDroolsModelTest {
    private static final String MODEL_NAME = "MODELNAME";
    private static final List<KiePMMLExtension> EXTENSIONS = new ArrayList<KiePMMLExtension>();
    private KiePMMLDroolsModel kiePMMLDroolsModel;

    @Before
    public void setup() {
        this.kiePMMLDroolsModel = new KiePMMLDroolsModelFake(MODEL_NAME, EXTENSIONS);
    }

    @Test
    public void constructor() {
        Assert.assertEquals((Object)MODEL_NAME, (Object)this.kiePMMLDroolsModel.getName());
        Assert.assertEquals(EXTENSIONS, (Object)this.kiePMMLDroolsModel.getExtensions());
        Assert.assertEquals((Object)KiePMMLModelUtils.getSanitizedPackageName((String)MODEL_NAME), (Object)this.kiePMMLDroolsModel.getKModulePackageName());
    }

    @Test(expected=KiePMMLException.class)
    public void evaluateNoKieBase() {
        this.kiePMMLDroolsModel.evaluate((Object)"NOT_KIE_BASE", new HashMap());
    }

    private final class KiePMMLDroolsModelFake
    extends KiePMMLDroolsModel {
        protected KiePMMLDroolsModelFake(String modelName, List<KiePMMLExtension> extensions) {
            super(modelName, extensions);
        }

        public Map<String, KiePMMLOriginalTypeGeneratedType> getFieldTypeMap() {
            return super.getFieldTypeMap();
        }

        public Object evaluate(Object knowledgeBase, Map<String, Object> requestData) {
            return super.evaluate(knowledgeBase, requestData);
        }

        public String getKModulePackageName() {
            return super.getKModulePackageName();
        }
    }
}

