/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.models.drools.ast.factories;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.assertj.core.api.Assertions;
import org.dmg.pmml.DataType;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.FieldName;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.pmml.api.enums.DATA_TYPE;
import org.kie.pmml.commons.utils.KiePMMLModelUtils;
import org.kie.pmml.models.drools.ast.KiePMMLDroolsType;
import org.kie.pmml.models.drools.ast.factories.KiePMMLDerivedFieldASTFactory;
import org.kie.pmml.models.drools.tuples.KiePMMLOriginalTypeGeneratedType;

public class KiePMMLDerivedFieldASTFactoryTest {
    private Map<String, KiePMMLOriginalTypeGeneratedType> fieldTypeMap;
    private KiePMMLDerivedFieldASTFactory fieldASTFactory;

    @Before
    public void setup() {
        this.fieldTypeMap = new HashMap<String, KiePMMLOriginalTypeGeneratedType>();
        this.fieldASTFactory = KiePMMLDerivedFieldASTFactory.factory(this.fieldTypeMap);
        Assertions.assertThat((Object)this.fieldASTFactory).isNotNull();
    }

    @Test
    public void declareTypes() {
        List derivedFields = IntStream.range(0, 5).mapToObj(value -> this.getDerivedField("FieldName-" + value)).collect(Collectors.toList());
        List retrieved = this.fieldASTFactory.declareTypes(derivedFields);
        Assert.assertEquals((long)derivedFields.size(), (long)retrieved.size());
        for (int i = 0; i < derivedFields.size(); ++i) {
            this.commonValidateKiePMMLDroolsType((KiePMMLDroolsType)retrieved.get(i), (DerivedField)derivedFields.get(i));
        }
    }

    @Test
    public void declareType() {
        DerivedField derivedField = this.getDerivedField("FieldName");
        KiePMMLDroolsType retrieved = this.fieldASTFactory.declareType(derivedField);
        this.commonValidateKiePMMLDroolsType(retrieved, derivedField);
    }

    private void commonValidateKiePMMLDroolsType(KiePMMLDroolsType toValidate, DerivedField derivedField) {
        String derivedFieldName = derivedField.getName().getValue();
        String expectedName = KiePMMLModelUtils.getSanitizedClassName((String)derivedFieldName.toUpperCase());
        Assert.assertEquals((Object)expectedName, (Object)toValidate.getName());
        String expectedType = DATA_TYPE.byName((String)derivedField.getDataType().value()).getMappedClass().getSimpleName();
        Assert.assertEquals((Object)expectedType, (Object)toValidate.getType());
        Assert.assertTrue((boolean)this.fieldTypeMap.containsKey(derivedFieldName));
        KiePMMLOriginalTypeGeneratedType retrieved = this.fieldTypeMap.get(derivedFieldName);
        Assert.assertEquals((Object)derivedField.getDataType().value(), (Object)retrieved.getOriginalType());
        Assert.assertEquals((Object)expectedName, (Object)retrieved.getGeneratedType());
    }

    private DerivedField getDerivedField(String fieldName) {
        DerivedField toReturn = new DerivedField();
        toReturn.setName(FieldName.create((String)fieldName));
        DATA_TYPE[] values = DATA_TYPE.values();
        int rndInt = new Random().nextInt(values.length - 1);
        DATA_TYPE dataType = values[rndInt];
        toReturn.setDataType(DataType.fromValue((String)dataType.getName()));
        return toReturn;
    }
}

