/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.models.drools.ast.factories;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.dmg.pmml.Array;
import org.dmg.pmml.Predicate;
import org.dmg.pmml.SimpleSetPredicate;
import org.junit.Test;
import org.kie.pmml.api.enums.ResultCode;
import org.kie.pmml.commons.utils.KiePMMLModelUtils;
import org.kie.pmml.compiler.api.testutils.PMMLModelTestUtils;
import org.kie.pmml.models.drools.ast.KiePMMLDroolsRule;
import org.kie.pmml.models.drools.ast.factories.KiePMMLSimpleSetPredicateASTFactory;
import org.kie.pmml.models.drools.ast.factories.PredicateASTFactoryData;
import org.kie.pmml.models.drools.tuples.KiePMMLOriginalTypeGeneratedType;
import org.kie.pmml.models.drools.utils.KiePMMLASTTestUtils;

public class KiePMMLSimpleSetPredicateASTFactoryTest {
    @Test
    public void declareRuleFromSimpleSetPredicateIsInFinalLeaf() {
        HashMap<String, KiePMMLOriginalTypeGeneratedType> fieldTypeMap = new HashMap<String, KiePMMLOriginalTypeGeneratedType>();
        List<String> values = Arrays.asList("-5", "0.5", "1", "10");
        SimpleSetPredicate simpleSetPredicate = this.getSimpleSetPredicate("input1", values, SimpleSetPredicate.BooleanOperator.IS_IN, fieldTypeMap);
        String parentPath = "_classA";
        String currentRule = "_classA_classB";
        String result = "classB";
        String declaredType = ((KiePMMLOriginalTypeGeneratedType)fieldTypeMap.get("input1")).getGeneratedType();
        ArrayList<KiePMMLDroolsRule> rules = new ArrayList<KiePMMLDroolsRule>();
        PredicateASTFactoryData predicateASTFactoryData = KiePMMLASTTestUtils.getPredicateASTFactoryData((Predicate)simpleSetPredicate, Collections.emptyList(), rules, parentPath, currentRule, fieldTypeMap);
        KiePMMLSimpleSetPredicateASTFactory.factory((PredicateASTFactoryData)predicateASTFactoryData).declareRuleFromSimpleSetPredicate((Object)result, true);
        Assertions.assertThat(rules).hasSize(1);
        KiePMMLDroolsRule retrieved = (KiePMMLDroolsRule)rules.get(0);
        Assertions.assertThat((Object)retrieved).isNotNull();
        Assertions.assertThat((String)retrieved.getName()).isEqualTo(currentRule);
        Assertions.assertThat((String)retrieved.getStatusToSet()).isEqualTo("DONE");
        Assertions.assertThat((String)retrieved.getStatusConstraint()).isEqualTo(String.format("status == \"%s\"", parentPath));
        Assertions.assertThat((Comparable)retrieved.getResultCode()).isEqualTo((Object)ResultCode.OK);
        Assertions.assertThat((Object)retrieved.getResult()).isEqualTo((Object)result);
        Assertions.assertThat((Map)retrieved.getInConstraints()).isNotNull();
        Map inConstraints = retrieved.getInConstraints();
        Assertions.assertThat((Map)inConstraints).hasSize(1);
        Assertions.assertThat((Map)inConstraints).containsKey((Object)declaredType);
        List retrievedValues = (List)inConstraints.get(declaredType);
        List<String> originalPredicateValues = Arrays.asList(((String)simpleSetPredicate.getArray().getValue()).split(" "));
        Assertions.assertThat((List)retrievedValues).hasSameSizeAs(originalPredicateValues);
        retrievedValues.forEach(retrievedValue -> Assertions.assertThat((List)originalPredicateValues).contains((Object[])new String[]{(String)retrievedValue}));
    }

    @Test
    public void declareRuleFromSimpleSetPredicateIsInNotFinalLeaf() {
        HashMap<String, KiePMMLOriginalTypeGeneratedType> fieldTypeMap = new HashMap<String, KiePMMLOriginalTypeGeneratedType>();
        List<String> values = Arrays.asList("-5", "0.5", "1", "10");
        SimpleSetPredicate simpleSetPredicate = this.getSimpleSetPredicate("input1", values, SimpleSetPredicate.BooleanOperator.IS_IN, fieldTypeMap);
        String parentPath = "_classA";
        String currentRule = "_classA_classB";
        String result = "classB";
        String declaredType = ((KiePMMLOriginalTypeGeneratedType)fieldTypeMap.get("input1")).getGeneratedType();
        ArrayList<KiePMMLDroolsRule> rules = new ArrayList<KiePMMLDroolsRule>();
        PredicateASTFactoryData predicateASTFactoryData = KiePMMLASTTestUtils.getPredicateASTFactoryData((Predicate)simpleSetPredicate, Collections.emptyList(), rules, parentPath, currentRule, fieldTypeMap);
        KiePMMLSimpleSetPredicateASTFactory.factory((PredicateASTFactoryData)predicateASTFactoryData).declareRuleFromSimpleSetPredicate((Object)result, false);
        Assertions.assertThat(rules).hasSize(1);
        KiePMMLDroolsRule retrieved = (KiePMMLDroolsRule)rules.get(0);
        Assertions.assertThat((Object)retrieved).isNotNull();
        Assertions.assertThat((String)retrieved.getName()).isEqualTo(currentRule);
        Assertions.assertThat((String)retrieved.getStatusToSet()).isEqualTo(currentRule);
        Assertions.assertThat((String)retrieved.getStatusConstraint()).isEqualTo(String.format("status == \"%s\"", parentPath));
        Assertions.assertThat((Comparable)retrieved.getResultCode()).isNull();
        Assertions.assertThat((Object)retrieved.getResult()).isNull();
        Assertions.assertThat((Map)retrieved.getInConstraints()).isNotNull();
        Map inConstraints = retrieved.getInConstraints();
        Assertions.assertThat((Map)inConstraints).hasSize(1);
        Assertions.assertThat((Map)inConstraints).containsKey((Object)declaredType);
        List retrievedValues = (List)inConstraints.get(declaredType);
        List<String> originalPredicateValues = Arrays.asList(((String)simpleSetPredicate.getArray().getValue()).split(" "));
        Assertions.assertThat((List)retrievedValues).hasSameSizeAs(originalPredicateValues);
        retrievedValues.forEach(retrievedValue -> Assertions.assertThat((List)originalPredicateValues).contains((Object[])new String[]{(String)retrievedValue}));
    }

    @Test
    public void declareRuleFromSimpleSetPredicateIsNotInFinalLeaf() {
        HashMap<String, KiePMMLOriginalTypeGeneratedType> fieldTypeMap = new HashMap<String, KiePMMLOriginalTypeGeneratedType>();
        List<String> values = Arrays.asList("3", "8.5");
        SimpleSetPredicate simpleSetPredicate = this.getSimpleSetPredicate("input2", values, SimpleSetPredicate.BooleanOperator.IS_NOT_IN, fieldTypeMap);
        String parentPath = "_classA";
        String currentRule = "_classA_classC";
        String result = "classC";
        String declaredType = ((KiePMMLOriginalTypeGeneratedType)fieldTypeMap.get("input2")).getGeneratedType();
        ArrayList<KiePMMLDroolsRule> rules = new ArrayList<KiePMMLDroolsRule>();
        String statusToSet = "DONE";
        PredicateASTFactoryData predicateASTFactoryData = KiePMMLASTTestUtils.getPredicateASTFactoryData((Predicate)simpleSetPredicate, Collections.emptyList(), rules, parentPath, currentRule, fieldTypeMap);
        KiePMMLSimpleSetPredicateASTFactory.factory((PredicateASTFactoryData)predicateASTFactoryData).declareRuleFromSimpleSetPredicate((Object)result, true);
        Assertions.assertThat(rules).hasSize(1);
        KiePMMLDroolsRule retrieved = (KiePMMLDroolsRule)rules.get(0);
        Assertions.assertThat((Object)retrieved).isNotNull();
        Assertions.assertThat((String)retrieved.getName()).isEqualTo(currentRule);
        Assertions.assertThat((String)retrieved.getStatusToSet()).isEqualTo(statusToSet);
        Assertions.assertThat((String)retrieved.getStatusConstraint()).isEqualTo(String.format("status == \"%s\"", parentPath));
        Assertions.assertThat((Comparable)retrieved.getResultCode()).isEqualTo((Object)ResultCode.OK);
        Assertions.assertThat((Object)retrieved.getResult()).isEqualTo((Object)result);
        Assertions.assertThat((Map)retrieved.getNotInConstraints()).isNotNull();
        Map notInConstraints = retrieved.getNotInConstraints();
        Assertions.assertThat((Map)notInConstraints).hasSize(1);
        Assertions.assertThat((Map)notInConstraints).containsKey((Object)declaredType);
        List retrievedValues = (List)notInConstraints.get(declaredType);
        List<String> originalPredicateValues = Arrays.asList(((String)simpleSetPredicate.getArray().getValue()).split(" "));
        Assertions.assertThat((List)retrievedValues).hasSameSizeAs(originalPredicateValues);
        retrievedValues.forEach(retrievedValue -> Assertions.assertThat((List)originalPredicateValues).contains((Object[])new String[]{(String)retrievedValue}));
    }

    @Test
    public void declareRuleFromSimpleSetPredicateIsNotInNotFinalLeaf() {
        HashMap<String, KiePMMLOriginalTypeGeneratedType> fieldTypeMap = new HashMap<String, KiePMMLOriginalTypeGeneratedType>();
        List<String> values = Arrays.asList("3", "8.5");
        SimpleSetPredicate simpleSetPredicate = this.getSimpleSetPredicate("input2", values, SimpleSetPredicate.BooleanOperator.IS_NOT_IN, fieldTypeMap);
        String parentPath = "_classA";
        String currentRule = "_classA_classC";
        String result = "classC";
        String declaredType = ((KiePMMLOriginalTypeGeneratedType)fieldTypeMap.get("input2")).getGeneratedType();
        ArrayList<KiePMMLDroolsRule> rules = new ArrayList<KiePMMLDroolsRule>();
        PredicateASTFactoryData predicateASTFactoryData = KiePMMLASTTestUtils.getPredicateASTFactoryData((Predicate)simpleSetPredicate, Collections.emptyList(), rules, parentPath, currentRule, fieldTypeMap);
        KiePMMLSimpleSetPredicateASTFactory.factory((PredicateASTFactoryData)predicateASTFactoryData).declareRuleFromSimpleSetPredicate((Object)result, false);
        Assertions.assertThat(rules).hasSize(1);
        KiePMMLDroolsRule retrieved = (KiePMMLDroolsRule)rules.get(0);
        Assertions.assertThat((Object)retrieved).isNotNull();
        Assertions.assertThat((String)retrieved.getName()).isEqualTo(currentRule);
        Assertions.assertThat((String)retrieved.getStatusToSet()).isEqualTo(currentRule);
        Assertions.assertThat((String)retrieved.getStatusConstraint()).isEqualTo(String.format("status == \"%s\"", parentPath));
        Assertions.assertThat((Comparable)retrieved.getResultCode()).isNull();
        Assertions.assertThat((Object)retrieved.getResult()).isNull();
        Assertions.assertThat((Map)retrieved.getNotInConstraints()).isNotNull();
        Map notInConstraints = retrieved.getNotInConstraints();
        Assertions.assertThat((Map)notInConstraints).hasSize(1);
        Assertions.assertThat((Map)notInConstraints).containsKey((Object)declaredType);
        List retrievedValues = (List)notInConstraints.get(declaredType);
        List<String> originalPredicateValues = Arrays.asList(((String)simpleSetPredicate.getArray().getValue()).split(" "));
        Assertions.assertThat((List)retrievedValues).hasSameSizeAs(originalPredicateValues);
        retrievedValues.forEach(retrievedValue -> Assertions.assertThat((List)originalPredicateValues).contains((Object[])new String[]{(String)retrievedValue}));
    }

    private SimpleSetPredicate getSimpleSetPredicate(String predicateName, List<String> values, SimpleSetPredicate.BooleanOperator booleanOperator, Map<String, KiePMMLOriginalTypeGeneratedType> fieldTypeMap) {
        fieldTypeMap.put(predicateName, new KiePMMLOriginalTypeGeneratedType(Array.Type.REAL.value(), KiePMMLModelUtils.getSanitizedClassName((String)predicateName.toUpperCase())));
        return PMMLModelTestUtils.getSimpleSetPredicate((String)predicateName, (Array.Type)Array.Type.REAL, values, (SimpleSetPredicate.BooleanOperator)booleanOperator);
    }
}

