/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.models.drools.ast;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.pmml.api.enums.BOOLEAN_OPERATOR;
import org.kie.pmml.api.enums.OPERATOR;
import org.kie.pmml.models.drools.ast.KiePMMLFieldOperatorValue;
import org.kie.pmml.models.drools.tuples.KiePMMLOperatorValue;

public class KiePMMLFieldOperatorValueTest {
    private static final String NAME = "NAME";
    private static final BOOLEAN_OPERATOR BOOLEANOPERATOR = BOOLEAN_OPERATOR.SURROGATE;

    @Test
    void getConstraintsAsString() {
        KiePMMLFieldOperatorValue kiePMMLFieldOperatorValue = this.getKiePMMLFieldOperatorValueWithName();
        String expected = "value < 35 surrogate value > 85";
        String retrieved = kiePMMLFieldOperatorValue.getConstraintsAsString();
        Assertions.assertThat((String)retrieved).isEqualTo(expected);
        kiePMMLFieldOperatorValue = this.getKiePMMLFieldOperatorValueWithoutName();
        expected = "value < 35 surrogate value > 85";
        retrieved = kiePMMLFieldOperatorValue.buildConstraintsString();
        Assertions.assertThat((String)retrieved).isEqualTo(expected);
    }

    @Test
    void buildConstraintsString() {
        KiePMMLFieldOperatorValue kiePMMLFieldOperatorValue = this.getKiePMMLFieldOperatorValueWithName();
        String expected = "value < 35 surrogate value > 85";
        String retrieved = kiePMMLFieldOperatorValue.buildConstraintsString();
        Assertions.assertThat((String)retrieved).isEqualTo(expected);
        kiePMMLFieldOperatorValue = this.getKiePMMLFieldOperatorValueWithoutName();
        expected = "value < 35 surrogate value > 85";
        retrieved = kiePMMLFieldOperatorValue.buildConstraintsString();
        Assertions.assertThat((String)retrieved).isEqualTo(expected);
    }

    private KiePMMLFieldOperatorValue getKiePMMLFieldOperatorValueWithName() {
        List<KiePMMLOperatorValue> kiePMMLOperatorValues = Arrays.asList(new KiePMMLOperatorValue(OPERATOR.LESS_THAN, (Object)35), new KiePMMLOperatorValue(OPERATOR.GREATER_THAN, (Object)85));
        return new KiePMMLFieldOperatorValue(NAME, BOOLEANOPERATOR, kiePMMLOperatorValues, Collections.emptyList());
    }

    private KiePMMLFieldOperatorValue getKiePMMLFieldOperatorValueWithoutName() {
        String humidityField = "HUMIDITY";
        List<KiePMMLFieldOperatorValue> nestedKiePMMLFieldOperatorValues = Arrays.asList(new KiePMMLFieldOperatorValue(humidityField, BOOLEAN_OPERATOR.OR, Collections.singletonList(new KiePMMLOperatorValue(OPERATOR.LESS_THAN, (Object)56)), null), new KiePMMLFieldOperatorValue(humidityField, BOOLEAN_OPERATOR.OR, Collections.singletonList(new KiePMMLOperatorValue(OPERATOR.GREATER_THAN, (Object)91)), null));
        List<KiePMMLOperatorValue> kiePMMLOperatorValues = Arrays.asList(new KiePMMLOperatorValue(OPERATOR.LESS_THAN, (Object)35), new KiePMMLOperatorValue(OPERATOR.GREATER_THAN, (Object)85));
        return new KiePMMLFieldOperatorValue(null, BOOLEANOPERATOR, kiePMMLOperatorValues, nestedKiePMMLFieldOperatorValues);
    }
}

