/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.models.drools.ast.factories;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.dmg.pmml.DataType;
import org.dmg.pmml.Predicate;
import org.dmg.pmml.SimplePredicate;
import org.junit.jupiter.api.Test;
import org.kie.pmml.api.enums.BOOLEAN_OPERATOR;
import org.kie.pmml.api.enums.ResultCode;
import org.kie.pmml.commons.utils.KiePMMLModelUtils;
import org.kie.pmml.compiler.api.testutils.PMMLModelTestUtils;
import org.kie.pmml.models.drools.ast.KiePMMLDroolsRule;
import org.kie.pmml.models.drools.ast.KiePMMLFieldOperatorValue;
import org.kie.pmml.models.drools.ast.factories.KiePMMLSimplePredicateASTFactory;
import org.kie.pmml.models.drools.ast.factories.PredicateASTFactoryData;
import org.kie.pmml.models.drools.tuples.KiePMMLOriginalTypeGeneratedType;
import org.kie.pmml.models.drools.utils.KiePMMLASTTestUtils;

public class KiePMMLSimplePredicateASTFactoryTest {
    @Test
    void declareRuleFromSimplePredicateSurrogateFinalLeaf() {
        HashMap<String, KiePMMLOriginalTypeGeneratedType> fieldTypeMap = new HashMap<String, KiePMMLOriginalTypeGeneratedType>();
        SimplePredicate simplePredicate = this.getSimplePredicate("outlook", "VALUE", SimplePredicate.Operator.LESS_THAN, fieldTypeMap);
        String currentRule = "_will play_will play";
        String agendaActivationGroup = "_will play_will play Group";
        String result = "RESULT";
        String parentPath = "parentPath";
        ArrayList<KiePMMLDroolsRule> rules = new ArrayList<KiePMMLDroolsRule>();
        PredicateASTFactoryData predicateASTFactoryData = KiePMMLASTTestUtils.getPredicateASTFactoryData((Predicate)simplePredicate, Collections.emptyList(), rules, parentPath, currentRule, fieldTypeMap);
        KiePMMLSimplePredicateASTFactory.factory((PredicateASTFactoryData)predicateASTFactoryData).declareRuleFromSimplePredicateSurrogate(agendaActivationGroup, (Object)result, true);
        Assertions.assertThat(rules).hasSize(2);
        KiePMMLDroolsRule retrieved = (KiePMMLDroolsRule)rules.get(0);
        Assertions.assertThat((Object)retrieved).isNotNull();
        String baseExpectedRule = String.format("%s_surrogate_%s", currentRule, ((KiePMMLOriginalTypeGeneratedType)fieldTypeMap.get(simplePredicate.getField())).getGeneratedType());
        String expectedRule = baseExpectedRule + "_TRUE";
        Assertions.assertThat((String)retrieved.getName()).isEqualTo(expectedRule);
        Assertions.assertThat((String)retrieved.getStatusToSet()).isEqualTo("DONE");
        Assertions.assertThat((String)retrieved.getStatusConstraint()).isNull();
        Assertions.assertThat((String)retrieved.getAgendaGroup()).isEqualTo(agendaActivationGroup);
        Assertions.assertThat((String)retrieved.getActivationGroup()).isEqualTo(agendaActivationGroup);
        Assertions.assertThat((String)retrieved.getIfBreakField()).isNull();
        Assertions.assertThat((String)retrieved.getIfBreakOperator()).isNull();
        Assertions.assertThat((Object)retrieved.getIfBreakValue()).isNull();
        Assertions.assertThat((List)retrieved.getNotConstraints()).isNull();
        Assertions.assertThat((List)retrieved.getAndConstraints()).isNotNull();
        Assertions.assertThat((List)retrieved.getAndConstraints()).hasSize(1);
        KiePMMLFieldOperatorValue kiePMMLFieldOperatorValue = (KiePMMLFieldOperatorValue)retrieved.getAndConstraints().get(0);
        Assertions.assertThat((String)kiePMMLFieldOperatorValue.getName()).isEqualTo("OUTLOOK");
        Assertions.assertThat((Comparable)kiePMMLFieldOperatorValue.getOperator()).isEqualTo((Object)BOOLEAN_OPERATOR.SURROGATE);
        Assertions.assertThat((String)kiePMMLFieldOperatorValue.getConstraintsAsString()).isEqualTo("value < \"VALUE\"");
        Assertions.assertThat((Object)retrieved.getResult()).isEqualTo((Object)result);
        Assertions.assertThat((Comparable)retrieved.getResultCode()).isEqualTo((Object)ResultCode.OK);
        retrieved = (KiePMMLDroolsRule)rules.get(1);
        Assertions.assertThat((Object)retrieved).isNotNull();
        expectedRule = baseExpectedRule + "_FALSE";
        Assertions.assertThat((String)retrieved.getName()).isEqualTo(expectedRule);
        Assertions.assertThat((String)retrieved.getStatusToSet()).isEqualTo(parentPath);
        Assertions.assertThat((String)retrieved.getStatusConstraint()).isNull();
        Assertions.assertThat((String)retrieved.getAgendaGroup()).isEqualTo(agendaActivationGroup);
        Assertions.assertThat((String)retrieved.getActivationGroup()).isEqualTo(agendaActivationGroup);
        Assertions.assertThat((String)retrieved.getIfBreakField()).isNull();
        Assertions.assertThat((String)retrieved.getIfBreakOperator()).isNull();
        Assertions.assertThat((Object)retrieved.getIfBreakValue()).isNull();
        Assertions.assertThat((List)retrieved.getAndConstraints()).isNull();
        Assertions.assertThat((List)retrieved.getNotConstraints()).isNotNull();
        Assertions.assertThat((List)retrieved.getNotConstraints()).hasSize(1);
        kiePMMLFieldOperatorValue = (KiePMMLFieldOperatorValue)retrieved.getNotConstraints().get(0);
        Assertions.assertThat((String)kiePMMLFieldOperatorValue.getName()).isEqualTo("OUTLOOK");
        Assertions.assertThat((Comparable)kiePMMLFieldOperatorValue.getOperator()).isEqualTo((Object)BOOLEAN_OPERATOR.SURROGATE);
        Assertions.assertThat((String)kiePMMLFieldOperatorValue.getConstraintsAsString()).isEqualTo("value < \"VALUE\"");
        Assertions.assertThat((Object)retrieved.getResult()).isNull();
        Assertions.assertThat((Comparable)retrieved.getResultCode()).isNull();
    }

    @Test
    void declareRuleFromSimplePredicateSurrogateNotFinalLeaf() {
        HashMap<String, KiePMMLOriginalTypeGeneratedType> fieldTypeMap = new HashMap<String, KiePMMLOriginalTypeGeneratedType>();
        SimplePredicate simplePredicate = this.getSimplePredicate("outlook", "VALUE", SimplePredicate.Operator.LESS_THAN, fieldTypeMap);
        String currentRule = "_will play_will play";
        String agendaActivationGroup = "_will play_will play Group";
        String result = "RESULT";
        String parentPath = "parentPath";
        ArrayList<KiePMMLDroolsRule> rules = new ArrayList<KiePMMLDroolsRule>();
        PredicateASTFactoryData predicateASTFactoryData = KiePMMLASTTestUtils.getPredicateASTFactoryData((Predicate)simplePredicate, Collections.emptyList(), rules, parentPath, currentRule, fieldTypeMap);
        KiePMMLSimplePredicateASTFactory.factory((PredicateASTFactoryData)predicateASTFactoryData).declareRuleFromSimplePredicateSurrogate(agendaActivationGroup, (Object)result, false);
        Assertions.assertThat(rules).hasSize(2);
        KiePMMLDroolsRule retrieved = (KiePMMLDroolsRule)rules.get(0);
        Assertions.assertThat((Object)retrieved).isNotNull();
        String baseExpectedRule = String.format("%s_surrogate_%s", currentRule, ((KiePMMLOriginalTypeGeneratedType)fieldTypeMap.get(simplePredicate.getField())).getGeneratedType());
        String expectedRule = baseExpectedRule + "_TRUE";
        Assertions.assertThat((String)retrieved.getName()).isEqualTo(expectedRule);
        Assertions.assertThat((String)retrieved.getStatusToSet()).isEqualTo(currentRule);
        Assertions.assertThat((String)retrieved.getStatusConstraint()).isNull();
        Assertions.assertThat((String)retrieved.getAgendaGroup()).isEqualTo(agendaActivationGroup);
        Assertions.assertThat((String)retrieved.getActivationGroup()).isEqualTo(agendaActivationGroup);
        Assertions.assertThat((String)retrieved.getIfBreakField()).isNull();
        Assertions.assertThat((String)retrieved.getIfBreakOperator()).isNull();
        Assertions.assertThat((Object)retrieved.getIfBreakValue()).isNull();
        Assertions.assertThat((List)retrieved.getAndConstraints()).isNotNull();
        Assertions.assertThat((List)retrieved.getAndConstraints()).hasSize(1);
        KiePMMLFieldOperatorValue kiePMMLFieldOperatorValue = (KiePMMLFieldOperatorValue)retrieved.getAndConstraints().get(0);
        Assertions.assertThat((String)kiePMMLFieldOperatorValue.getName()).isEqualTo("OUTLOOK");
        Assertions.assertThat((Comparable)kiePMMLFieldOperatorValue.getOperator()).isEqualTo((Object)BOOLEAN_OPERATOR.SURROGATE);
        Assertions.assertThat((String)kiePMMLFieldOperatorValue.getConstraintsAsString()).isEqualTo("value < \"VALUE\"");
        Assertions.assertThat((Object)retrieved.getResult()).isNull();
        Assertions.assertThat((Comparable)retrieved.getResultCode()).isNull();
        retrieved = (KiePMMLDroolsRule)rules.get(1);
        Assertions.assertThat((Object)retrieved).isNotNull();
        expectedRule = baseExpectedRule + "_FALSE";
        Assertions.assertThat((String)retrieved.getName()).isEqualTo(expectedRule);
        Assertions.assertThat((String)retrieved.getStatusToSet()).isEqualTo(parentPath);
        Assertions.assertThat((String)retrieved.getStatusConstraint()).isNull();
        Assertions.assertThat((String)retrieved.getAgendaGroup()).isEqualTo(agendaActivationGroup);
        Assertions.assertThat((String)retrieved.getActivationGroup()).isEqualTo(agendaActivationGroup);
        Assertions.assertThat((String)retrieved.getIfBreakField()).isNull();
        Assertions.assertThat((String)retrieved.getIfBreakOperator()).isNull();
        Assertions.assertThat((Object)retrieved.getIfBreakValue()).isNull();
        Assertions.assertThat((List)retrieved.getAndConstraints()).isNull();
        Assertions.assertThat((List)retrieved.getNotConstraints()).isNotNull();
        Assertions.assertThat((List)retrieved.getNotConstraints()).hasSize(1);
        kiePMMLFieldOperatorValue = (KiePMMLFieldOperatorValue)retrieved.getNotConstraints().get(0);
        Assertions.assertThat((String)kiePMMLFieldOperatorValue.getName()).isEqualTo("OUTLOOK");
        Assertions.assertThat((Comparable)kiePMMLFieldOperatorValue.getOperator()).isEqualTo((Object)BOOLEAN_OPERATOR.SURROGATE);
        Assertions.assertThat((String)kiePMMLFieldOperatorValue.getConstraintsAsString()).isEqualTo("value < \"VALUE\"");
        Assertions.assertThat((Object)retrieved.getResult()).isNull();
        Assertions.assertThat((Comparable)retrieved.getResultCode()).isNull();
    }

    @Test
    void declareRuleFromSimplePredicateFinalLeaf() {
        HashMap<String, KiePMMLOriginalTypeGeneratedType> fieldTypeMap = new HashMap<String, KiePMMLOriginalTypeGeneratedType>();
        SimplePredicate simplePredicate = this.getSimplePredicate("outlook", "VALUE", SimplePredicate.Operator.LESS_THAN, fieldTypeMap);
        String parentPath = "_will play";
        String currentRule = "_will play_will play";
        String declaredType = ((KiePMMLOriginalTypeGeneratedType)fieldTypeMap.get("outlook")).getGeneratedType();
        String result = "RESULT";
        ArrayList<KiePMMLDroolsRule> rules = new ArrayList<KiePMMLDroolsRule>();
        PredicateASTFactoryData predicateASTFactoryData = KiePMMLASTTestUtils.getPredicateASTFactoryData((Predicate)simplePredicate, Collections.emptyList(), rules, parentPath, currentRule, fieldTypeMap);
        KiePMMLSimplePredicateASTFactory.factory((PredicateASTFactoryData)predicateASTFactoryData).declareRuleFromSimplePredicate((Object)result, true);
        Assertions.assertThat(rules).hasSize(1);
        KiePMMLDroolsRule retrieved = (KiePMMLDroolsRule)rules.get(0);
        Assertions.assertThat((Object)retrieved).isNotNull();
        Assertions.assertThat((String)retrieved.getName()).isEqualTo(currentRule);
        Assertions.assertThat((String)retrieved.getStatusToSet()).isEqualTo("DONE");
        Assertions.assertThat((String)retrieved.getStatusConstraint()).isEqualTo(String.format("status == \"%s\"", parentPath));
        Assertions.assertThat((Comparable)retrieved.getResultCode()).isEqualTo((Object)ResultCode.OK);
        Assertions.assertThat((Object)retrieved.getResult()).isEqualTo((Object)result);
        List andConstraints = retrieved.getAndConstraints();
        Assertions.assertThat((List)andConstraints).isNotNull();
        Assertions.assertThat((List)andConstraints).hasSize(1);
        KiePMMLFieldOperatorValue kiePMMLFieldOperatorValue = (KiePMMLFieldOperatorValue)retrieved.getAndConstraints().get(0);
        Assertions.assertThat((String)kiePMMLFieldOperatorValue.getName()).isEqualTo(declaredType);
        Assertions.assertThat((Comparable)kiePMMLFieldOperatorValue.getOperator()).isEqualTo((Object)BOOLEAN_OPERATOR.AND);
        String expectedValue = "value < \"" + simplePredicate.getValue() + "\"";
        Assertions.assertThat((String)kiePMMLFieldOperatorValue.getConstraintsAsString()).isEqualTo(expectedValue);
    }

    @Test
    void declareIntermediateRuleFromSimplePredicateNotFinalLeaf() {
        HashMap<String, KiePMMLOriginalTypeGeneratedType> fieldTypeMap = new HashMap<String, KiePMMLOriginalTypeGeneratedType>();
        SimplePredicate simplePredicate = this.getSimplePredicate("outlook", "VALUE", SimplePredicate.Operator.LESS_THAN, fieldTypeMap);
        String parentPath = "_will play";
        String currentRule = "_will play_will play";
        String declaredType = ((KiePMMLOriginalTypeGeneratedType)fieldTypeMap.get("outlook")).getGeneratedType();
        String result = "RESULT";
        ArrayList<KiePMMLDroolsRule> rules = new ArrayList<KiePMMLDroolsRule>();
        PredicateASTFactoryData predicateASTFactoryData = KiePMMLASTTestUtils.getPredicateASTFactoryData((Predicate)simplePredicate, Collections.emptyList(), rules, parentPath, currentRule, fieldTypeMap);
        KiePMMLSimplePredicateASTFactory.factory((PredicateASTFactoryData)predicateASTFactoryData).declareRuleFromSimplePredicate((Object)result, false);
        Assertions.assertThat(rules).hasSize(1);
        KiePMMLDroolsRule retrieved = (KiePMMLDroolsRule)rules.get(0);
        Assertions.assertThat((Object)retrieved).isNotNull();
        Assertions.assertThat((String)retrieved.getName()).isEqualTo(currentRule);
        Assertions.assertThat((String)retrieved.getStatusToSet()).isEqualTo(currentRule);
        Assertions.assertThat((String)retrieved.getStatusConstraint()).isEqualTo(String.format("status == \"%s\"", parentPath));
        Assertions.assertThat((String)retrieved.getStatusToSet()).isEqualTo(currentRule);
        List andConstraints = retrieved.getAndConstraints();
        Assertions.assertThat((List)andConstraints).isNotNull();
        Assertions.assertThat((List)andConstraints).hasSize(1);
        KiePMMLFieldOperatorValue kiePMMLFieldOperatorValue = (KiePMMLFieldOperatorValue)retrieved.getAndConstraints().get(0);
        Assertions.assertThat((String)kiePMMLFieldOperatorValue.getName()).isEqualTo(declaredType);
        Assertions.assertThat((Comparable)kiePMMLFieldOperatorValue.getOperator()).isEqualTo((Object)BOOLEAN_OPERATOR.AND);
        String expectedValue = "value < \"" + simplePredicate.getValue() + "\"";
        Assertions.assertThat((String)kiePMMLFieldOperatorValue.getConstraintsAsString()).isEqualTo(expectedValue);
    }

    private SimplePredicate getSimplePredicate(String predicateName, Object value, SimplePredicate.Operator operator, Map<String, KiePMMLOriginalTypeGeneratedType> fieldTypeMap) {
        fieldTypeMap.put(predicateName, new KiePMMLOriginalTypeGeneratedType(DataType.STRING.value(), KiePMMLModelUtils.getSanitizedClassName((String)predicateName.toUpperCase())));
        return PMMLModelTestUtils.getSimplePredicate((String)predicateName, (Object)value, (SimplePredicate.Operator)operator);
    }
}

