/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.models.drools.commons.model;

import java.util.ArrayList;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.kie.pmml.commons.model.KiePMMLExtension;
import org.kie.pmml.commons.utils.KiePMMLModelUtils;
import org.kie.pmml.models.drools.commons.model.KiePMMLDroolsModel;

public class KiePMMLDroolsModelTest {
    private static final String MODEL_NAME = "MODELNAME";
    private static final String KMODULE_PACKAGE_NAME = KiePMMLModelUtils.getSanitizedPackageName((String)"MODELNAME");
    private static final List<KiePMMLExtension> EXTENSIONS = new ArrayList<KiePMMLExtension>();
    private KiePMMLDroolsModel kiePMMLDroolsModel;

    @BeforeEach
    public void setup() {
        this.kiePMMLDroolsModel = new KiePMMLDroolsModelFake(MODEL_NAME, KMODULE_PACKAGE_NAME, EXTENSIONS);
    }

    @Test
    void constructor() {
        Assertions.assertThat((String)this.kiePMMLDroolsModel.getName()).isEqualTo(MODEL_NAME);
        Assertions.assertThat((List)this.kiePMMLDroolsModel.getExtensions()).isEqualTo(EXTENSIONS);
        Assertions.assertThat((String)this.kiePMMLDroolsModel.getKModulePackageName()).isEqualTo(KiePMMLModelUtils.getSanitizedPackageName((String)MODEL_NAME));
    }

    private final class KiePMMLDroolsModelFake
    extends KiePMMLDroolsModel {
        protected KiePMMLDroolsModelFake(String modelName, String kModulePackageName, List<KiePMMLExtension> extensions) {
            super("FILENAME", modelName, extensions);
            this.kModulePackageName = kModulePackageName;
        }

        public String getKModulePackageName() {
            return super.getKModulePackageName();
        }
    }
}

