/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.models.drools.tree.compiler.factories;

import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.ConstructorDeclaration;
import com.github.javaparser.ast.expr.SimpleName;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.dmg.pmml.DataDictionary;
import org.dmg.pmml.LocalTransformations;
import org.dmg.pmml.PMML;
import org.dmg.pmml.TransformationDictionary;
import org.dmg.pmml.tree.TreeModel;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.kie.pmml.compiler.commons.utils.JavaParserUtils;
import org.kie.pmml.compiler.testutils.TestUtils;
import org.kie.pmml.models.drools.ast.KiePMMLDroolsAST;
import org.kie.pmml.models.drools.tree.compiler.factories.KiePMMLTreeModelFactory;
import org.kie.pmml.models.drools.tree.model.KiePMMLTreeModel;
import org.kie.pmml.models.drools.utils.KiePMMLASTTestUtils;

public class KiePMMLTreeModelFactoryTest {
    private static final String SOURCE_1 = "TreeSample.pmml";
    private static final String TARGET_FIELD = "whatIdo";
    private static final String PACKAGE_NAME = "packagename";
    private static PMML pmml;
    private static TreeModel treeModel;
    private static ClassOrInterfaceDeclaration classOrInterfaceDeclaration;

    @BeforeClass
    public static void setUp() throws Exception {
        pmml = TestUtils.loadFromFile((String)SOURCE_1);
        Assert.assertNotNull((Object)pmml);
        Assert.assertEquals((long)1L, (long)pmml.getModels().size());
        Assert.assertTrue((boolean)(pmml.getModels().get(0) instanceof TreeModel));
        treeModel = (TreeModel)pmml.getModels().get(0);
        CompilationUnit templateCU = JavaParserUtils.getFromFileName((String)"KiePMMLTreeModelTemplate.tmpl");
        classOrInterfaceDeclaration = (ClassOrInterfaceDeclaration)templateCU.getClassByName("KiePMMLTreeModelTemplate").get();
    }

    @Test
    public void getKiePMMLTreeModel() throws InstantiationException, IllegalAccessException {
        Map fieldTypeMap = KiePMMLASTTestUtils.getFieldTypeMap((DataDictionary)pmml.getDataDictionary(), (TransformationDictionary)pmml.getTransformationDictionary(), (LocalTransformations)treeModel.getLocalTransformations());
        KiePMMLTreeModel retrieved = KiePMMLTreeModelFactory.getKiePMMLTreeModel((DataDictionary)pmml.getDataDictionary(), (TransformationDictionary)pmml.getTransformationDictionary(), (TreeModel)treeModel, (Map)fieldTypeMap);
        Assert.assertNotNull((Object)retrieved);
        Assert.assertEquals((Object)treeModel.getModelName(), (Object)retrieved.getName());
        Assert.assertEquals((Object)TARGET_FIELD, (Object)retrieved.getTargetField());
    }

    @Test
    public void getKiePMMLScorecardModelSourcesMap() {
        Map fieldTypeMap = KiePMMLASTTestUtils.getFieldTypeMap((DataDictionary)pmml.getDataDictionary(), (TransformationDictionary)pmml.getTransformationDictionary(), (LocalTransformations)treeModel.getLocalTransformations());
        Map retrieved = KiePMMLTreeModelFactory.getKiePMMLTreeModelSourcesMap((DataDictionary)pmml.getDataDictionary(), (TransformationDictionary)pmml.getTransformationDictionary(), (TreeModel)treeModel, (Map)fieldTypeMap, (String)PACKAGE_NAME);
        Assert.assertNotNull((Object)retrieved);
        Assert.assertEquals((long)1L, (long)retrieved.size());
    }

    @Test
    public void getKiePMMLDroolsAST() {
        DataDictionary dataDictionary = pmml.getDataDictionary();
        Map fieldTypeMap = KiePMMLASTTestUtils.getFieldTypeMap((DataDictionary)pmml.getDataDictionary(), (TransformationDictionary)pmml.getTransformationDictionary(), (LocalTransformations)treeModel.getLocalTransformations());
        KiePMMLDroolsAST retrieved = KiePMMLTreeModelFactory.getKiePMMLDroolsAST((DataDictionary)dataDictionary, (TreeModel)treeModel, (Map)fieldTypeMap, Collections.emptyList());
        Assert.assertNotNull((Object)retrieved);
        List dataFields = dataDictionary.getDataFields();
        Assert.assertEquals((long)dataFields.size(), (long)fieldTypeMap.size());
        dataFields.forEach(dataField -> Assert.assertTrue((boolean)fieldTypeMap.containsKey(dataField.getName().getValue())));
    }

    @Test
    public void setSuperInvocation() {
        ConstructorDeclaration constructorDeclaration = (ConstructorDeclaration)classOrInterfaceDeclaration.getDefaultConstructor().get();
        SimpleName simpleName = new SimpleName("SIMPLENAME");
        KiePMMLTreeModelFactory.setSuperInvocation((TreeModel)treeModel, (ConstructorDeclaration)constructorDeclaration, (SimpleName)simpleName);
        String expected = String.format("public %s() {\n    super(\"%s\", Collections.emptyList(), \"%s\");\n    targetField = targetField;\n    pmmlMODEL = null;\n}", simpleName.asString(), treeModel.getModelName(), treeModel.getAlgorithmName());
        Assert.assertEquals((Object)expected, (Object)constructorDeclaration.toString());
    }
}

