/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.models.drools.tree.compiler.factories;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import org.dmg.pmml.DataDictionary;
import org.dmg.pmml.Model;
import org.dmg.pmml.PMML;
import org.dmg.pmml.tree.ClassifierNode;
import org.dmg.pmml.tree.LeafNode;
import org.dmg.pmml.tree.Node;
import org.dmg.pmml.tree.TreeModel;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.pmml.commons.model.enums.DATA_TYPE;
import org.kie.pmml.compiler.commons.utils.ModelUtils;
import org.kie.pmml.compiler.testutils.TestUtils;
import org.kie.pmml.models.drools.ast.factories.KiePMMLDataDictionaryASTFactory;
import org.kie.pmml.models.drools.tree.compiler.factories.KiePMMLTreeModelNodeASTFactory;

public class KiePMMLTreeModelNodeASTFactoryTest {
    private static final String SOURCE_GOLFING = "TreeSample.pmml";
    private static final String SOURCE_IRIS = "irisTree.pmml";
    private PMML golfingPmml;
    private TreeModel golfingModel;
    private PMML irisPmml;
    private TreeModel irisModel;

    @Before
    public void setUp() throws Exception {
        this.golfingPmml = TestUtils.loadFromFile((String)SOURCE_GOLFING);
        Assert.assertNotNull((Object)this.golfingPmml);
        Assert.assertEquals((long)1L, (long)this.golfingPmml.getModels().size());
        Assert.assertTrue((boolean)(this.golfingPmml.getModels().get(0) instanceof TreeModel));
        this.golfingModel = (TreeModel)this.golfingPmml.getModels().get(0);
        this.irisPmml = TestUtils.loadFromFile((String)SOURCE_IRIS);
        Assert.assertNotNull((Object)this.irisPmml);
        Assert.assertEquals((long)1L, (long)this.irisPmml.getModels().size());
        Assert.assertTrue((boolean)(this.irisPmml.getModels().get(0) instanceof TreeModel));
        this.irisModel = (TreeModel)this.irisPmml.getModels().get(0);
    }

    @Test
    public void declareRulesFromRootGolfingNode() {
        Node rootNode = this.golfingModel.getNode();
        Assert.assertEquals((Object)"will play", (Object)rootNode.getScore());
        HashMap fieldTypeMap = new HashMap();
        DATA_TYPE targetType = ModelUtils.getTargetFieldType((DataDictionary)this.golfingPmml.getDataDictionary(), (Model)this.golfingModel);
        KiePMMLDataDictionaryASTFactory.factory(fieldTypeMap).declareTypes(this.golfingPmml.getDataDictionary());
        KiePMMLTreeModelNodeASTFactory.factory(fieldTypeMap, Collections.emptyList(), (TreeModel.NoTrueChildStrategy)TreeModel.NoTrueChildStrategy.RETURN_NULL_PREDICTION, (DATA_TYPE)targetType).declareRulesFromRootNode(rootNode, "_will");
        Assert.assertFalse((boolean)fieldTypeMap.isEmpty());
    }

    @Test
    public void declareRulesFromRootIrisNode() {
        Node rootNode = this.irisModel.getNode();
        Assert.assertEquals((Object)"setosa", (Object)rootNode.getScore());
        HashMap fieldTypeMap = new HashMap();
        DATA_TYPE targetType = ModelUtils.getTargetFieldType((DataDictionary)this.irisPmml.getDataDictionary(), (Model)this.irisModel);
        KiePMMLDataDictionaryASTFactory.factory(fieldTypeMap).declareTypes(this.irisPmml.getDataDictionary());
        KiePMMLTreeModelNodeASTFactory.factory(fieldTypeMap, Collections.emptyList(), (TreeModel.NoTrueChildStrategy)TreeModel.NoTrueChildStrategy.RETURN_NULL_PREDICTION, (DATA_TYPE)targetType).declareRulesFromRootNode(rootNode, "_setosa");
        Assert.assertFalse((boolean)fieldTypeMap.isEmpty());
    }

    @Test
    public void declareIntermediateRuleFromGolfingNode() {
        Node finalNode = (Node)this.golfingModel.getNode().getNodes().get(0);
        Assert.assertEquals((Object)"will play", (Object)finalNode.getScore());
        HashMap fieldTypeMap = new HashMap();
        DATA_TYPE targetType = ModelUtils.getTargetFieldType((DataDictionary)this.golfingPmml.getDataDictionary(), (Model)this.golfingModel);
        KiePMMLDataDictionaryASTFactory.factory(fieldTypeMap).declareTypes(this.golfingPmml.getDataDictionary());
        ArrayList rules = new ArrayList();
        KiePMMLTreeModelNodeASTFactory.factory(fieldTypeMap, Collections.emptyList(), (TreeModel.NoTrueChildStrategy)TreeModel.NoTrueChildStrategy.RETURN_NULL_PREDICTION, (DATA_TYPE)targetType).declareIntermediateRuleFromNode(finalNode, "_will play", rules);
        Assert.assertFalse((boolean)rules.isEmpty());
    }

    @Test
    public void declareIntermediateRuleFromIrisNode() {
        Node finalNode = (Node)this.irisModel.getNode().getNodes().get(1);
        Assert.assertEquals((Object)"versicolor", (Object)finalNode.getScore());
        HashMap fieldTypeMap = new HashMap();
        DATA_TYPE targetType = ModelUtils.getTargetFieldType((DataDictionary)this.irisPmml.getDataDictionary(), (Model)this.irisModel);
        KiePMMLDataDictionaryASTFactory.factory(fieldTypeMap).declareTypes(this.irisPmml.getDataDictionary());
        ArrayList rules = new ArrayList();
        KiePMMLTreeModelNodeASTFactory.factory(fieldTypeMap, Collections.emptyList(), (TreeModel.NoTrueChildStrategy)TreeModel.NoTrueChildStrategy.RETURN_NULL_PREDICTION, (DATA_TYPE)targetType).declareIntermediateRuleFromNode(finalNode, "_setosa", rules);
        Assert.assertFalse((boolean)rules.isEmpty());
    }

    @Test
    public void isFinalLeaf() {
        LeafNode node = new LeafNode();
        DATA_TYPE targetType = DATA_TYPE.STRING;
        KiePMMLTreeModelNodeASTFactory.factory(new HashMap(), Collections.emptyList(), (TreeModel.NoTrueChildStrategy)TreeModel.NoTrueChildStrategy.RETURN_NULL_PREDICTION, (DATA_TYPE)targetType).isFinalLeaf((Node)node);
        Assert.assertTrue((boolean)KiePMMLTreeModelNodeASTFactory.factory(new HashMap(), Collections.emptyList(), (TreeModel.NoTrueChildStrategy)TreeModel.NoTrueChildStrategy.RETURN_NULL_PREDICTION, (DATA_TYPE)targetType).isFinalLeaf((Node)node));
        node = new ClassifierNode();
        Assert.assertTrue((boolean)KiePMMLTreeModelNodeASTFactory.factory(new HashMap(), Collections.emptyList(), (TreeModel.NoTrueChildStrategy)TreeModel.NoTrueChildStrategy.RETURN_NULL_PREDICTION, (DATA_TYPE)targetType).isFinalLeaf((Node)node));
        node.addNodes((Node)new LeafNode());
        Assert.assertFalse((boolean)KiePMMLTreeModelNodeASTFactory.factory(new HashMap(), Collections.emptyList(), (TreeModel.NoTrueChildStrategy)TreeModel.NoTrueChildStrategy.RETURN_NULL_PREDICTION, (DATA_TYPE)targetType).isFinalLeaf((Node)node));
    }
}

