/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.models.drools.tree.compiler.executor;

import java.io.FileInputStream;
import java.io.InputStream;
import org.dmg.pmml.Model;
import org.dmg.pmml.PMML;
import org.dmg.pmml.tree.TreeModel;
import org.drools.compiler.builder.impl.KnowledgeBuilderImpl;
import org.junit.Assert;
import org.junit.Test;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.pmml.commons.model.enums.PMML_MODEL;
import org.kie.pmml.compiler.commons.utils.KiePMMLUtil;
import org.kie.pmml.models.drools.commons.model.KiePMMLDroolsModel;
import org.kie.pmml.models.drools.tree.compiler.executor.TreeModelImplementationProvider;
import org.kie.pmml.models.drools.tree.model.KiePMMLTreeModel;
import org.kie.test.util.filesystem.FileUtils;

public class TreeModelImplementationProviderTest {
    private static final TreeModelImplementationProvider PROVIDER = new TreeModelImplementationProvider();
    private static final KnowledgeBuilder KNOWLEDGE_BUILDER = new KnowledgeBuilderImpl();
    private static final String SOURCE_1 = "TreeSample.pmml";

    @Test
    public void getPMMLModelType() {
        Assert.assertEquals((Object)PMML_MODEL.TREE_MODEL, (Object)PROVIDER.getPMMLModelType());
    }

    @Test
    public void getKiePMMLModel() throws Exception {
        PMML pmml = this.getPMML(SOURCE_1);
        KiePMMLTreeModel kiePMMLModel = (KiePMMLTreeModel)PROVIDER.getKiePMMLModel(pmml.getDataDictionary(), pmml.getTransformationDictionary(), (Model)((TreeModel)pmml.getModels().get(0)), (Object)KNOWLEDGE_BUILDER);
        Assert.assertNotNull((Object)kiePMMLModel);
    }

    @Test
    public void getKiePMMLModelFromPlugin() throws Exception {
        PMML pmml = this.getPMML(SOURCE_1);
        KnowledgeBuilderImpl knowledgeBuilder = new KnowledgeBuilderImpl();
        KiePMMLDroolsModel retrieved = PROVIDER.getKiePMMLModelFromPlugin("PACKAGE_NAME", pmml.getDataDictionary(), pmml.getTransformationDictionary(), (Model)((TreeModel)pmml.getModels().get(0)), (Object)knowledgeBuilder);
        Assert.assertNotNull((Object)retrieved);
    }

    private PMML getPMML(String source) throws Exception {
        FileInputStream fis = FileUtils.getFileInputStream((String)source);
        PMML toReturn = KiePMMLUtil.load((InputStream)fis, (String)source);
        Assert.assertNotNull((Object)toReturn);
        Assert.assertEquals((long)1L, (long)toReturn.getModels().size());
        Assert.assertTrue((boolean)(toReturn.getModels().get(0) instanceof TreeModel));
        return toReturn;
    }
}

