/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.models.drools.tree.compiler.factories;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.dmg.pmml.DataDictionary;
import org.dmg.pmml.LocalTransformations;
import org.dmg.pmml.Model;
import org.dmg.pmml.PMML;
import org.dmg.pmml.TransformationDictionary;
import org.dmg.pmml.tree.TreeModel;
import org.junit.Before;
import org.junit.Test;
import org.kie.pmml.compiler.api.CommonTestingUtils;
import org.kie.pmml.compiler.api.testutils.TestUtils;
import org.kie.pmml.models.drools.ast.KiePMMLDroolsAST;
import org.kie.pmml.models.drools.tree.compiler.factories.KiePMMLTreeModelASTFactory;
import org.kie.pmml.models.drools.utils.KiePMMLASTTestUtils;

public class KiePMMLTreeModelASTFactoryTest {
    private static final String SOURCE_GOLFING = "TreeSample.pmml";
    private static final String SOURCE_IRIS = "irisTree.pmml";
    private static final String SOURCE_SIMPLESET = "SimpleSetPredicateTree.pmml";
    private PMML golfingPmml;
    private TreeModel golfingModel;
    private PMML irisPmml;
    private TreeModel irisModel;
    private PMML simpleSetPmml;
    private TreeModel simpleSetModel;

    @Before
    public void setUp() throws Exception {
        this.golfingPmml = TestUtils.loadFromFile((String)SOURCE_GOLFING);
        Assertions.assertThat((Object)this.golfingPmml).isNotNull();
        Assertions.assertThat((List)this.golfingPmml.getModels()).hasSize(1);
        Assertions.assertThat((Object)((Model)this.golfingPmml.getModels().get(0))).isInstanceOf(TreeModel.class);
        this.golfingModel = (TreeModel)this.golfingPmml.getModels().get(0);
        this.irisPmml = TestUtils.loadFromFile((String)SOURCE_IRIS);
        Assertions.assertThat((Object)this.irisPmml).isNotNull();
        Assertions.assertThat((List)this.irisPmml.getModels()).hasSize(1);
        Assertions.assertThat((Object)((Model)this.irisPmml.getModels().get(0))).isInstanceOf(TreeModel.class);
        this.irisModel = (TreeModel)this.irisPmml.getModels().get(0);
        this.simpleSetPmml = TestUtils.loadFromFile((String)SOURCE_SIMPLESET);
        Assertions.assertThat((Object)this.simpleSetPmml).isNotNull();
        Assertions.assertThat((List)this.simpleSetPmml.getModels()).hasSize(1);
        Assertions.assertThat((Object)((Model)this.simpleSetPmml.getModels().get(0))).isInstanceOf(TreeModel.class);
        this.simpleSetModel = (TreeModel)this.simpleSetPmml.getModels().get(0);
    }

    @Test
    public void getKiePMMLDroolsGolfingAST() {
        Map fieldTypeMap = KiePMMLASTTestUtils.getFieldTypeMap((DataDictionary)this.golfingPmml.getDataDictionary(), (TransformationDictionary)this.golfingPmml.getTransformationDictionary(), (LocalTransformations)this.golfingModel.getLocalTransformations());
        List types = Collections.emptyList();
        KiePMMLDroolsAST retrieved = KiePMMLTreeModelASTFactory.getKiePMMLDroolsAST((List)CommonTestingUtils.getFieldsFromDataDictionary((DataDictionary)this.golfingPmml.getDataDictionary()), (TreeModel)this.golfingModel, (Map)fieldTypeMap, types);
        Assertions.assertThat((Object)retrieved).isNotNull();
        Assertions.assertThat((List)retrieved.getTypes()).isEqualTo(types);
        Assertions.assertThat((List)retrieved.getRules()).isNotEmpty();
    }

    @Test
    public void getKiePMMLDroolsIrisAST() {
        Map fieldTypeMap = KiePMMLASTTestUtils.getFieldTypeMap((DataDictionary)this.irisPmml.getDataDictionary(), (TransformationDictionary)this.irisPmml.getTransformationDictionary(), (LocalTransformations)this.irisModel.getLocalTransformations());
        List types = Collections.emptyList();
        KiePMMLDroolsAST retrieved = KiePMMLTreeModelASTFactory.getKiePMMLDroolsAST((List)CommonTestingUtils.getFieldsFromDataDictionary((DataDictionary)this.irisPmml.getDataDictionary()), (TreeModel)this.irisModel, (Map)fieldTypeMap, types);
        Assertions.assertThat((Object)retrieved).isNotNull();
        Assertions.assertThat((List)retrieved.getTypes()).isEqualTo(types);
        Assertions.assertThat((List)retrieved.getRules()).isNotEmpty();
    }

    @Test
    public void getKiePMMLDroolsSimpleSetAST() {
        Map fieldTypeMap = KiePMMLASTTestUtils.getFieldTypeMap((DataDictionary)this.simpleSetPmml.getDataDictionary(), (TransformationDictionary)this.simpleSetPmml.getTransformationDictionary(), (LocalTransformations)this.simpleSetModel.getLocalTransformations());
        List types = Collections.emptyList();
        KiePMMLDroolsAST retrieved = KiePMMLTreeModelASTFactory.getKiePMMLDroolsAST((List)CommonTestingUtils.getFieldsFromDataDictionary((DataDictionary)this.simpleSetPmml.getDataDictionary()), (TreeModel)this.simpleSetModel, (Map)fieldTypeMap, types);
        Assertions.assertThat((Object)retrieved).isNotNull();
        Assertions.assertThat((List)retrieved.getTypes()).isEqualTo(types);
        Assertions.assertThat((List)retrieved.getRules()).isNotEmpty();
    }
}

