/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.models.drools.tree.compiler.factories;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.dmg.pmml.DataDictionary;
import org.dmg.pmml.Model;
import org.dmg.pmml.PMML;
import org.dmg.pmml.tree.ClassifierNode;
import org.dmg.pmml.tree.LeafNode;
import org.dmg.pmml.tree.Node;
import org.dmg.pmml.tree.TreeModel;
import org.junit.Before;
import org.junit.Test;
import org.kie.pmml.api.enums.DATA_TYPE;
import org.kie.pmml.compiler.api.CommonTestingUtils;
import org.kie.pmml.compiler.api.testutils.TestUtils;
import org.kie.pmml.compiler.api.utils.ModelUtils;
import org.kie.pmml.models.drools.ast.factories.KiePMMLDataDictionaryASTFactory;
import org.kie.pmml.models.drools.tree.compiler.factories.KiePMMLTreeModelNodeASTFactory;

public class KiePMMLTreeModelNodeASTFactoryTest {
    private static final String SOURCE_GOLFING = "TreeSample.pmml";
    private static final String SOURCE_IRIS = "irisTree.pmml";
    private PMML golfingPmml;
    private TreeModel golfingModel;
    private PMML irisPmml;
    private TreeModel irisModel;

    @Before
    public void setUp() throws Exception {
        this.golfingPmml = TestUtils.loadFromFile((String)SOURCE_GOLFING);
        Assertions.assertThat((Object)this.golfingPmml).isNotNull();
        Assertions.assertThat((List)this.golfingPmml.getModels()).hasSize(1);
        Assertions.assertThat((Object)((Model)this.golfingPmml.getModels().get(0))).isInstanceOf(TreeModel.class);
        this.golfingModel = (TreeModel)this.golfingPmml.getModels().get(0);
        this.irisPmml = TestUtils.loadFromFile((String)SOURCE_IRIS);
        Assertions.assertThat((Object)this.irisPmml).isNotNull();
        Assertions.assertThat((List)this.irisPmml.getModels()).hasSize(1);
        Assertions.assertThat((Object)((Model)this.irisPmml.getModels().get(0))).isInstanceOf(TreeModel.class);
        this.irisModel = (TreeModel)this.irisPmml.getModels().get(0);
    }

    @Test
    public void declareRulesFromRootGolfingNode() {
        Node rootNode = this.golfingModel.getNode();
        Assertions.assertThat((Object)rootNode.getScore()).isEqualTo((Object)"will play");
        HashMap fieldTypeMap = new HashMap();
        List fields = CommonTestingUtils.getFieldsFromDataDictionary((DataDictionary)this.golfingPmml.getDataDictionary());
        DATA_TYPE targetType = ModelUtils.getTargetFieldType((List)fields, (Model)this.golfingModel);
        KiePMMLDataDictionaryASTFactory.factory(fieldTypeMap).declareTypes(fields);
        KiePMMLTreeModelNodeASTFactory.factory(fieldTypeMap, Collections.emptyList(), (TreeModel.NoTrueChildStrategy)TreeModel.NoTrueChildStrategy.RETURN_NULL_PREDICTION, (DATA_TYPE)targetType).declareRulesFromRootNode(rootNode, "_will");
        Assertions.assertThat(fieldTypeMap).isNotEmpty();
    }

    @Test
    public void declareRulesFromRootIrisNode() {
        Node rootNode = this.irisModel.getNode();
        Assertions.assertThat((Object)rootNode.getScore()).isEqualTo((Object)"setosa");
        HashMap fieldTypeMap = new HashMap();
        List fields = CommonTestingUtils.getFieldsFromDataDictionary((DataDictionary)this.irisPmml.getDataDictionary());
        DATA_TYPE targetType = ModelUtils.getTargetFieldType((List)fields, (Model)this.irisModel);
        KiePMMLDataDictionaryASTFactory.factory(fieldTypeMap).declareTypes(fields);
        KiePMMLTreeModelNodeASTFactory.factory(fieldTypeMap, Collections.emptyList(), (TreeModel.NoTrueChildStrategy)TreeModel.NoTrueChildStrategy.RETURN_NULL_PREDICTION, (DATA_TYPE)targetType).declareRulesFromRootNode(rootNode, "_setosa");
        Assertions.assertThat(fieldTypeMap).isNotEmpty();
    }

    @Test
    public void declareIntermediateRuleFromGolfingNode() {
        Node finalNode = (Node)this.golfingModel.getNode().getNodes().get(0);
        Assertions.assertThat((Object)finalNode.getScore()).isEqualTo((Object)"will play");
        HashMap fieldTypeMap = new HashMap();
        List fields = CommonTestingUtils.getFieldsFromDataDictionary((DataDictionary)this.golfingPmml.getDataDictionary());
        DATA_TYPE targetType = ModelUtils.getTargetFieldType((List)fields, (Model)this.golfingModel);
        KiePMMLDataDictionaryASTFactory.factory(fieldTypeMap).declareTypes(fields);
        ArrayList rules = new ArrayList();
        KiePMMLTreeModelNodeASTFactory.factory(fieldTypeMap, Collections.emptyList(), (TreeModel.NoTrueChildStrategy)TreeModel.NoTrueChildStrategy.RETURN_NULL_PREDICTION, (DATA_TYPE)targetType).declareIntermediateRuleFromNode(finalNode, "_will play", rules);
        Assertions.assertThat(rules).isNotEmpty();
    }

    @Test
    public void declareIntermediateRuleFromIrisNode() {
        Node finalNode = (Node)this.irisModel.getNode().getNodes().get(1);
        Assertions.assertThat((Object)finalNode.getScore()).isEqualTo((Object)"versicolor");
        HashMap fieldTypeMap = new HashMap();
        List fields = CommonTestingUtils.getFieldsFromDataDictionary((DataDictionary)this.irisPmml.getDataDictionary());
        DATA_TYPE targetType = ModelUtils.getTargetFieldType((List)fields, (Model)this.irisModel);
        KiePMMLDataDictionaryASTFactory.factory(fieldTypeMap).declareTypes(fields);
        ArrayList rules = new ArrayList();
        KiePMMLTreeModelNodeASTFactory.factory(fieldTypeMap, Collections.emptyList(), (TreeModel.NoTrueChildStrategy)TreeModel.NoTrueChildStrategy.RETURN_NULL_PREDICTION, (DATA_TYPE)targetType).declareIntermediateRuleFromNode(finalNode, "_setosa", rules);
        Assertions.assertThat(rules).isNotEmpty();
    }

    @Test
    public void isFinalLeaf() {
        LeafNode node = new LeafNode();
        DATA_TYPE targetType = DATA_TYPE.STRING;
        KiePMMLTreeModelNodeASTFactory.factory(new HashMap(), Collections.emptyList(), (TreeModel.NoTrueChildStrategy)TreeModel.NoTrueChildStrategy.RETURN_NULL_PREDICTION, (DATA_TYPE)targetType).isFinalLeaf((Node)node);
        Assertions.assertThat((boolean)KiePMMLTreeModelNodeASTFactory.factory(new HashMap(), Collections.emptyList(), (TreeModel.NoTrueChildStrategy)TreeModel.NoTrueChildStrategy.RETURN_NULL_PREDICTION, (DATA_TYPE)targetType).isFinalLeaf((Node)node)).isTrue();
        node = new ClassifierNode();
        Assertions.assertThat((boolean)KiePMMLTreeModelNodeASTFactory.factory(new HashMap(), Collections.emptyList(), (TreeModel.NoTrueChildStrategy)TreeModel.NoTrueChildStrategy.RETURN_NULL_PREDICTION, (DATA_TYPE)targetType).isFinalLeaf((Node)node)).isTrue();
        node.addNodes((Node)new LeafNode());
        Assertions.assertThat((boolean)KiePMMLTreeModelNodeASTFactory.factory(new HashMap(), Collections.emptyList(), (TreeModel.NoTrueChildStrategy)TreeModel.NoTrueChildStrategy.RETURN_NULL_PREDICTION, (DATA_TYPE)targetType).isFinalLeaf((Node)node)).isFalse();
    }
}

