/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.models.drools.tree.compiler.factories;

import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.ConstructorDeclaration;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.StringLiteralExpr;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.dmg.pmml.DataDictionary;
import org.dmg.pmml.LocalTransformations;
import org.dmg.pmml.Model;
import org.dmg.pmml.PMML;
import org.dmg.pmml.TransformationDictionary;
import org.dmg.pmml.tree.TreeModel;
import org.drools.compiler.builder.impl.KnowledgeBuilderImpl;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.kie.pmml.api.enums.MINING_FUNCTION;
import org.kie.pmml.api.enums.PMML_MODEL;
import org.kie.pmml.commons.model.HasClassLoader;
import org.kie.pmml.commons.utils.KiePMMLModelUtils;
import org.kie.pmml.compiler.api.CommonTestingUtils;
import org.kie.pmml.compiler.api.dto.CommonCompilationDTO;
import org.kie.pmml.compiler.api.dto.CompilationDTO;
import org.kie.pmml.compiler.api.testutils.TestUtils;
import org.kie.pmml.compiler.commons.testutils.CodegenTestUtils;
import org.kie.pmml.compiler.commons.utils.JavaParserUtils;
import org.kie.pmml.models.drools.ast.KiePMMLDroolsAST;
import org.kie.pmml.models.drools.commons.implementations.HasKnowledgeBuilderMock;
import org.kie.pmml.models.drools.dto.DroolsCompilationDTO;
import org.kie.pmml.models.drools.tree.compiler.factories.KiePMMLTreeModelFactory;
import org.kie.pmml.models.drools.tree.model.KiePMMLTreeModel;
import org.kie.pmml.models.drools.utils.KiePMMLASTTestUtils;

public class KiePMMLTreeModelFactoryTest {
    private static final String SOURCE_1 = "TreeSample.pmml";
    private static final String TARGET_FIELD = "whatIdo";
    private static PMML pmml;
    private static TreeModel treeModel;
    private static ClassOrInterfaceDeclaration classOrInterfaceDeclaration;

    @BeforeAll
    public static void setUp() throws Exception {
        pmml = TestUtils.loadFromFile((String)SOURCE_1);
        Assertions.assertThat((Object)pmml).isNotNull();
        Assertions.assertThat((List)pmml.getModels()).hasSize(1);
        Assertions.assertThat((Object)((Model)pmml.getModels().get(0))).isInstanceOf(TreeModel.class);
        treeModel = (TreeModel)pmml.getModels().get(0);
        CompilationUnit templateCU = JavaParserUtils.getFromFileName((String)"KiePMMLTreeModelTemplate.tmpl");
        classOrInterfaceDeclaration = (ClassOrInterfaceDeclaration)templateCU.getClassByName("KiePMMLTreeModelTemplate").get();
    }

    @Test
    void getKiePMMLTreeModel() throws InstantiationException, IllegalAccessException {
        Map fieldTypeMap = KiePMMLASTTestUtils.getFieldTypeMap((DataDictionary)pmml.getDataDictionary(), (TransformationDictionary)pmml.getTransformationDictionary(), (LocalTransformations)treeModel.getLocalTransformations());
        KnowledgeBuilderImpl knowledgeBuilder = new KnowledgeBuilderImpl();
        CommonCompilationDTO compilationDTO = CommonCompilationDTO.fromGeneratedPackageNameAndFields((String)"PACKAGE_NAME", (PMML)pmml, (Model)treeModel, (HasClassLoader)new HasKnowledgeBuilderMock(knowledgeBuilder));
        DroolsCompilationDTO droolsCompilationDTO = DroolsCompilationDTO.fromCompilationDTO((CompilationDTO)compilationDTO, (Map)fieldTypeMap);
        KiePMMLTreeModel retrieved = KiePMMLTreeModelFactory.getKiePMMLTreeModel((DroolsCompilationDTO)droolsCompilationDTO);
        Assertions.assertThat((Object)retrieved).isNotNull();
        Assertions.assertThat((String)retrieved.getName()).isEqualTo(treeModel.getModelName());
        Assertions.assertThat((String)retrieved.getTargetField()).isEqualTo(TARGET_FIELD);
    }

    @Test
    void getKiePMMLScorecardModelSourcesMap() {
        Map fieldTypeMap = KiePMMLASTTestUtils.getFieldTypeMap((DataDictionary)pmml.getDataDictionary(), (TransformationDictionary)pmml.getTransformationDictionary(), (LocalTransformations)treeModel.getLocalTransformations());
        KnowledgeBuilderImpl knowledgeBuilder = new KnowledgeBuilderImpl();
        CommonCompilationDTO compilationDTO = CommonCompilationDTO.fromGeneratedPackageNameAndFields((String)"PACKAGE_NAME", (PMML)pmml, (Model)treeModel, (HasClassLoader)new HasKnowledgeBuilderMock(knowledgeBuilder));
        DroolsCompilationDTO droolsCompilationDTO = DroolsCompilationDTO.fromCompilationDTO((CompilationDTO)compilationDTO, (Map)fieldTypeMap);
        Map retrieved = KiePMMLTreeModelFactory.getKiePMMLTreeModelSourcesMap((DroolsCompilationDTO)droolsCompilationDTO);
        Assertions.assertThat((Map)retrieved).isNotNull();
        Assertions.assertThat((Map)retrieved).hasSize(1);
    }

    @Test
    void getKiePMMLDroolsAST() {
        DataDictionary dataDictionary = pmml.getDataDictionary();
        Map fieldTypeMap = KiePMMLASTTestUtils.getFieldTypeMap((DataDictionary)pmml.getDataDictionary(), (TransformationDictionary)pmml.getTransformationDictionary(), (LocalTransformations)treeModel.getLocalTransformations());
        KiePMMLDroolsAST retrieved = KiePMMLTreeModelFactory.getKiePMMLDroolsAST((List)CommonTestingUtils.getFieldsFromDataDictionary((DataDictionary)dataDictionary), (TreeModel)treeModel, (Map)fieldTypeMap, Collections.emptyList());
        Assertions.assertThat((Object)retrieved).isNotNull();
        List dataFields = dataDictionary.getDataFields();
        Assertions.assertThat((Map)fieldTypeMap).hasSameSizeAs((Iterable)dataFields);
        dataFields.forEach(dataField -> Assertions.assertThat((Map)fieldTypeMap).containsKey((Object)dataField.getName().getValue()));
    }

    @Test
    void setConstructor() {
        String targetField = TARGET_FIELD;
        ClassOrInterfaceDeclaration modelTemplate = classOrInterfaceDeclaration.clone();
        KnowledgeBuilderImpl knowledgeBuilder = new KnowledgeBuilderImpl();
        CommonCompilationDTO compilationDTO = CommonCompilationDTO.fromGeneratedPackageNameAndFields((String)"PACKAGE_NAME", (PMML)pmml, (Model)treeModel, (HasClassLoader)new HasKnowledgeBuilderMock(knowledgeBuilder));
        DroolsCompilationDTO droolsCompilationDTO = DroolsCompilationDTO.fromCompilationDTO((CompilationDTO)compilationDTO, new HashMap());
        KiePMMLTreeModelFactory.setConstructor((DroolsCompilationDTO)droolsCompilationDTO, (ClassOrInterfaceDeclaration)modelTemplate);
        HashMap<Integer, NameExpr> superInvocationExpressionsMap = new HashMap<Integer, NameExpr>();
        superInvocationExpressionsMap.put(0, new NameExpr(String.format("\"%s\"", treeModel.getModelName())));
        superInvocationExpressionsMap.put(2, new NameExpr(String.format("\"%s\"", treeModel.getAlgorithmName())));
        MINING_FUNCTION miningFunction = MINING_FUNCTION.byName((String)treeModel.getMiningFunction().value());
        PMML_MODEL pmmlModel = PMML_MODEL.byName((String)treeModel.getClass().getSimpleName());
        HashMap<String, Object> assignExpressionMap = new HashMap<String, Object>();
        assignExpressionMap.put("targetField", new StringLiteralExpr(TARGET_FIELD));
        assignExpressionMap.put("miningFunction", new NameExpr(miningFunction.getClass().getName() + "." + miningFunction.name()));
        assignExpressionMap.put("pmmlMODEL", new NameExpr(pmmlModel.getClass().getName() + "." + pmmlModel.name()));
        ConstructorDeclaration constructorDeclaration = (ConstructorDeclaration)modelTemplate.getDefaultConstructor().get();
        Assertions.assertThat((boolean)CodegenTestUtils.commonEvaluateConstructor((ConstructorDeclaration)constructorDeclaration, (String)KiePMMLModelUtils.getSanitizedClassName((String)treeModel.getModelName()), superInvocationExpressionsMap, assignExpressionMap)).isTrue();
    }
}

