/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.models.drools.tree.tests;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import org.assertj.core.api.Assertions;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.pmml.PMML4Result;
import org.kie.pmml.evaluator.api.executor.PMMLRuntime;
import org.kie.pmml.models.drools.tree.tests.AbstractPMMLTreeTest;

@RunWith(value=Parameterized.class)
public class SimpleClassificationTreeTest
extends AbstractPMMLTreeTest {
    private static final String MODEL_NAME = "SimpleClassificationTreeModel";
    private static final String TARGET_FIELD = "Predicted_result";
    private static PMMLRuntime pmmlRuntime;
    private double input1;
    private double input2;
    private double input3;
    private String expectedResult;

    public SimpleClassificationTreeTest(double input1, double input2, double input3, String expectedResult) {
        this.input1 = input1;
        this.input2 = input2;
        this.input3 = input3;
        this.expectedResult = expectedResult;
    }

    @BeforeClass
    public static void setupClass() {
        pmmlRuntime = SimpleClassificationTreeTest.getPMMLRuntime(MODEL_NAME);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        return Arrays.asList({5, 0, 0, "classA"}, {2, -5, 0, "classB"}, {2, 7, 0, "classC"}, {10, 7, 0, "classB"}, {10, -7, 10, "classC"});
    }

    @Test
    public void testSimpleClassificationTree() {
        HashMap<String, Object> inputData = new HashMap<String, Object>();
        inputData.put("input1", this.input1);
        inputData.put("input2", this.input2);
        inputData.put("input3", this.input3);
        PMML4Result pmml4Result = this.evaluate(pmmlRuntime, inputData, MODEL_NAME);
        Assertions.assertThat(pmml4Result.getResultVariables().get(TARGET_FIELD)).isNotNull();
        Assertions.assertThat(pmml4Result.getResultVariables().get(TARGET_FIELD)).isEqualTo((Object)this.expectedResult);
    }
}

