/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.models.drools.tree.tests;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import org.assertj.core.api.Assertions;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.pmml.PMML4Result;
import org.kie.pmml.evaluator.api.executor.PMMLRuntime;
import org.kie.pmml.models.drools.tree.tests.AbstractPMMLTreeTest;

@RunWith(value=Parameterized.class)
public class BostonHousingDataTreeTest
extends AbstractPMMLTreeTest {
    private static final String MODEL_NAME = "BostonHousingTreeModel";
    private static final String TARGET_FIELD = "Predicted_medv";
    private static PMMLRuntime pmmlRuntime;
    private double crim;
    private double zn;
    private double indus;
    private String chas;
    private double nox;
    private double rm;
    private double age;
    private double dis;
    private double rad;
    private double tax;
    private double ptratio;
    private double b;
    private double lstat;
    private double expectedResult;

    public BostonHousingDataTreeTest(double crim, double zn, double indus, String chas, double nox, double rm, double age, double dis, double rad, double tax, double ptratio, double b, double lstat, double expectedResult) {
        this.crim = crim;
        this.zn = zn;
        this.indus = indus;
        this.chas = chas;
        this.nox = nox;
        this.rm = rm;
        this.age = age;
        this.dis = dis;
        this.rad = rad;
        this.tax = tax;
        this.ptratio = ptratio;
        this.b = b;
        this.lstat = lstat;
        this.expectedResult = expectedResult;
    }

    @BeforeClass
    public static void setupClass() {
        pmmlRuntime = BostonHousingDataTreeTest.getPMMLRuntime(MODEL_NAME);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        return Arrays.asList({0.00632, 18, 2.31, "0", 0.538, 6.575, 65.2, 4.09, 1, 296, 15.3, 396.9, 4.98, 27.4272727272727}, {0.02729, 0, 7.07, "0", 0.469, 7.185, 61.1, 4.9671, 2, 242, 17.8, 392.83, 4.03, 33.7384615384615}, {0.06905, 0, 2.18, "0", 0.458, 7.147, 54.2, 6.0622, 3, 222, 18.7, 396.9, 5.33, 33.7384615384615}, {0.02985, 0, 2.18, "0", 0.458, 6.43, 58.7, 6.0622, 3, 222, 18.7, 394.12, 5.21, 21.6564766839378}, {0.7842, 0.0, 8.14, "0", 0.538, 5.99, 81.7, 4.2579, 4, 307, 21.0, 386.75, 14.67, 17.1376237623762}, {3.53501, 0, 19.58, "1", 0.871, 6.152, 82.6, 1.7455, 5, 403, 14.7, 88.01, 15.02, 17.1376237623762}, {8.26725, 0, 18.1, "1", 0.668, 5.875, 89.6, 1.1296, 24, 666, 20.2, 347.88, 8.88, 38.0}, {3.47428, 0, 18.1, "1", 0.718, 8.78, 82.9, 1.9047, 24, 666, 20.2, 354.55, 5.29, 45.0966666666667}, {5.20177, 0, 18.1, "1", 0.77, 6.127, 83.4, 2.7227, 24, 666, 20.2, 395.43, 11.48, 21.6564766839378}, {4.22239, 0, 18.1, "1", 0.77, 5.803, 89.0, 1.9047, 24, 666, 20.2, 353.04, 14.64, 17.1376237623762});
    }

    @Test
    public void testBostonHousesTree() {
        HashMap<String, Object> inputData = new HashMap<String, Object>();
        inputData.put("crim", this.crim);
        inputData.put("zn", this.zn);
        inputData.put("indus", this.indus);
        inputData.put("chas", this.chas);
        inputData.put("nox", this.nox);
        inputData.put("rm", this.rm);
        inputData.put("age", this.age);
        inputData.put("dis", this.dis);
        inputData.put("rad", this.rad);
        inputData.put("tax", this.tax);
        inputData.put("ptratio", this.ptratio);
        inputData.put("b", this.b);
        inputData.put("lstat", this.lstat);
        PMML4Result pmml4Result = this.evaluate(pmmlRuntime, inputData, MODEL_NAME);
        Assertions.assertThat(pmml4Result.getResultVariables().get(TARGET_FIELD)).isNotNull();
        Assertions.assertThat(pmml4Result.getResultVariables().get(TARGET_FIELD)).isEqualTo((Object)this.expectedResult);
    }
}

