/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.models.mining.evaluator;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.KieBase;
import org.kie.api.KieServices;
import org.kie.api.pmml.PMML4Result;
import org.kie.api.runtime.KieContainer;
import org.kie.pmml.api.enums.MINING_FUNCTION;
import org.kie.pmml.api.enums.PMML_MODEL;
import org.kie.pmml.api.enums.ResultCode;
import org.kie.pmml.api.exceptions.KiePMMLException;
import org.kie.pmml.api.exceptions.KiePMMLInternalException;
import org.kie.pmml.api.runtime.PMMLRuntime;
import org.kie.pmml.commons.model.KiePMMLModel;
import org.kie.pmml.commons.model.tuples.KiePMMLNameValue;
import org.kie.pmml.commons.model.tuples.KiePMMLValueWeight;
import org.kie.pmml.commons.testingutility.KiePMMLTestingModel;
import org.kie.pmml.evaluator.api.exceptions.KiePMMLModelException;
import org.kie.pmml.evaluator.api.executor.PMMLRuntimeInternal;
import org.kie.pmml.models.mining.evaluator.PMMLMiningModelEvaluator;
import org.kie.pmml.models.mining.model.KiePMMLMiningModel;
import org.kie.pmml.models.mining.model.enums.MULTIPLE_MODEL_METHOD;
import org.kie.pmml.models.mining.model.segmentation.KiePMMLSegmentation;

public class PMMLMiningModelEvaluatorTest {
    private static final List<MULTIPLE_MODEL_METHOD> RAW_OBJECT_METHODS = Arrays.asList(MULTIPLE_MODEL_METHOD.MAJORITY_VOTE, MULTIPLE_MODEL_METHOD.SELECT_ALL, MULTIPLE_MODEL_METHOD.SELECT_FIRST);
    private static final List<MULTIPLE_MODEL_METHOD> VALUE_WEIGHT_METHODS = Arrays.asList(MULTIPLE_MODEL_METHOD.MAX, MULTIPLE_MODEL_METHOD.SUM, MULTIPLE_MODEL_METHOD.MEDIAN, MULTIPLE_MODEL_METHOD.AVERAGE, MULTIPLE_MODEL_METHOD.WEIGHTED_SUM, MULTIPLE_MODEL_METHOD.WEIGHTED_MEDIAN, MULTIPLE_MODEL_METHOD.WEIGHTED_AVERAGE);
    private static final List<MULTIPLE_MODEL_METHOD> NOT_IMPLEMENTED_METHODS = Arrays.asList(MULTIPLE_MODEL_METHOD.MODEL_CHAIN, MULTIPLE_MODEL_METHOD.WEIGHTED_MAJORITY_VOTE);
    private PMMLMiningModelEvaluator evaluator;

    @Before
    public void setUp() {
        this.evaluator = new PMMLMiningModelEvaluator();
    }

    @Test
    public void getPMMLModelType() {
        Assert.assertEquals((Object)PMML_MODEL.MINING_MODEL, (Object)this.evaluator.getPMMLModelType());
    }

    @Test
    public void getPMML4ResultOK() {
        String name = "NAME";
        String targetField = "TARGET";
        String prediction = "FIRST_VALUE";
        HashMap outputFieldsMap = new HashMap();
        IntStream.range(0, 3).forEach(index -> outputFieldsMap.put("KEY_" + index, "OBJECT_" + index));
        KiePMMLSegmentation kiePMMLSegmentation = (KiePMMLSegmentation)KiePMMLSegmentation.builder((String)"SEGM_1", Collections.emptyList(), (MULTIPLE_MODEL_METHOD)MULTIPLE_MODEL_METHOD.SELECT_FIRST).build();
        KiePMMLMiningModel kiePMMLMiningModel = (KiePMMLMiningModel)KiePMMLMiningModel.builder((String)name, Collections.emptyList(), (MINING_FUNCTION)MINING_FUNCTION.ASSOCIATION_RULES).withTargetField(targetField).withSegmentation(kiePMMLSegmentation).withOutputFieldsMap(outputFieldsMap).build();
        LinkedHashMap<String, KiePMMLNameValue> inputData = new LinkedHashMap<String, KiePMMLNameValue>();
        inputData.put("FIRST_KEY", new KiePMMLNameValue("FIRST_NAME", (Object)prediction));
        inputData.put("SECOND_KEY", new KiePMMLNameValue("SECOND_NAME", (Object)"SECOND_VALUE"));
        PMML4Result retrieved = this.evaluator.getPMML4Result(kiePMMLMiningModel, inputData);
        Assert.assertNotNull((Object)retrieved);
        Assert.assertEquals((Object)ResultCode.OK.getName(), (Object)retrieved.getResultCode());
        Assert.assertEquals((Object)targetField, (Object)retrieved.getResultObjectName());
        Map resultVariables = retrieved.getResultVariables();
        Assert.assertTrue((boolean)resultVariables.containsKey(targetField));
        Assert.assertEquals((Object)prediction, resultVariables.get(targetField));
    }

    @Test
    public void getPMML4ResultFAIL() {
        String name = "NAME";
        String targetField = "TARGET";
        HashMap outputFieldsMap = new HashMap();
        IntStream.range(0, 3).forEach(index -> outputFieldsMap.put("KEY_" + index, "OBJECT_" + index));
        KiePMMLSegmentation kiePMMLSegmentation = (KiePMMLSegmentation)KiePMMLSegmentation.builder((String)"SEGM_1", Collections.emptyList(), (MULTIPLE_MODEL_METHOD)MULTIPLE_MODEL_METHOD.AVERAGE).build();
        KiePMMLMiningModel kiePMMLMiningModel = (KiePMMLMiningModel)KiePMMLMiningModel.builder((String)name, Collections.emptyList(), (MINING_FUNCTION)MINING_FUNCTION.ASSOCIATION_RULES).withTargetField(targetField).withSegmentation(kiePMMLSegmentation).withOutputFieldsMap(outputFieldsMap).build();
        LinkedHashMap<String, KiePMMLNameValue> inputData = new LinkedHashMap<String, KiePMMLNameValue>();
        inputData.put("FIRST_KEY", new KiePMMLNameValue("FIRST_NAME", (Object)"FIRST_VALUE"));
        inputData.put("SECOND_KEY", new KiePMMLNameValue("SECOND_NAME", (Object)"SECOND_VALUE"));
        PMML4Result retrieved = this.evaluator.getPMML4Result(kiePMMLMiningModel, inputData);
        Assert.assertNotNull((Object)retrieved);
        Assert.assertEquals((Object)ResultCode.FAIL.getName(), (Object)retrieved.getResultCode());
        Assert.assertEquals((Object)targetField, (Object)retrieved.getResultObjectName());
        Map resultVariables = retrieved.getResultVariables();
        Assert.assertTrue((boolean)resultVariables.containsKey(targetField));
        Assert.assertNull(resultVariables.get(targetField));
    }

    @Test
    public void getPMMLRuntime() {
        KieServices kieServices = KieServices.Factory.get();
        KieContainer kieContainer = kieServices.newKieClasspathContainer();
        KieBase kieBase = kieContainer.getKieBase();
        String kModulePackageName = "kModulePackageNameA";
        String containerModelName = "containerModelNameA";
        PMMLRuntime firstRetrieved = this.evaluator.getPMMLRuntime(kModulePackageName, kieBase, containerModelName);
        Assert.assertNotNull((Object)firstRetrieved);
        Assert.assertTrue((boolean)(firstRetrieved instanceof PMMLRuntimeInternal));
        PMMLRuntimeInternal firstPMMLRuntimeInternal = (PMMLRuntimeInternal)firstRetrieved;
        PMMLRuntime secondRetrieved = this.evaluator.getPMMLRuntime(kModulePackageName, kieBase, containerModelName);
        Assert.assertTrue((boolean)(secondRetrieved instanceof PMMLRuntimeInternal));
        PMMLRuntimeInternal secondPMMLRuntimeInternal = (PMMLRuntimeInternal)secondRetrieved;
        Assert.assertEquals((Object)firstPMMLRuntimeInternal.getKnowledgeBase(), (Object)secondPMMLRuntimeInternal.getKnowledgeBase());
        kModulePackageName = "kModulePackageNameB";
        containerModelName = "containerModelNameB";
        PMMLRuntime thirdRetrieved = this.evaluator.getPMMLRuntime(kModulePackageName, kieBase, containerModelName);
        Assert.assertNotNull((Object)thirdRetrieved);
        Assert.assertTrue((boolean)(thirdRetrieved instanceof PMMLRuntimeInternal));
        PMMLRuntimeInternal thirdPMMLRuntimeInternal = (PMMLRuntimeInternal)thirdRetrieved;
        Assert.assertNotEquals((Object)firstPMMLRuntimeInternal.getKnowledgeBase(), (Object)thirdPMMLRuntimeInternal.getKnowledgeBase());
    }

    @Test
    public void getKiePMMLNameRawObject() {
        String rawObject = "OBJ";
        PMML4Result pmml4Result = this.getPMML4Result(rawObject);
        RAW_OBJECT_METHODS.forEach(multipleModelMethod -> {
            KiePMMLNameValue retrieved = this.evaluator.getKiePMMLNameValue(pmml4Result, multipleModelMethod, 34.2);
            Assert.assertEquals((Object)pmml4Result.getResultObjectName(), (Object)retrieved.getName());
            Assert.assertNotNull((Object)retrieved.getValue());
            Assert.assertEquals((Object)rawObject, (Object)retrieved.getValue());
        });
    }

    @Test
    public void getKiePMMLNameValueValueWeightNumber() {
        Integer rawObject = 24;
        PMML4Result pmml4Result = this.getPMML4Result(rawObject);
        double weight = 2.23;
        double expected = rawObject.doubleValue();
        VALUE_WEIGHT_METHODS.forEach(multipleModelMethod -> {
            KiePMMLNameValue retrieved = this.evaluator.getKiePMMLNameValue(pmml4Result, multipleModelMethod, 2.23);
            Assert.assertNotNull((Object)retrieved);
            Assert.assertEquals((Object)pmml4Result.getResultObjectName(), (Object)retrieved.getName());
            Assert.assertNotNull((Object)retrieved.getValue());
            Assert.assertTrue((boolean)(retrieved.getValue() instanceof KiePMMLValueWeight));
            KiePMMLValueWeight kiePMMLValueWeight = (KiePMMLValueWeight)retrieved.getValue();
            Assert.assertEquals((double)expected, (double)kiePMMLValueWeight.getValue(), (double)0.0);
            Assert.assertEquals((double)2.23, (double)kiePMMLValueWeight.getWeight(), (double)0.0);
        });
    }

    @Test
    public void getKiePMMLNameValueWeightNoNumber() {
        PMML4Result pmml4Result = this.getPMML4Result("OBJ");
        VALUE_WEIGHT_METHODS.forEach(multipleModelMethod -> {
            try {
                this.evaluator.getKiePMMLNameValue(pmml4Result, multipleModelMethod, 34.2);
                Assert.fail((String)(multipleModelMethod + " is supposed to throw exception because raw object is not a number"));
            }
            catch (KiePMMLException kiePMMLException) {
                // empty catch block
            }
        });
    }

    @Test
    public void getKiePMMLNameValueNotImplemented() {
        PMML4Result pmml4Result = this.getPMML4Result("OBJ");
        NOT_IMPLEMENTED_METHODS.forEach(multipleModelMethod -> {
            try {
                this.evaluator.getKiePMMLNameValue(pmml4Result, multipleModelMethod, 34.2);
                Assert.fail((String)(multipleModelMethod + " is supposed to throw exception because not implemented"));
            }
            catch (KiePMMLException kiePMMLException) {
                // empty catch block
            }
        });
    }

    @Test
    public void getEventuallyWeightedResultRawObject() {
        String rawObject = "OBJ";
        RAW_OBJECT_METHODS.forEach(multipleModelMethod -> {
            Object retrieved = this.evaluator.getEventuallyWeightedResult(rawObject, multipleModelMethod, 34.2);
            Assert.assertNotNull((Object)retrieved);
            Assert.assertEquals((Object)rawObject, (Object)retrieved);
        });
    }

    @Test
    public void getEventuallyWeightedResultValueWeightNumber() {
        Integer rawObject = 24;
        double weight = 2.23;
        VALUE_WEIGHT_METHODS.forEach(multipleModelMethod -> {
            Object retrieved = this.evaluator.getEventuallyWeightedResult((Object)rawObject, multipleModelMethod, 2.23);
            Assert.assertNotNull((Object)retrieved);
            Assert.assertTrue((boolean)(retrieved instanceof KiePMMLValueWeight));
            KiePMMLValueWeight kiePMMLValueWeight = (KiePMMLValueWeight)retrieved;
            Assert.assertEquals((double)rawObject.doubleValue(), (double)kiePMMLValueWeight.getValue(), (double)0.0);
            Assert.assertEquals((double)2.23, (double)kiePMMLValueWeight.getWeight(), (double)0.0);
        });
    }

    @Test
    public void getEventuallyWeightedResultValueWeightNoNumber() {
        VALUE_WEIGHT_METHODS.forEach(multipleModelMethod -> {
            try {
                this.evaluator.getEventuallyWeightedResult((Object)"OBJ", multipleModelMethod, 34.2);
                Assert.fail((String)(multipleModelMethod + " is supposed to throw exception because raw object is not a number"));
            }
            catch (KiePMMLException kiePMMLException) {
                // empty catch block
            }
        });
    }

    @Test
    public void getEventuallyWeightedResultNotImplemented() {
        NOT_IMPLEMENTED_METHODS.forEach(multipleModelMethod -> {
            try {
                this.evaluator.getEventuallyWeightedResult((Object)"OBJ", multipleModelMethod, 34.2);
                Assert.fail((String)(multipleModelMethod + " is supposed to throw exception because not implemented"));
            }
            catch (KiePMMLException kiePMMLException) {
                // empty catch block
            }
        });
    }

    @Test
    public void validateKiePMMLMiningModel() {
        String name = "NAME";
        KiePMMLMiningModel kiePMMLMiningModel = (KiePMMLMiningModel)KiePMMLMiningModel.builder((String)name, Collections.emptyList(), (MINING_FUNCTION)MINING_FUNCTION.ASSOCIATION_RULES).withTargetField("TARGET").build();
        this.evaluator.validate((KiePMMLModel)kiePMMLMiningModel);
    }

    @Test(expected=KiePMMLModelException.class)
    public void validateNoKiePMMLMiningModel() {
        String name = "NAME";
        KiePMMLTestingModel kiePMMLModel = new KiePMMLTestingModel(name, Collections.emptyList());
        this.evaluator.validate((KiePMMLModel)kiePMMLModel);
    }

    @Test
    public void validateMiningTargetField() {
        String name = "NAME";
        KiePMMLMiningModel kiePMMLMiningModel = (KiePMMLMiningModel)KiePMMLMiningModel.builder((String)name, Collections.emptyList(), (MINING_FUNCTION)MINING_FUNCTION.ASSOCIATION_RULES).withTargetField("TARGET").build();
        this.evaluator.validateMining(kiePMMLMiningModel);
    }

    @Test(expected=KiePMMLInternalException.class)
    public void validateMiningEmptyTargetField() {
        String name = "NAME";
        KiePMMLMiningModel kiePMMLMiningModel = (KiePMMLMiningModel)KiePMMLMiningModel.builder((String)name, Collections.emptyList(), (MINING_FUNCTION)MINING_FUNCTION.ASSOCIATION_RULES).withTargetField("     ").build();
        this.evaluator.validateMining(kiePMMLMiningModel);
    }

    @Test(expected=KiePMMLInternalException.class)
    public void validateMiningNoTargetField() {
        String name = "NAME";
        KiePMMLMiningModel kiePMMLMiningModel = (KiePMMLMiningModel)KiePMMLMiningModel.builder((String)name, Collections.emptyList(), (MINING_FUNCTION)MINING_FUNCTION.ASSOCIATION_RULES).build();
        this.evaluator.validateMining(kiePMMLMiningModel);
    }

    private PMML4Result getPMML4Result(Object rawObject) {
        String resultObjectName = "RESULT";
        PMML4Result toReturn = new PMML4Result();
        toReturn.addResultVariable("RESULT", rawObject);
        toReturn.setResultObjectName("RESULT");
        return toReturn;
    }
}

