/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.models.mining.model.enums;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.junit.Assert;
import org.junit.Test;
import org.kie.pmml.commons.exceptions.KieEnumException;
import org.kie.pmml.commons.model.tuples.KiePMMLNameValue;
import org.kie.pmml.commons.model.tuples.KiePMMLValueWeight;
import org.kie.pmml.models.mining.model.enums.MULTIPLE_MODEL_METHOD;

public class MULTIPLE_MODEL_METHODTest {
    private final Map<MULTIPLE_MODEL_METHOD, String> EXISTING_VALUES = Stream.of(new AbstractMap.SimpleEntry<MULTIPLE_MODEL_METHOD, String>(MULTIPLE_MODEL_METHOD.MAJORITY_VOTE, "majorityVote"), new AbstractMap.SimpleEntry<MULTIPLE_MODEL_METHOD, String>(MULTIPLE_MODEL_METHOD.WEIGHTED_MAJORITY_VOTE, "weightedMajorityVote"), new AbstractMap.SimpleEntry<MULTIPLE_MODEL_METHOD, String>(MULTIPLE_MODEL_METHOD.AVERAGE, "average"), new AbstractMap.SimpleEntry<MULTIPLE_MODEL_METHOD, String>(MULTIPLE_MODEL_METHOD.WEIGHTED_AVERAGE, "weightedAverage"), new AbstractMap.SimpleEntry<MULTIPLE_MODEL_METHOD, String>(MULTIPLE_MODEL_METHOD.MEDIAN, "median"), new AbstractMap.SimpleEntry<MULTIPLE_MODEL_METHOD, String>(MULTIPLE_MODEL_METHOD.WEIGHTED_MEDIAN, "x-weightedMedian"), new AbstractMap.SimpleEntry<MULTIPLE_MODEL_METHOD, String>(MULTIPLE_MODEL_METHOD.MAX, "max"), new AbstractMap.SimpleEntry<MULTIPLE_MODEL_METHOD, String>(MULTIPLE_MODEL_METHOD.SUM, "sum"), new AbstractMap.SimpleEntry<MULTIPLE_MODEL_METHOD, String>(MULTIPLE_MODEL_METHOD.WEIGHTED_SUM, "x-weightedSum"), new AbstractMap.SimpleEntry<MULTIPLE_MODEL_METHOD, String>(MULTIPLE_MODEL_METHOD.SELECT_FIRST, "selectFirst"), new AbstractMap.SimpleEntry<MULTIPLE_MODEL_METHOD, String>(MULTIPLE_MODEL_METHOD.SELECT_ALL, "selectAll"), new AbstractMap.SimpleEntry<MULTIPLE_MODEL_METHOD, String>(MULTIPLE_MODEL_METHOD.MODEL_CHAIN, "modelChain")).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    private final List<MULTIPLE_MODEL_METHOD> UNIMPLEMENTED = Arrays.asList(MULTIPLE_MODEL_METHOD.WEIGHTED_MAJORITY_VOTE, MULTIPLE_MODEL_METHOD.MODEL_CHAIN);

    @Test
    public void byNameExisting() {
        this.EXISTING_VALUES.values().forEach(s -> Assert.assertNotNull((Object)MULTIPLE_MODEL_METHOD.byName((String)s)));
    }

    @Test(expected=KieEnumException.class)
    public void byNameNotExisting() {
        MULTIPLE_MODEL_METHOD.byName((String)"NOT_EXISTING");
    }

    @Test
    public void getName() {
        this.EXISTING_VALUES.forEach((multipleModelMethod, s) -> Assert.assertEquals((Object)s, (Object)multipleModelMethod.getName()));
    }

    @Test
    public void applyMAJORITY_VOTE() {
        LinkedHashMap<String, KiePMMLNameValue> inputData = new LinkedHashMap<String, KiePMMLNameValue>();
        Object EXPECTED = 3;
        inputData.put("ValueA", new KiePMMLNameValue("valuea", (Object)1));
        inputData.put("ValueB", new KiePMMLNameValue("valueb", EXPECTED));
        inputData.put("ValueC", new KiePMMLNameValue("valuec", EXPECTED));
        inputData.put("ValueD", new KiePMMLNameValue("valuex", EXPECTED));
        inputData.put("ValueE", new KiePMMLNameValue("valueb", (Object)1));
        Object retrieved = MULTIPLE_MODEL_METHOD.MAJORITY_VOTE.apply(inputData);
        Assert.assertEquals((Object)EXPECTED, (Object)retrieved);
        inputData = new LinkedHashMap();
        EXPECTED = "EXPECTED";
        inputData.put("ValueA", new KiePMMLNameValue("valuea", (Object)"dvsdv"));
        inputData.put("ValueB", new KiePMMLNameValue("valueb", EXPECTED));
        inputData.put("ValueC", new KiePMMLNameValue("valuec", (Object)"dssd"));
        inputData.put("ValueD", new KiePMMLNameValue("valuex", EXPECTED));
        inputData.put("ValueE", new KiePMMLNameValue("valueb", (Object)"vsd"));
        retrieved = MULTIPLE_MODEL_METHOD.MAJORITY_VOTE.apply(inputData);
        Assert.assertEquals((Object)EXPECTED, (Object)retrieved);
    }

    @Test(expected=KieEnumException.class)
    public void applyWEIGHTED_MAJORITY_VOTE() {
        LinkedHashMap<String, KiePMMLNameValue> inputData = new LinkedHashMap<String, KiePMMLNameValue>();
        Integer EXPECTED = 3;
        inputData.put("ValueA", new KiePMMLNameValue("valuea", (Object)1));
        inputData.put("ValueB", new KiePMMLNameValue("valueb", (Object)EXPECTED));
        inputData.put("ValueC", new KiePMMLNameValue("valuec", (Object)EXPECTED));
        inputData.put("ValueD", new KiePMMLNameValue("valuex", (Object)EXPECTED));
        inputData.put("ValueE", new KiePMMLNameValue("valueb", (Object)1));
        MULTIPLE_MODEL_METHOD.WEIGHTED_MAJORITY_VOTE.apply(inputData);
    }

    @Test
    public void applyAVERAGEKiePMMLValueWeight() {
        Map<String, Object> expectedKiePMMLValueWeightMap = this.getExpectedKiePMMLValueWeightMap(true);
        double average = (Double)expectedKiePMMLValueWeightMap.get("average");
        LinkedHashMap inputData = (LinkedHashMap)expectedKiePMMLValueWeightMap.get("inputData");
        double retrieved = (Double)MULTIPLE_MODEL_METHOD.AVERAGE.apply(inputData);
        Assert.assertEquals((double)average, (double)retrieved, (double)1.0E-13);
        expectedKiePMMLValueWeightMap = this.getExpectedKiePMMLValueWeightMap(false);
        average = (Double)expectedKiePMMLValueWeightMap.get("average");
        inputData = (LinkedHashMap)expectedKiePMMLValueWeightMap.get("inputData");
        retrieved = (Double)MULTIPLE_MODEL_METHOD.AVERAGE.apply(inputData);
        Assert.assertEquals((double)average, (double)retrieved, (double)1.0E-13);
    }

    @Test(expected=KieEnumException.class)
    public void applyAVERAGENotKiePMMLValueWeight() {
        LinkedHashMap<String, KiePMMLNameValue> inputData = new LinkedHashMap<String, KiePMMLNameValue>();
        String EXPECTED = "EXPECTED";
        inputData.put("ValueA", new KiePMMLNameValue("valuea", (Object)"dvsdv"));
        inputData.put("ValueB", new KiePMMLNameValue("valueb", (Object)EXPECTED));
        inputData.put("ValueC", new KiePMMLNameValue("valuec", (Object)"dssd"));
        inputData.put("ValueD", new KiePMMLNameValue("valuex", (Object)EXPECTED));
        inputData.put("ValueE", new KiePMMLNameValue("valueb", (Object)"vsd"));
        MULTIPLE_MODEL_METHOD.AVERAGE.apply(inputData);
    }

    @Test
    public void applyWEIGHTED_AVERAGEKiePMMLValueWeight() {
        Map<String, Object> expectedKiePMMLValueWeightMap = this.getExpectedKiePMMLValueWeightMap(true);
        double weightedAverage = (Double)expectedKiePMMLValueWeightMap.get("weightedAverage");
        LinkedHashMap inputData = (LinkedHashMap)expectedKiePMMLValueWeightMap.get("inputData");
        double retrieved = (Double)MULTIPLE_MODEL_METHOD.WEIGHTED_AVERAGE.apply(inputData);
        Assert.assertEquals((double)weightedAverage, (double)retrieved, (double)1.0E-13);
        expectedKiePMMLValueWeightMap = this.getExpectedKiePMMLValueWeightMap(false);
        weightedAverage = (Double)expectedKiePMMLValueWeightMap.get("weightedAverage");
        inputData = (LinkedHashMap)expectedKiePMMLValueWeightMap.get("inputData");
        retrieved = (Double)MULTIPLE_MODEL_METHOD.WEIGHTED_AVERAGE.apply(inputData);
        Assert.assertEquals((double)weightedAverage, (double)retrieved, (double)1.0E-13);
    }

    @Test(expected=KieEnumException.class)
    public void applyWEIGHTED_AVERAGENotKiePMMLValueWeight() {
        LinkedHashMap<String, KiePMMLNameValue> inputData = new LinkedHashMap<String, KiePMMLNameValue>();
        String EXPECTED = "EXPECTED";
        inputData.put("ValueA", new KiePMMLNameValue("valuea", (Object)"dvsdv"));
        inputData.put("ValueB", new KiePMMLNameValue("valueb", (Object)EXPECTED));
        inputData.put("ValueC", new KiePMMLNameValue("valuec", (Object)"dssd"));
        inputData.put("ValueD", new KiePMMLNameValue("valuex", (Object)EXPECTED));
        inputData.put("ValueE", new KiePMMLNameValue("valueb", (Object)"vsd"));
        MULTIPLE_MODEL_METHOD.WEIGHTED_AVERAGE.apply(inputData);
    }

    @Test
    public void applyMEDIANNumbers() {
        Map<String, Object> expectedKiePMMLValueWeightMap = this.getExpectedKiePMMLValueWeightMap(true);
        double median = (Double)expectedKiePMMLValueWeightMap.get("median");
        LinkedHashMap inputData = (LinkedHashMap)expectedKiePMMLValueWeightMap.get("inputData");
        double retrieved = (Double)MULTIPLE_MODEL_METHOD.MEDIAN.apply(inputData);
        Assert.assertEquals((double)median, (double)retrieved, (double)1.0E-13);
        expectedKiePMMLValueWeightMap = this.getExpectedKiePMMLValueWeightMap(false);
        median = (Double)expectedKiePMMLValueWeightMap.get("median");
        inputData = (LinkedHashMap)expectedKiePMMLValueWeightMap.get("inputData");
        retrieved = (Double)MULTIPLE_MODEL_METHOD.MEDIAN.apply(inputData);
        Assert.assertEquals((double)median, (double)retrieved, (double)1.0E-13);
    }

    @Test(expected=KieEnumException.class)
    public void applyMEDIANNotNumbers() {
        LinkedHashMap<String, KiePMMLNameValue> inputData = new LinkedHashMap<String, KiePMMLNameValue>();
        String EXPECTED = "EXPECTED";
        inputData.put("ValueA", new KiePMMLNameValue("valuea", (Object)"dvsdv"));
        inputData.put("ValueB", new KiePMMLNameValue("valueb", (Object)EXPECTED));
        inputData.put("ValueC", new KiePMMLNameValue("valuec", (Object)"dssd"));
        inputData.put("ValueD", new KiePMMLNameValue("valuex", (Object)EXPECTED));
        inputData.put("ValueE", new KiePMMLNameValue("valueb", (Object)"vsd"));
        MULTIPLE_MODEL_METHOD.MEDIAN.apply(inputData);
    }

    @Test
    public void applyWEIGHTED_MEDIANNumbers() {
        Map<String, Object> expectedKiePMMLValueWeightMap = this.getExpectedKiePMMLValueWeightMap(true);
        double weightedMedian = (Double)expectedKiePMMLValueWeightMap.get("weightedMedian");
        LinkedHashMap inputData = (LinkedHashMap)expectedKiePMMLValueWeightMap.get("inputData");
        double retrieved = (Double)MULTIPLE_MODEL_METHOD.WEIGHTED_MEDIAN.apply(inputData);
        Assert.assertEquals((double)weightedMedian, (double)retrieved, (double)1.0E-13);
        expectedKiePMMLValueWeightMap = this.getExpectedKiePMMLValueWeightMap(false);
        weightedMedian = (Double)expectedKiePMMLValueWeightMap.get("weightedMedian");
        inputData = (LinkedHashMap)expectedKiePMMLValueWeightMap.get("inputData");
        retrieved = (Double)MULTIPLE_MODEL_METHOD.WEIGHTED_MEDIAN.apply(inputData);
        Assert.assertEquals((double)weightedMedian, (double)retrieved, (double)1.0E-13);
    }

    @Test(expected=KieEnumException.class)
    public void applyWEIGHTED_MEDIANNotNumbers() {
        LinkedHashMap<String, KiePMMLNameValue> inputData = new LinkedHashMap<String, KiePMMLNameValue>();
        String EXPECTED = "EXPECTED";
        inputData.put("ValueA", new KiePMMLNameValue("valuea", (Object)"dvsdv"));
        inputData.put("ValueB", new KiePMMLNameValue("valueb", (Object)EXPECTED));
        inputData.put("ValueC", new KiePMMLNameValue("valuec", (Object)"dssd"));
        inputData.put("ValueD", new KiePMMLNameValue("valuex", (Object)EXPECTED));
        inputData.put("ValueE", new KiePMMLNameValue("valueb", (Object)"vsd"));
        MULTIPLE_MODEL_METHOD.WEIGHTED_MEDIAN.apply(inputData);
    }

    @Test
    public void applyMAXNumbers() {
        Map<String, Object> expectedKiePMMLValueWeightMap = this.getExpectedKiePMMLValueWeightMap(true);
        double max = (Double)expectedKiePMMLValueWeightMap.get("max");
        LinkedHashMap inputData = (LinkedHashMap)expectedKiePMMLValueWeightMap.get("inputData");
        double retrieved = (Double)MULTIPLE_MODEL_METHOD.MAX.apply(inputData);
        Assert.assertEquals((double)max, (double)retrieved, (double)1.0E-13);
        expectedKiePMMLValueWeightMap = this.getExpectedKiePMMLValueWeightMap(false);
        max = (Double)expectedKiePMMLValueWeightMap.get("max");
        inputData = (LinkedHashMap)expectedKiePMMLValueWeightMap.get("inputData");
        retrieved = (Double)MULTIPLE_MODEL_METHOD.MAX.apply(inputData);
        Assert.assertEquals((double)max, (double)retrieved, (double)1.0E-13);
    }

    @Test(expected=KieEnumException.class)
    public void applyMAXNotNumbers() {
        LinkedHashMap<String, KiePMMLNameValue> inputData = new LinkedHashMap<String, KiePMMLNameValue>();
        String EXPECTED = "EXPECTED";
        inputData.put("ValueA", new KiePMMLNameValue("valuea", (Object)"dvsdv"));
        inputData.put("ValueB", new KiePMMLNameValue("valueb", (Object)EXPECTED));
        inputData.put("ValueC", new KiePMMLNameValue("valuec", (Object)"dssd"));
        inputData.put("ValueD", new KiePMMLNameValue("valuex", (Object)EXPECTED));
        inputData.put("ValueE", new KiePMMLNameValue("valueb", (Object)"vsd"));
        MULTIPLE_MODEL_METHOD.MAX.apply(inputData);
    }

    @Test
    public void applySUMNumbers() {
        Map<String, Object> expectedKiePMMLValueWeightMap = this.getExpectedKiePMMLValueWeightMap(true);
        double sum = (Double)expectedKiePMMLValueWeightMap.get("sum");
        LinkedHashMap inputData = (LinkedHashMap)expectedKiePMMLValueWeightMap.get("inputData");
        double retrieved = (Double)MULTIPLE_MODEL_METHOD.SUM.apply(inputData);
        Assert.assertEquals((double)sum, (double)retrieved, (double)1.0E-13);
        expectedKiePMMLValueWeightMap = this.getExpectedKiePMMLValueWeightMap(false);
        sum = (Double)expectedKiePMMLValueWeightMap.get("sum");
        inputData = (LinkedHashMap)expectedKiePMMLValueWeightMap.get("inputData");
        retrieved = (Double)MULTIPLE_MODEL_METHOD.SUM.apply(inputData);
        Assert.assertEquals((double)sum, (double)retrieved, (double)1.0E-13);
    }

    @Test(expected=KieEnumException.class)
    public void applySUMNotNumbers() {
        LinkedHashMap<String, KiePMMLNameValue> inputData = new LinkedHashMap<String, KiePMMLNameValue>();
        String EXPECTED = "EXPECTED";
        inputData.put("ValueA", new KiePMMLNameValue("valuea", (Object)"dvsdv"));
        inputData.put("ValueB", new KiePMMLNameValue("valueb", (Object)EXPECTED));
        inputData.put("ValueC", new KiePMMLNameValue("valuec", (Object)"dssd"));
        inputData.put("ValueD", new KiePMMLNameValue("valuex", (Object)EXPECTED));
        inputData.put("ValueE", new KiePMMLNameValue("valueb", (Object)"vsd"));
        MULTIPLE_MODEL_METHOD.SUM.apply(inputData);
    }

    @Test
    public void applyWEIGHTED_SUMNumbers() {
        Map<String, Object> expectedKiePMMLValueWeightMap = this.getExpectedKiePMMLValueWeightMap(true);
        double weightsSum = (Double)expectedKiePMMLValueWeightMap.get("weightedSum");
        LinkedHashMap inputData = (LinkedHashMap)expectedKiePMMLValueWeightMap.get("inputData");
        double retrieved = (Double)MULTIPLE_MODEL_METHOD.WEIGHTED_SUM.apply(inputData);
        Assert.assertEquals((double)weightsSum, (double)retrieved, (double)1.0E-13);
        expectedKiePMMLValueWeightMap = this.getExpectedKiePMMLValueWeightMap(false);
        weightsSum = (Double)expectedKiePMMLValueWeightMap.get("weightedSum");
        inputData = (LinkedHashMap)expectedKiePMMLValueWeightMap.get("inputData");
        retrieved = (Double)MULTIPLE_MODEL_METHOD.WEIGHTED_SUM.apply(inputData);
        Assert.assertEquals((double)weightsSum, (double)retrieved, (double)1.0E-13);
    }

    @Test(expected=KieEnumException.class)
    public void applyWEIGHTED_SUMNotNumbers() {
        LinkedHashMap<String, KiePMMLNameValue> inputData = new LinkedHashMap<String, KiePMMLNameValue>();
        String EXPECTED = "EXPECTED";
        inputData.put("ValueA", new KiePMMLNameValue("valuea", (Object)"dvsdv"));
        inputData.put("ValueB", new KiePMMLNameValue("valueb", (Object)EXPECTED));
        inputData.put("ValueC", new KiePMMLNameValue("valuec", (Object)"dssd"));
        inputData.put("ValueD", new KiePMMLNameValue("valuex", (Object)EXPECTED));
        inputData.put("ValueE", new KiePMMLNameValue("valueb", (Object)"vsd"));
        MULTIPLE_MODEL_METHOD.WEIGHTED_SUM.apply(inputData);
    }

    @Test
    public void applySELECT_FIRSTNumbers() {
        Map<String, Object> expectedKiePMMLValueWeightMap = this.getExpectedKiePMMLValueWeightMap(true);
        LinkedHashMap inputData = (LinkedHashMap)expectedKiePMMLValueWeightMap.get("inputData");
        double first = ((KiePMMLValueWeight)((KiePMMLNameValue)inputData.entrySet().iterator().next().getValue()).getValue()).getValue();
        double retrieved = (Double)MULTIPLE_MODEL_METHOD.SELECT_FIRST.apply(inputData);
        Assert.assertEquals((double)first, (double)retrieved, (double)1.0E-13);
        expectedKiePMMLValueWeightMap = this.getExpectedKiePMMLValueWeightMap(false);
        inputData = (LinkedHashMap)expectedKiePMMLValueWeightMap.get("inputData");
        first = ((KiePMMLValueWeight)((KiePMMLNameValue)inputData.entrySet().iterator().next().getValue()).getValue()).getValue();
        retrieved = (Double)MULTIPLE_MODEL_METHOD.SELECT_FIRST.apply(inputData);
        Assert.assertEquals((double)first, (double)retrieved, (double)1.0E-13);
    }

    @Test
    public void applySELECT_FIRSTNotNumbers() {
        LinkedHashMap<String, KiePMMLNameValue> inputData = new LinkedHashMap<String, KiePMMLNameValue>();
        String EXPECTED = "EXPECTED";
        inputData.put("ValueA", new KiePMMLNameValue("valuea", (Object)EXPECTED));
        inputData.put("ValueB", new KiePMMLNameValue("valueb", (Object)"vdsvsd"));
        inputData.put("ValueC", new KiePMMLNameValue("valuec", (Object)"dssd"));
        inputData.put("ValueD", new KiePMMLNameValue("valuex", (Object)"vfdsvsdeeee"));
        inputData.put("ValueE", new KiePMMLNameValue("valueb", (Object)"vsd"));
        Object retrieved = MULTIPLE_MODEL_METHOD.SELECT_FIRST.apply(inputData);
        Assert.assertEquals((Object)EXPECTED, (Object)retrieved);
    }

    @Test
    public void applySELECT_ALLNumbers() {
        Map<String, Object> expectedKiePMMLValueWeightMap = this.getExpectedKiePMMLValueWeightMap(true);
        LinkedHashMap inputData = (LinkedHashMap)expectedKiePMMLValueWeightMap.get("inputData");
        List expected = inputData.values().stream().map(kiePMMLNameValue -> ((KiePMMLValueWeight)kiePMMLNameValue.getValue()).getValue()).collect(Collectors.toList());
        List retrieved = (List)MULTIPLE_MODEL_METHOD.SELECT_ALL.apply(inputData);
        Assert.assertEquals((long)expected.size(), (long)retrieved.size());
        for (Double expDouble : expected) {
            Assert.assertTrue((boolean)retrieved.contains(expDouble));
        }
        expectedKiePMMLValueWeightMap = this.getExpectedKiePMMLValueWeightMap(false);
        inputData = (LinkedHashMap)expectedKiePMMLValueWeightMap.get("inputData");
        expected = inputData.values().stream().map(kiePMMLNameValue -> ((KiePMMLValueWeight)kiePMMLNameValue.getValue()).getValue()).collect(Collectors.toList());
        retrieved = (List)MULTIPLE_MODEL_METHOD.SELECT_ALL.apply(inputData);
        Assert.assertEquals((long)expected.size(), (long)retrieved.size());
        for (Double expDouble : expected) {
            Assert.assertTrue((boolean)retrieved.contains(expDouble));
        }
    }

    @Test
    public void applySELECT_ALLNotNumbers() {
        LinkedHashMap<String, KiePMMLNameValue> inputData = new LinkedHashMap<String, KiePMMLNameValue>();
        inputData.put("ValueA", new KiePMMLNameValue("valuea", (Object)"fvdsfsdfsd"));
        inputData.put("ValueB", new KiePMMLNameValue("valueb", (Object)"vdsvsd"));
        inputData.put("ValueC", new KiePMMLNameValue("valuec", (Object)"dssd"));
        inputData.put("ValueD", new KiePMMLNameValue("valuex", (Object)"vfdsvsdeeee"));
        inputData.put("ValueE", new KiePMMLNameValue("valueb", (Object)"vsd"));
        List<Object> expected = inputData.values().stream().map(KiePMMLNameValue::getValue).collect(Collectors.toList());
        List retrieved = (List)MULTIPLE_MODEL_METHOD.SELECT_ALL.apply(inputData);
        Assert.assertEquals((long)expected.size(), (long)retrieved.size());
        expected.forEach(expString -> Assert.assertTrue((boolean)retrieved.contains(expString)));
    }

    @Test(expected=KieEnumException.class)
    public void applyMODEL_CHAIN() {
        MULTIPLE_MODEL_METHOD.MODEL_CHAIN.apply(new LinkedHashMap());
    }

    private Map<String, Object> getExpectedKiePMMLValueWeightMap(boolean evenNumberOfData) {
        LinkedHashMap<String, KiePMMLNameValue> inputData = new LinkedHashMap<String, KiePMMLNameValue>();
        int numberOfData = evenNumberOfData ? 8 : 9;
        ArrayList valueWeightList = new ArrayList();
        double seed = 0.35;
        AtomicReference<Double> WEIGHT_SEED = new AtomicReference<Double>(seed);
        IntStream.range(0, numberOfData).forEach(i -> {
            double weight;
            if (i < numberOfData - 1) {
                weight = ThreadLocalRandom.current().nextDouble(0.0, 1.0 - (Double)WEIGHT_SEED.get());
                WEIGHT_SEED.accumulateAndGet(weight, Double::sum);
            } else {
                weight = 1.0 - (Double)WEIGHT_SEED.get() + seed;
            }
            double value = ThreadLocalRandom.current().nextDouble(3.0, 10.0);
            valueWeightList.add(new KiePMMLValueWeight(value, weight));
        });
        double sum = 0.0;
        double weightedSum = 0.0;
        double weightsSum = 0.0;
        int i2 = 0;
        for (KiePMMLValueWeight valueWeight : valueWeightList) {
            inputData.put("Value" + i2, new KiePMMLNameValue("val-" + i2, (Object)valueWeight));
            sum += valueWeight.getValue();
            weightedSum += valueWeight.weightedValue();
            weightsSum += valueWeight.getWeight();
            ++i2;
        }
        HashMap<String, Object> toReturn = new HashMap<String, Object>();
        toReturn.put("inputData", inputData);
        toReturn.put("sum", sum);
        toReturn.put("weightedSum", weightedSum);
        double average = sum / (double)inputData.values().size();
        toReturn.put("average", average);
        double weightedAverage = weightedSum / weightsSum;
        toReturn.put("weightedAverage", weightedAverage);
        valueWeightList.sort((o1, o2) -> {
            int toReturn1 = 0;
            if (o1.getValue() > o2.getValue()) {
                toReturn1 = 1;
            } else if (o1.getValue() < o2.getValue()) {
                toReturn1 = -1;
            }
            return toReturn1;
        });
        double median = 0.0;
        median = evenNumberOfData ? (((KiePMMLValueWeight)valueWeightList.get(3)).getValue() + ((KiePMMLValueWeight)valueWeightList.get(4)).getValue()) / 2.0 : ((KiePMMLValueWeight)valueWeightList.get(4)).getValue();
        toReturn.put("median", median);
        double halfWeight = weightsSum / 2.0;
        double weightedMedianSum = 0.0;
        double weightedMedian = 0.0;
        for (KiePMMLValueWeight tuple : valueWeightList) {
            if (!((weightedMedianSum += tuple.getWeight()) >= halfWeight)) continue;
            weightedMedian = tuple.getValue();
            break;
        }
        toReturn.put("weightedMedian", weightedMedian);
        double max = ((KiePMMLValueWeight)valueWeightList.get(valueWeightList.size() - 1)).getValue();
        toReturn.put("max", max);
        return toReturn;
    }
}

