/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.models.mining.model;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.pmml.api.exceptions.KiePMMLException;
import org.kie.pmml.models.mining.model.KiePMMLMiningModelWithSources;

public class KiePMMLMiningModelWithSourcesTest {
    private static final String MINING_MODEL_NAME = "MINING_MODEL_NAME";
    private static final Map<String, String> SOURCES_MAP = new HashMap<String, String>();
    private KiePMMLMiningModelWithSources kiePMMLMiningModelWithSources;

    @Before
    public void setup() {
        this.kiePMMLMiningModelWithSources = new KiePMMLMiningModelWithSources(MINING_MODEL_NAME, "PACKAGE_NAME", SOURCES_MAP, Collections.emptyList());
    }

    @Test(expected=KiePMMLException.class)
    public void evaluate() {
        this.kiePMMLMiningModelWithSources.evaluate((Object)"KB", Collections.EMPTY_MAP);
    }

    @Test(expected=KiePMMLException.class)
    public void getOutputFieldsMap() {
        this.kiePMMLMiningModelWithSources.getOutputFieldsMap();
    }

    @Test
    public void getSourcesMap() {
        Assert.assertEquals(SOURCES_MAP, (Object)this.kiePMMLMiningModelWithSources.getSourcesMap());
    }

    @Test(expected=UnsupportedOperationException.class)
    public void addToGetSourcesMap() {
        Map retrieved = this.kiePMMLMiningModelWithSources.getSourcesMap();
        retrieved.put("KEY", "VALUE");
    }

    @Test
    public void addSourceMap() {
        Map retrieved = this.kiePMMLMiningModelWithSources.getSourcesMap();
        Assert.assertTrue((boolean)retrieved.isEmpty());
        this.kiePMMLMiningModelWithSources.addSourceMap("KEY", "VALUE");
        retrieved = this.kiePMMLMiningModelWithSources.getSourcesMap();
        Assert.assertTrue((boolean)retrieved.containsKey("KEY"));
        Assert.assertEquals((Object)"VALUE", retrieved.get("KEY"));
    }
}

