/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.models.mining.model;

import java.util.Collections;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.kie.pmml.api.enums.MINING_FUNCTION;
import org.kie.pmml.api.exceptions.KiePMMLException;
import org.kie.pmml.api.runtime.PMMLContext;
import org.kie.pmml.commons.testingutility.PMMLContextTest;
import org.kie.pmml.models.mining.model.AbstractKiePMMLMiningModelTest;
import org.kie.pmml.models.mining.model.KiePMMLMiningModel;
import org.kie.pmml.models.mining.model.segmentation.KiePMMLSegmentation;

public class KiePMMLMiningModelTest {
    private static final String MINING_MODEL_NAME = "MINING_MODEL_NAME";
    private static final MINING_FUNCTION MININGFUNCTION = MINING_FUNCTION.REGRESSION;
    private static KiePMMLMiningModel.Builder BUILDER;
    private static KiePMMLMiningModel KIE_PMML_MINING_MODEL;

    @BeforeClass
    public static void setup() {
        BUILDER = KiePMMLMiningModel.builder((String)MINING_MODEL_NAME, Collections.emptyList(), (MINING_FUNCTION)MININGFUNCTION);
        Assert.assertNotNull((Object)BUILDER);
        KIE_PMML_MINING_MODEL = (KiePMMLMiningModel)BUILDER.build();
        Assert.assertNotNull((Object)KIE_PMML_MINING_MODEL);
    }

    @Test(expected=KiePMMLException.class)
    public void evaluate() {
        KIE_PMML_MINING_MODEL.evaluate((Object)"KB", Collections.EMPTY_MAP, (PMMLContext)new PMMLContextTest());
    }

    @Test
    public void getAlgorithmName() {
        Assert.assertNull((Object)KIE_PMML_MINING_MODEL.getAlgorithmName());
        String algorithmName = "algorithmName";
        KIE_PMML_MINING_MODEL = (KiePMMLMiningModel)BUILDER.withAlgorithmName(algorithmName).build();
        Assert.assertEquals((Object)algorithmName, (Object)KIE_PMML_MINING_MODEL.getAlgorithmName());
    }

    @Test
    public void isScorable() {
        Assert.assertTrue((boolean)KIE_PMML_MINING_MODEL.isScorable());
        KIE_PMML_MINING_MODEL = (KiePMMLMiningModel)BUILDER.withScorable(false).build();
        Assert.assertFalse((boolean)KIE_PMML_MINING_MODEL.isScorable());
    }

    @Test
    public void getSegmentation() {
        Assert.assertNull((Object)KIE_PMML_MINING_MODEL.getSegmentation());
        KiePMMLSegmentation segmentation = AbstractKiePMMLMiningModelTest.getKiePMMLSegmentation("SEGMENTATION_NAME");
        KIE_PMML_MINING_MODEL = (KiePMMLMiningModel)BUILDER.withSegmentation(segmentation).build();
        Assert.assertEquals((Object)segmentation, (Object)KIE_PMML_MINING_MODEL.getSegmentation());
    }
}

